# Image Generation Reference

OpenGraph.io's image generation API creates professional images via AI.

## Image Types (`kind`)

| Kind | Description | Best for |
|------|-------------|----------|
| `illustration` | General AI-generated images | Hero images, backgrounds, **premium QR marketing cards** |
| `diagram` | Technical diagrams from Mermaid/D2/Vega | Architecture, flows, ERDs |
| `icon` | App icons and logos | Branding, UI elements |
| `social-card` | OG images for social sharing | Blog posts, link previews |
| `qr-code` | Basic functional QR codes | Simple QR code generation |

## QR Code Options

**Basic QR Code** (`kind: "qr-code"`):  
Generates just the functional QR code with minimal styling. Use when you need to embed the code in your own designs.

**Premium QR Marketing Card** (`kind: "illustration"`):  
Generates a complete marketing asset with the QR code as part of a professionally designed composition - gradients, 3D elements, CTAs, device mockups, etc. Describe the full design in your prompt.

Example premium QR prompt:
```
"Premium marketing card with QR code for https://myapp.com, cosmic purple gradient 
with floating 3D spheres, glowing accents, 'SCAN TO DOWNLOAD' call-to-action"

kind: "illustration"
aspectRatio: "square"
outputStyle: "premium"
brandColors: ["#6B4CE6", "#9B6DFF"]
```

## Aspect Ratio Presets

### Social Media
| Preset | Dimensions | Use case |
|--------|------------|----------|
| `og-image` | 1200×630 | OpenGraph/Facebook |
| `twitter-card` | 1200×600 | Twitter cards |
| `twitter-post` | 1200×675 | Twitter posts |
| `linkedin-post` | 1200×627 | LinkedIn |
| `instagram-square` | 1080×1080 | Instagram feed |
| `instagram-portrait` | 1080×1350 | Instagram portrait |
| `instagram-story` | 1080×1920 | Instagram/TikTok stories |
| `youtube-thumbnail` | 1280×720 | YouTube |

### Standard
| Preset | Ratio | Use case |
|--------|-------|----------|
| `wide` | 16:9 | Presentations, banners |
| `square` | 1:1 | Avatars, thumbnails |
| `portrait` | 3:4 | Posters, mobile |

### Icons
| Preset | Size | Use case |
|--------|------|----------|
| `icon-small` | 64×64 | Favicons |
| `icon-medium` | 256×256 | App icons |
| `icon-large` | 512×512 | High-res icons |

## Style Presets

| Preset | Vibe |
|--------|------|
| `github-dark` | Dark mode, monospace, developer |
| `github-light` | Light mode, clean, minimal |
| `notion` | Warm, readable, productivity |
| `vercel` | Modern, gradient, sleek |
| `linear` | Purple accents, SaaS |
| `stripe` | Professional, fintech |
| `neon-cyber` | Cyberpunk, glowing |
| `pastel` | Soft, friendly |
| `minimal-mono` | Black/white, typography |
| `corporate` | Traditional, trustworthy |
| `startup` | Bold, energetic |
| `documentation` | Technical, clear |
| `technical` | Engineering, precise |

## Diagram Syntax

| Syntax | Description |
|--------|-------------|
| `mermaid` | Flowcharts, sequences, ERDs |
| `d2` | Declarative diagrams |
| `vega` | Data visualizations |

## Diagram Templates

Pre-built diagram structures:

| Template | Description |
|----------|-------------|
| `auth-flow` | Authentication sequence |
| `oauth2-flow` | OAuth 2.0 flow |
| `crud-api` | REST API structure |
| `microservices` | Service architecture |
| `ci-cd` | CI/CD pipeline |
| `gitflow` | Git branching strategy |
| `database-schema` | ERD structure |
| `state-machine` | State transitions |
| `user-journey` | User flow map |
| `cloud-architecture` | AWS/GCP/Azure setup |
| `system-context` | C4 context diagram |

## Quality Options

| Quality | Speed | Cost | Use case |
|---------|-------|------|----------|
| `fast` | ~5s | $ | Drafts, iteration |
| `low` | ~10s | $ | Quick previews |
| `medium` | ~20s | $$ | General use |
| `high` | ~40s | $$$ | Final assets |

## Output Styles

| Style | Description |
|-------|-------------|
| `draft` | Quick, unpolished |
| `standard` | Balanced quality |
| `premium` | Polished, production-ready |

## Example Prompts

### Social Card
```
Generate a social card for "How to Build AI Agents" 
- kind: social-card
- aspectRatio: og-image
- stylePreset: vercel
- brandColors: ["#0070F3", "#000000"]
```

### Architecture Diagram
```
Create a diagram: graph TD; User-->API; API-->Auth; API-->DB
- kind: diagram
- diagramSyntax: mermaid
- stylePreset: github-dark
- diagramTemplate: microservices
```

### App Icon
```
Generate a modern fintech app icon with a dollar sign
- kind: icon
- aspectRatio: icon-large
- stylePreset: stripe
```

## Iteration

Refine images by referencing the `sessionId` and `assetId`:

```
"Change the background to blue" (with sessionId/assetId)
"Add a gradient" 
"Remove the text"
"Make it more minimal"
```

## Pricing

Costs are per-generation and vary by quality/complexity:
- Icons: ~$0.01–$0.05
- Diagrams: ~$0.01–$0.02
- Illustrations: ~$0.10–$0.20
- Premium output: +50%

Usage is tracked via your OpenGraph.io dashboard.
