# OpenGraph.io Skill Examples

Real examples generated with the OpenGraph.io skill.

---

## 1. Hero Banner

**Prompt:**
> "Premium hero banner for OpenGraph.io MCP service. Dark gradient background from deep navy to black. Center shows 'OpenGraph.io' wordmark in clean white typography. Below it, five elegant glass-morphism icon cards in a horizontal row representing the core features: Link/URL icon (unfurl), Camera icon (screenshot), Code brackets (scrape), Brain/AI icon (query), and Paintbrush/Image icon (generate). Subtle glowing blue and purple accent lines connecting the icons. Modern, professional SaaS aesthetic."

**Settings:**
- kind: `social-card`
- aspectRatio: `og-image` (1200×630)
- stylePreset: `vercel`
- brandColors: `["#6366F1", "#8B5CF6", "#0F172A"]`
- quality: `high`

**Result:**

![OpenGraph.io Hero](https://raw.githubusercontent.com/securecoders/opengraph-io-skill/main/examples/opengraph-hero.jpg)

---

## 2. OpenGraph.io Social Card

**Prompt:**
> "A modern social media card for OpenGraph.io - a web data extraction and AI image generation API. Show icons for link/URL, screenshot camera, code brackets, and sparkles for AI. Use a dark gradient background with blue and purple accents."

**Settings:**
- kind: `social-card`
- aspectRatio: `og-image` (1200×630)
- stylePreset: `vercel`
- quality: `high`

**Result:**

![OpenGraph.io Social Card](https://raw.githubusercontent.com/securecoders/opengraph-io-skill/main/examples/social-card.jpg)

---

## 3. Architecture Diagram

**Prompt:**
> "Clean, professional enterprise architecture diagram. Crisp white background with blue (#0071CE) as primary color and yellow (#FFC220) accents. Horizontal flow: Left shows 'AI Assistant' card with Claude, Cursor, VSCode. Center shows 'MCP Server Tool Router' hub. Right shows 5 API service cards: Unfurl, Screenshot, Scrape, Query, Image Gen. Clean blue connecting lines with subtle yellow spark highlights at connection points. Flat design, minimal shadows, professional corporate aesthetic."

**Settings:**
- kind: `social-card`
- aspectRatio: `og-image` (1200×630)
- stylePreset: `corporate`
- brandColors: `["#0071CE", "#FFC220", "#FFFFFF"]`
- quality: `high`

**Result:**

![Architecture Diagram](https://raw.githubusercontent.com/securecoders/opengraph-io-skill/main/examples/architecture-diagram.png)

---

## 4. Gig-Economy Promo Card

**Prompt:**
> "Premium OpenGraph card for DashDrop grocery delivery app signup promotion. Fresh, clean aesthetic with vibrant green gradient background. Friendly delivery person carrying a paper grocery bag with fresh vegetables visible. Bold 'DashDrop' wordmark at top. Headline 'First 10 Deliveries FREE' prominently displayed. Include subtle illustrations of fresh produce (carrots, apples, leafy greens). Modern app-style design with rounded corners and soft shadows. Warm, inviting, and trustworthy feel."

**Settings:**
- kind: `social-card`
- aspectRatio: `og-image` (1200×630)
- stylePreset: `startup`
- brandColors: `["#0AAD05", "#FF7009", "#003D29"]`
- quality: `high`

**Result:**

![DashDrop Promo Card](https://raw.githubusercontent.com/securecoders/opengraph-io-skill/main/examples/dashdrop-card.jpg)

---

## 5. Web Data Extraction

**Task:** Extract metadata and capture screenshot from SecureCoders.com

### OpenGraph Data
```json
{
  "title": "SecureCoders - Expert Cybersecurity Services & Penetration Testing",
  "description": "Protect your business with expert cybersecurity services...",
  "image": "https://securecoders.com/sc-icon-large.webp",
  "type": "website"
}
```

### Screenshot
![SecureCoders Screenshot](https://og-screenshots-prod.s3.amazonaws.com/1366x768/light/banner_block/partial_page/80/40776f4af51dec793046ffb507fefac2197ec353b5921864d2edb616275e897e/none/none.jpeg)

---

## 6. Web Scraping with Proxy

**Task:** Scrape weather.com through a residential proxy to avoid geo-blocking

**Request:**
```
"Scrape https://weather.com with proxy enabled"
```

**API Call:**
```
GET /scrape/https%3A%2F%2Fweather.com?app_id=XXX&use_proxy=true
```

**Response (truncated):**
```json
{
  "htmlContent": "<!DOCTYPE html><html lang=\"en-US\"><head><meta charset=\"utf-8\"/>...",
  "url": "https://weather.com/",
  "statusCode": 200,
  "contentType": "text/html; charset=utf-8",
  "contentLength": 2830768
}
```

**Use Cases:**
- Scraping sites with geo-restrictions
- Avoiding rate limiting on high-volume requests
- Accessing region-specific content
- Bypassing bot detection

---

## 7. App Marketing Card with QR Code

**Prompt:**
> "Premium app marketing card for TaskFlow productivity app. Dark gradient background from navy to black. Left side shows iPhone mockup displaying the TaskFlow app interface with a clean task list UI. Center has bold headline 'TaskFlow' with tagline 'Organize Your Life'. Right side features a prominent QR code with 'Scan to Download' text and App Store badge below. Scattered decorative elements: checkmarks, calendar icons, productivity symbols. Modern SaaS aesthetic with blue and purple accent glows. Professional app store marketing quality."

**Settings:**
- kind: `social-card`
- aspectRatio: `og-image` (1200×630)
- stylePreset: `vercel`
- brandColors: `["#6366F1", "#8B5CF6", "#0F172A"]`
- quality: `high`

**Result:**

![TaskFlow App Marketing Card](https://raw.githubusercontent.com/securecoders/opengraph-io-skill/main/examples/qr-code.png)

---

## Try These Prompts

### Social Cards
- "Create a launch announcement card for a new AI product"
- "Generate a blog post header about machine learning"
- "Design a Twitter card for a tech conference"

### Diagrams
- "Create a CI/CD pipeline diagram: Code → Build → Test → Deploy → Monitor"
- "Generate an OAuth2 authentication flow"
- "Design a microservices architecture for an e-commerce app"

### Icons
- "A modern app icon for a productivity tool"
- "A minimalist logo for a cloud storage service"
- "A fintech app icon with a dollar sign"

### QR Codes
- "Generate a QR code for https://opengraph.io with tech styling"
- "Create a branded QR code with gradient background"

---

## Iteration Example

Start with a basic icon, then refine:

1. **Initial:** "A simple cloud icon"
2. **Iterate:** "Add a gradient from blue to purple"
3. **Iterate:** "Make it more 3D with subtle shadows"
4. **Iterate:** "Add small sparkles around it"

Each iteration builds on the previous asset, maintaining consistency while improving.
