# OpenGraph.io Skill for Clawdbot

<p align="center">
  <img src="examples/opengraph-hero.jpg" alt="OpenGraph.io - Extract, Screenshot, Scrape, Query, Generate" width="700">
</p>

<p align="center">
  <a href="https://www.opengraph.io">Website</a> •
  <a href="https://dashboard.opengraph.io">Get API Key</a> •
  <a href="https://www.opengraph.io/documentation">API Docs</a>
</p>

---

## What is this?

A [Clawdbot](https://github.com/clawdbot/clawdbot) skill that gives your AI assistant the power to:

- 🔗 **Extract OpenGraph data** — Get titles, descriptions, images from any URL
- 📸 **Capture screenshots** — Render webpages as images
- 🌐 **Scrape content** — Fetch HTML with JavaScript rendering
- 🔍 **Extract elements** — Pull specific HTML elements (h1, p, etc.)
- 🤖 **Query pages** — Ask AI questions about any webpage
- 🎨 **Generate images** — Create diagrams, icons, social cards, QR codes

## Quick Start

### 1. Get your API key

Sign up at [dashboard.opengraph.io](https://dashboard.opengraph.io) and copy your App ID.

### 2. Install the skill

```bash
clawdbot skill install opengraph-io
```

### 3. Configure your API key

**Option A: Clawdbot config** (recommended)
```bash
clawdbot configure --section skills
# Select opengraph-io, enter your App ID
```

**Option B: Environment variable**
```bash
export OPENGRAPH_APP_ID="your-app-id"
```

**Option C: Config file**
```json5
// ~/.clawdbot/clawdbot.json
{
  "skills": {
    "entries": {
      "opengraph-io": {
        "apiKey": "your-app-id"
      }
    }
  }
}
```

### 4. Use it!

Just ask your AI assistant:

```
"Get the OG tags from https://github.com"
"Screenshot https://securecoders.com"  
"Generate a diagram: graph TD; A-->B-->C"
"Create a social card for my blog post about AI"
```

## Features

### Web Data Extraction

| Capability | Description |
|------------|-------------|
| **Unfurl URLs** | Extract OpenGraph, Twitter Cards, meta tags |
| **Screenshot** | Capture full-page or viewport screenshots |
| **Scrape** | Fetch HTML with JS rendering and proxy support |
| **Extract** | Pull specific elements in structured format |
| **Query** | Ask questions, get AI-powered answers |

### AI Image Generation

| Type | Examples |
|------|----------|
| **Diagrams** | Mermaid flowcharts, architecture diagrams, ERDs |
| **Icons** | App icons, logos, symbols |
| **Social Cards** | OG images, Twitter cards, LinkedIn banners |
| **QR Codes** | Styled QR codes with branding |
| **Illustrations** | Hero images, backgrounds, artwork |

**Style presets:** `github-dark`, `vercel`, `stripe`, `linear`, `neon-cyber`, and more.

**Aspect ratios:** `og-image`, `twitter-card`, `instagram-story`, `youtube-thumbnail`, and more.

## For Other AI Clients (MCP)

This skill wraps [opengraph-io-mcp](https://github.com/securecoders/opengraph-io-mcp), which works with any MCP-compatible client:

```bash
# Interactive setup for Cursor, Claude Desktop, VS Code, etc.
npx opengraph-io-mcp --client cursor --app-id YOUR_APP_ID
```

See [references/mcp-clients.md](references/mcp-clients.md) for detailed setup guides.

## Documentation

- [SKILL.md](SKILL.md) — Main skill documentation
- [references/image-generation.md](references/image-generation.md) — Image gen presets, styles, templates
- [references/mcp-clients.md](references/mcp-clients.md) — Setup for Claude, Cursor, VS Code, etc.

## Examples

### Extract metadata
```
User: "What's the OG image for https://stripe.com?"
Assistant: [fetches and returns OpenGraph data including image URL]
```

### Generate a diagram
```
User: "Create an architecture diagram for: User -> API Gateway -> Auth Service -> Database"
Assistant: [generates styled Mermaid diagram as PNG]
```

### Screenshot a page
```
User: "Screenshot https://linear.app and save it"
Assistant: [captures screenshot, provides image]
```

### Ask about a page
```
User: "What pricing tiers does https://notion.so offer?"
Assistant: [queries page with AI, returns structured answer]
```

### Scrape with proxy
```
User: "Scrape https://weather.com with proxy enabled"
Assistant: [fetches full HTML content via residential proxy, returns page data]
```

## Pricing

| Feature | Free Tier | Paid Plans |
|---------|-----------|------------|
| Web extraction (unfurl, scrape, screenshot) | ✅ 100/month | Unlimited |
| AI Query | ❌ | ✅ |
| **Image Generation** | ✅ **4/month** | Unlimited |

> **🎉 Try it free!** Get 4 premium image generations per month — no credit card required. [Sign up →](https://dashboard.opengraph.io/register)

### Paid Plans

| Plan | Requests/month | Price |
|------|----------------|-------|
| Starter | 10,000 | $29/mo |
| Growth | 100,000 | $99/mo |
| Enterprise | Unlimited | Custom |

Image generation: ~$0.01–$0.15 per image (billed separately via credits).

## Generated Examples

### OpenGraph.io Social Card

<p align="center">
  <img src="examples/social-card.jpg" alt="OpenGraph.io Social Card" width="600">
</p>

```
Generate a social card for OpenGraph.io - a web data extraction and AI image 
generation API. Include icons representing links/URLs, screenshots, code, and 
AI sparkles. Use a dark gradient background with blue and purple accents. 
Style: vercel, aspect ratio: og-image
```

### Architecture Diagram

<p align="center">
  <img src="examples/architecture-diagram.png" alt="Architecture Diagram" width="600">
</p>

```
Clean, professional enterprise architecture diagram. Crisp white background 
with blue (#0071CE) as primary color and yellow (#FFC220) accents. 
Horizontal flow: Left shows 'AI Assistant' card with Claude, Cursor, VSCode. 
Center shows 'MCP Server Tool Router' hub. Right shows 5 API service cards: 
Unfurl, Screenshot, Scrape, Query, Image Gen. Clean blue connecting lines 
with subtle yellow spark highlights at connection points. Flat design, 
minimal shadows, professional corporate aesthetic.

kind: social-card, aspectRatio: og-image, stylePreset: corporate,
brandColors: ["#0071CE", "#FFC220", "#FFFFFF"], quality: high
```

### DashDrop Signup Promo Card

<p align="center">
  <img src="examples/dashdrop-card.jpg" alt="DashDrop Gig Economy Signup Card" width="600">
</p>

```
Premium OpenGraph card for DashDrop grocery delivery app signup promotion. 
Fresh, clean aesthetic with vibrant green gradient background. Friendly 
delivery person carrying a paper grocery bag with fresh vegetables visible. 
Bold 'DashDrop' wordmark at top. Headline 'First 10 Deliveries FREE' 
prominently displayed. Include subtle illustrations of fresh produce 
(carrots, apples, leafy greens). Modern app-style design with rounded 
corners and soft shadows. Warm, inviting, and trustworthy feel.

kind: social-card, aspectRatio: og-image, stylePreset: startup,
brandColors: ["#0AAD05", "#FF7009", "#003D29"], quality: high
```

### Web Scraping with Proxy

Scrape geo-restricted or bot-protected sites through residential proxies:

```
User: "Scrape https://weather.com with proxy enabled"

API: GET /scrape/{url}?app_id=XXX&use_proxy=true

Response:
{
  "htmlContent": "<!DOCTYPE html><html>...",
  "url": "https://weather.com/",
  "statusCode": 200,
  "contentLength": 2830768
}
```

### App Marketing Card with QR Code

<p align="center">
  <img src="examples/qr-code.png" alt="TaskFlow App Marketing Card" width="600">
</p>

```
Premium app marketing card for TaskFlow productivity app. Dark gradient 
background. Left side shows iPhone mockup displaying the app interface. 
Center has 'TaskFlow' headline with tagline 'Organize Your Life'. Right 
side features QR code with 'Scan to Download' and App Store badge. 
Decorative productivity icons. Modern SaaS aesthetic.

kind: social-card, aspectRatio: og-image, stylePreset: vercel,
brandColors: ["#6366F1", "#8B5CF6", "#0F172A"], quality: high
```

See [examples/EXAMPLES.md](examples/EXAMPLES.md) for more prompts, settings, and details.

## Support

- 📖 [OpenGraph.io Documentation](https://www.opengraph.io/documentation)
- 💬 [Clawdbot Discord](https://discord.com/invite/clawd)
- 🐛 [Report Issues](https://github.com/securecoders/opengraph-io-skill/issues)

## License

MIT

---

<p align="center">
  Made with 🎯 by <a href="https://securecoders.com">SecureCoders</a>
</p>
