"""
Real Estate Closer Playbook — $79/month

20 plays for real estate: lead qualification, showing scheduling,
offer negotiation, and referral generation.
"""

REAL_ESTATE_PLAYBOOK = {
    "id": "real_estate",
    "name": "Real Estate Closer",
    "price": 79.0,
    "plays": [
        {
            "name": "lead_qualification_speed",
            "phase": "discovery",
            "description": "Qualify real estate leads in under 2 minutes.",
            "hints": [
                "Ask: buying/selling/both, timeline, budget range, areas",
                "Pre-approved or needs financing?",
                "First-time buyer or experienced?",
                "Motivated seller or just testing the market?",
            ],
            "tone": "efficient",
            "yield_impact": 25.0,
        },
        {
            "name": "showing_scheduler",
            "phase": "engagement",
            "description": "Convert interest into scheduled showings instantly.",
            "hints": [
                "Offer 3 time slots instead of 'when works for you?'",
                "Same-day or next-day showings convert 4x higher",
                "Send property details + neighborhood info before showing",
                "Confirm 1 hour before to reduce no-shows",
            ],
            "tone": "proactive",
            "yield_impact": 30.0,
        },
        {
            "name": "neighborhood_expert",
            "phase": "engagement",
            "description": "Position as the neighborhood expert to build trust.",
            "hints": [
                "Share school ratings, walkability scores, commute times",
                "Know local restaurants, parks, and community vibe",
                "Provide recent comparable sales data",
                "Share insider knowledge: upcoming developments, market trends",
            ],
            "tone": "knowledgeable",
            "yield_impact": 20.0,
        },
        {
            "name": "offer_strategy_coach",
            "phase": "negotiation",
            "description": "Guide buyers through offer strategy in competitive markets.",
            "hints": [
                "Analyze comps and suggest competitive offer price",
                "Discuss escalation clause strategy",
                "Recommend contingency flexibility based on market",
                "Prepare multiple offer scenarios (best case / competitive / aggressive)",
            ],
            "tone": "strategic",
            "yield_impact": 45.0,
        },
        {
            "name": "pre_approval_nudge",
            "phase": "discovery",
            "description": "Get unqualified leads pre-approved before wasting time.",
            "hints": [
                "Explain why pre-approval matters in competitive markets",
                "Connect with preferred lender for fast process",
                "Frame as empowering: 'Know exactly what you can afford'",
                "Follow up on pre-approval status within 48 hours",
            ],
            "tone": "helpful",
            "yield_impact": 20.0,
        },
        {
            "name": "listing_presentation",
            "phase": "engagement",
            "description": "Win the listing with compelling market positioning.",
            "hints": [
                "Lead with recent comparable sales in their neighborhood",
                "Show your marketing plan: professional photos, staging, digital",
                "Present pricing strategy with data (not opinion)",
                "Show testimonials from recent sellers",
            ],
            "tone": "professional",
            "yield_impact": 55.0,
        },
        {
            "name": "price_reduction_conversation",
            "phase": "negotiation",
            "description": "Navigate price reductions with data, not emotion.",
            "hints": [
                "Present market data: days on market, showing activity",
                "Show what similar homes sold for vs listed",
                "Suggest strategic reduction amount (not too small)",
                "Reframe: 'Attract a new pool of buyers at this price point'",
            ],
            "tone": "honest",
            "yield_impact": 25.0,
        },
        {
            "name": "multiple_offer_orchestration",
            "phase": "negotiation",
            "description": "Manage multiple offers for maximum seller value.",
            "hints": [
                "Transparently communicate: 'We have multiple offers'",
                "Compare offers on all terms, not just price",
                "Ask top bidders for 'highest and best'",
                "Consider backup offer acceptance for security",
            ],
            "tone": "strategic",
            "yield_impact": 50.0,
        },
        {
            "name": "inspection_negotiation",
            "phase": "negotiation",
            "description": "Navigate inspection findings without killing the deal.",
            "hints": [
                "Categorize: safety issues vs cosmetic vs preference",
                "Prioritize: what's worth negotiating vs letting go",
                "Get repair estimates before making requests",
                "Offer alternatives: credit vs repair vs as-is with price adjustment",
            ],
            "tone": "pragmatic",
            "yield_impact": 30.0,
        },
        {
            "name": "closing_timeline_manager",
            "phase": "closing",
            "description": "Keep deals on track through the closing process.",
            "hints": [
                "Create a shared timeline with all parties",
                "Proactively check on: appraisal, title, lender, insurance",
                "Weekly status updates to all parties",
                "Have backup solutions for common delays",
            ],
            "tone": "organized",
            "yield_impact": 15.0,
        },
        {
            "name": "investor_client_portfolio",
            "phase": "engagement",
            "description": "Build ongoing relationships with investor clients.",
            "hints": [
                "Understand their criteria: ROI targets, property types, areas",
                "Send deal analysis proactively when matching listings appear",
                "Calculate cap rates and cash-on-cash returns",
                "Position as their 'deal pipeline' in the market",
            ],
            "tone": "analytical",
            "yield_impact": 40.0,
        },
        {
            "name": "first_time_buyer_guide",
            "phase": "discovery",
            "description": "Build trust with first-time buyers through education.",
            "hints": [
                "Explain the process step by step (they don't know what they don't know)",
                "Set expectations: timeline, costs, what-ifs",
                "Connect with first-time buyer programs and grants",
                "Be patient — education builds lifetime referral sources",
            ],
            "tone": "patient",
            "yield_impact": 20.0,
        },
        {
            "name": "referral_at_closing",
            "phase": "post_close",
            "description": "Capture referrals at the peak emotional moment of closing.",
            "hints": [
                "Celebrate the closing with a small gift",
                "Ask: 'Know anyone else looking to buy or sell?'",
                "Offer referral incentive: gift card, donation to their charity",
                "Add to long-term nurture campaign",
            ],
            "tone": "celebratory",
            "yield_impact": 35.0,
        },
        {
            "name": "sphere_of_influence_nurture",
            "phase": "post_close",
            "description": "Stay top of mind with past clients for repeat and referral.",
            "hints": [
                "Annual home value update: 'Your home is now worth...'",
                "Quarterly market update for their neighborhood",
                "Anniversary cards and milestone acknowledgments",
                "Home maintenance tips and seasonal reminders",
            ],
            "tone": "caring",
            "yield_impact": 25.0,
        },
        {
            "name": "open_house_conversion",
            "phase": "engagement",
            "description": "Convert open house visitors into clients.",
            "hints": [
                "Capture contact info with sign-in (offer market report)",
                "Ask qualifying questions during the tour",
                "For non-buyers of this home: 'What are you looking for?'",
                "Follow up within 2 hours of the open house",
            ],
            "tone": "engaging",
            "yield_impact": 20.0,
        },
        {
            "name": "relocation_specialist",
            "phase": "discovery",
            "description": "Capture relocation clients with comprehensive area expertise.",
            "hints": [
                "Provide relocation package: neighborhoods, schools, employers",
                "Offer virtual tours for out-of-state buyers",
                "Connect with relocation companies and employers",
                "Coordinate across timezones for showings and closings",
            ],
            "tone": "accommodating",
            "yield_impact": 35.0,
        },
        {
            "name": "expired_listing_capture",
            "phase": "opening",
            "description": "Win expired listing owners with a fresh strategy.",
            "hints": [
                "Lead with 'I noticed your listing expired. What happened?'",
                "Diagnose: pricing, marketing, agent, or market issue",
                "Present a different marketing strategy",
                "Show comparable success stories",
            ],
            "tone": "consultative",
            "yield_impact": 30.0,
        },
        {
            "name": "downsizer_transition",
            "phase": "discovery",
            "description": "Handle the emotional transition for downsizers.",
            "hints": [
                "Acknowledge the emotional weight of selling a long-time home",
                "Focus on lifestyle benefits of the move",
                "Help with timeline: sell first vs buy first strategy",
                "Connect with moving services and estate sale companies",
            ],
            "tone": "empathetic",
            "yield_impact": 25.0,
        },
        {
            "name": "luxury_market_positioning",
            "phase": "engagement",
            "description": "Position effectively in the luxury market segment.",
            "hints": [
                "Emphasize privacy and discretion",
                "Professional staging and photography are non-negotiable",
                "Exclusive showings over open houses",
                "Network-based marketing over public listings",
            ],
            "tone": "exclusive",
            "yield_impact": 45.0,
        },
        {
            "name": "appraisal_gap_strategy",
            "phase": "negotiation",
            "description": "Navigate appraisal gaps in hot markets.",
            "hints": [
                "Prepare buyer for possible gap before it happens",
                "Discuss appraisal gap coverage in advance",
                "Challenge low appraisals with comp data",
                "Negotiate: split the gap, seller concession, or restructure",
            ],
            "tone": "strategic",
            "yield_impact": 30.0,
        },
    ],
}
