"""
Healthcare Engagement Playbook — $99/month

18 plays for healthcare: appointment booking, treatment adherence,
patient satisfaction, and insurance navigation.
"""

HEALTHCARE_PLAYBOOK = {
    "id": "healthcare",
    "name": "Healthcare Engagement",
    "price": 99.0,
    "plays": [
        {
            "name": "appointment_booking_optimizer",
            "phase": "engagement",
            "description": "Reduce booking friction and no-shows.",
            "hints": [
                "Offer 3 specific time slots instead of open-ended",
                "Same-week availability shown first",
                "Send immediate confirmation with prep instructions",
                "24-hour reminder with easy reschedule option (not cancel)",
            ],
            "tone": "helpful",
            "yield_impact": 25.0,
        },
        {
            "name": "symptom_triage",
            "phase": "discovery",
            "description": "Intelligent symptom assessment for appropriate routing.",
            "hints": [
                "Ask structured symptom questions (onset, severity, duration)",
                "Route to appropriate care level: urgent, same-day, scheduled",
                "Flag emergency symptoms with clear escalation path",
                "Provide interim self-care guidance while waiting",
            ],
            "tone": "calm",
            "yield_impact": 20.0,
        },
        {
            "name": "insurance_navigator",
            "phase": "discovery",
            "description": "Help patients navigate insurance and cost questions.",
            "hints": [
                "Ask for insurance provider and plan type upfront",
                "Verify coverage for requested service before booking",
                "Provide cost estimate: 'With your plan, expect approximately...'",
                "Offer self-pay rates for uninsured (often competitive)",
            ],
            "tone": "informative",
            "yield_impact": 15.0,
        },
        {
            "name": "treatment_adherence_coach",
            "phase": "post_close",
            "description": "Improve treatment adherence with proactive follow-up.",
            "hints": [
                "Send medication reminders with dosage and timing",
                "Check in on side effects: 'How are you feeling on the new treatment?'",
                "Celebrate adherence milestones: '30 days consistent!'",
                "Connect with pharmacist for medication questions",
            ],
            "tone": "supportive",
            "yield_impact": 20.0,
        },
        {
            "name": "preventive_care_scheduler",
            "phase": "engagement",
            "description": "Drive preventive care visits for better outcomes and revenue.",
            "hints": [
                "Track and remind: annual physical, screenings, vaccinations",
                "Personalize by age, gender, and risk factors",
                "Frame as empowering: 'Catching things early saves lives'",
                "Bundle preventive visits: 'While you're here for X, let's also...'",
            ],
            "tone": "caring",
            "yield_impact": 25.0,
        },
        {
            "name": "patient_satisfaction_recovery",
            "phase": "post_close",
            "description": "Intercept and recover dissatisfied patients before they leave.",
            "hints": [
                "Post-visit survey within 24 hours (keep it short: 3 questions)",
                "For negative feedback: immediate outreach from practice manager",
                "Diagnose: wait time, bedside manner, billing, or outcome issue",
                "Offer concrete resolution and follow-up",
            ],
            "tone": "empathetic",
            "yield_impact": 30.0,
        },
        {
            "name": "new_patient_onboarding",
            "phase": "opening",
            "description": "Frictionless onboarding for new patients.",
            "hints": [
                "Digital intake forms before first visit",
                "Welcome message with what to expect",
                "Request records transfer from previous provider",
                "Assign care coordinator for complex patients",
            ],
            "tone": "welcoming",
            "yield_impact": 15.0,
        },
        {
            "name": "telehealth_conversion",
            "phase": "engagement",
            "description": "Convert appropriate visits to telehealth for efficiency.",
            "hints": [
                "Identify visit types suitable for virtual: follow-ups, consults",
                "Highlight convenience: 'See your doctor from home in 15 min'",
                "Ensure tech readiness: 'Do you have a phone or computer with camera?'",
                "Offer hybrid: 'Start virtual, come in only if needed'",
            ],
            "tone": "modern",
            "yield_impact": 18.0,
        },
        {
            "name": "specialist_referral_bridge",
            "phase": "engagement",
            "description": "Smooth the referral process to reduce drop-off.",
            "hints": [
                "Book specialist appointment before the patient leaves",
                "Transfer relevant records and context to specialist",
                "Follow up: 'How did your appointment with Dr. X go?'",
                "Close the loop: share specialist findings with PCP",
            ],
            "tone": "coordinated",
            "yield_impact": 22.0,
        },
        {
            "name": "chronic_condition_engagement",
            "phase": "engagement",
            "description": "Long-term engagement for chronic condition management.",
            "hints": [
                "Regular check-ins aligned with condition management goals",
                "Track and celebrate health metrics improvements",
                "Connect with support groups and educational resources",
                "Coordinate care across multiple providers",
            ],
            "tone": "partnership",
            "yield_impact": 30.0,
        },
        {
            "name": "no_show_recovery",
            "phase": "engagement",
            "description": "Re-engage patients who missed appointments.",
            "hints": [
                "Reach out within 1 hour of missed appointment",
                "No judgment: 'We missed you today! Everything ok?'",
                "Offer immediate rescheduling with convenient options",
                "Identify pattern no-shows for targeted intervention",
            ],
            "tone": "caring",
            "yield_impact": 20.0,
        },
        {
            "name": "billing_transparency",
            "phase": "post_close",
            "description": "Proactive billing communication to prevent payment issues.",
            "hints": [
                "Send cost breakdown before or right after visit",
                "Explain insurance adjustments in plain language",
                "Offer payment plans for large balances",
                "Connect with financial assistance programs if needed",
            ],
            "tone": "transparent",
            "yield_impact": 15.0,
        },
        {
            "name": "family_practice_expansion",
            "phase": "post_close",
            "description": "Expand from individual patient to entire family.",
            "hints": [
                "'Are your family members also looking for a provider?'",
                "Offer family scheduling: 'Book everyone on the same day'",
                "Pediatric + adult care under one roof",
                "Family health history creates better care for all",
            ],
            "tone": "warm",
            "yield_impact": 25.0,
        },
        {
            "name": "post_procedure_care",
            "phase": "post_close",
            "description": "Post-procedure follow-up for better outcomes and satisfaction.",
            "hints": [
                "Day 1: 'How are you feeling after your procedure?'",
                "Provide recovery timeline and expectations",
                "Flag concerning symptoms with clear escalation",
                "Schedule follow-up visit before they leave",
            ],
            "tone": "attentive",
            "yield_impact": 18.0,
        },
        {
            "name": "elective_procedure_consultation",
            "phase": "negotiation",
            "description": "Guide patients through elective procedure decisions.",
            "hints": [
                "Provide detailed information: procedure, recovery, results",
                "Show before/after examples (where appropriate)",
                "Discuss financing options for cosmetic/elective",
                "Offer free consultation to remove decision friction",
            ],
            "tone": "informative",
            "yield_impact": 40.0,
        },
        {
            "name": "patient_portal_adoption",
            "phase": "post_close",
            "description": "Drive patient portal adoption for engagement and efficiency.",
            "hints": [
                "Show value: 'View results, message your doctor, request refills'",
                "Help with setup: 'It takes 2 minutes, let me walk you through it'",
                "Send first message through portal to create habit",
                "Use portal for appointment reminders and results",
            ],
            "tone": "encouraging",
            "yield_impact": 12.0,
        },
        {
            "name": "wellness_program_enrollment",
            "phase": "engagement",
            "description": "Enroll patients in wellness and prevention programs.",
            "hints": [
                "Identify at-risk patients who benefit most",
                "Frame as partnership: 'Let's work on this together'",
                "Show evidence: 'Patients in this program see X improvement'",
                "Make enrollment effortless: opt-in with one click",
            ],
            "tone": "motivating",
            "yield_impact": 22.0,
        },
        {
            "name": "review_and_reputation",
            "phase": "post_close",
            "description": "Build online reputation through satisfied patient reviews.",
            "hints": [
                "Ask for review after positive interactions only",
                "Make it easy: direct link to Google/Healthgrades",
                "Respond to all reviews (positive and negative) professionally",
                "Share positive reviews on website and social media",
            ],
            "tone": "grateful",
            "yield_impact": 15.0,
        },
    ],
}
