"""
E-Commerce Revenue Max Playbook — $39/month

22 plays for online retail: cart recovery, upsell cascades,
review harvesting, and repeat purchase optimization.
"""

ECOMMERCE_PLAYBOOK = {
    "id": "ecommerce",
    "name": "E-Commerce Revenue Max",
    "price": 39.0,
    "plays": [
        {
            "name": "cart_abandonment_rescue",
            "phase": "closing",
            "description": "Rescue abandoned carts with strategic re-engagement.",
            "hints": [
                "Acknowledge: 'I see you were looking at [product]'",
                "Address the likely objection: price, shipping, or trust",
                "Offer free shipping or small discount as incentive",
                "Create mild urgency: 'Only 3 left in stock'",
            ],
            "tone": "helpful",
            "yield_impact": 35.0,
        },
        {
            "name": "product_recommendation_cascade",
            "phase": "engagement",
            "description": "Guide shoppers through a recommendation funnel.",
            "hints": [
                "Ask 2-3 qualifying questions to narrow preferences",
                "Present 3 options using decoy pricing (good/better/best)",
                "Show most popular choice: 'Customers like you chose...'",
                "Offer 'complete the look' bundle after selection",
            ],
            "tone": "enthusiastic",
            "yield_impact": 28.0,
        },
        {
            "name": "upsell_at_cart",
            "phase": "closing",
            "description": "Smart upselling when items are already in cart.",
            "hints": [
                "Recommend complementary items, not competing ones",
                "'Customers who bought X also loved Y' (social proof)",
                "Show bundle savings: 'Save 15% when you add...'",
                "Keep the upsell under 30% of cart value",
            ],
            "tone": "suggestive",
            "yield_impact": 22.0,
        },
        {
            "name": "first_time_buyer_welcome",
            "phase": "opening",
            "description": "Convert first-time visitors into buyers with welcome flow.",
            "hints": [
                "Offer first-purchase discount (10-15%)",
                "Highlight free returns to reduce risk",
                "Show trust signals: reviews, guarantees, secure checkout",
                "Capture email even if they don't buy today",
            ],
            "tone": "warm",
            "yield_impact": 20.0,
        },
        {
            "name": "size_fit_confidence",
            "phase": "engagement",
            "description": "Remove sizing/fit anxiety that kills fashion conversions.",
            "hints": [
                "Ask about their usual size in other brands",
                "Provide specific measurements, not just S/M/L",
                "Show reviews from people with similar body type",
                "Highlight easy returns policy",
            ],
            "tone": "helpful",
            "yield_impact": 25.0,
        },
        {
            "name": "review_harvest",
            "phase": "post_close",
            "description": "Capture reviews at peak satisfaction moments.",
            "hints": [
                "Time the ask: 3-7 days after delivery",
                "Make it effortless: star rating + one sentence",
                "Incentivize: 'Leave a review, get 10% off next order'",
                "Follow up with photo request for 5-star reviews",
            ],
            "tone": "grateful",
            "yield_impact": 15.0,
        },
        {
            "name": "repeat_purchase_trigger",
            "phase": "post_close",
            "description": "Trigger repeat purchases based on consumption patterns.",
            "hints": [
                "Estimate product depletion/wear date",
                "Send reminder: 'Time to restock your [product]?'",
                "Offer subscription/auto-reorder option",
                "Show what's new since their last purchase",
            ],
            "tone": "helpful",
            "yield_impact": 30.0,
        },
        {
            "name": "shipping_objection_handler",
            "phase": "negotiation",
            "description": "Handle shipping cost objections without killing margin.",
            "hints": [
                "Show free shipping threshold: 'Add $12 more for free shipping'",
                "Recommend an item that crosses the threshold",
                "Compare: shipping cost vs product value",
                "Offer slower free shipping with paid express option",
            ],
            "tone": "helpful",
            "yield_impact": 18.0,
        },
        {
            "name": "gift_buyer_optimization",
            "phase": "engagement",
            "description": "Optimize for gift buyers — higher spend, lower returns.",
            "hints": [
                "Ask: 'Is this a gift for someone special?'",
                "Offer gift wrapping (high margin add-on)",
                "Suggest popular gift sets and bundles",
                "Capture both buyer AND recipient as customers",
            ],
            "tone": "warm",
            "yield_impact": 25.0,
        },
        {
            "name": "loyalty_program_enrollment",
            "phase": "post_close",
            "description": "Enroll satisfied buyers in loyalty program.",
            "hints": [
                "Show points earned from current purchase",
                "Preview rewards they're close to unlocking",
                "Make enrollment instant: one click, no forms",
                "Highlight exclusive member benefits",
            ],
            "tone": "exciting",
            "yield_impact": 20.0,
        },
        {
            "name": "flash_sale_urgency",
            "phase": "engagement",
            "description": "Create urgency during time-limited promotions.",
            "hints": [
                "Show countdown timer and remaining inventory",
                "Highlight savings vs regular price",
                "Limit quantity per customer to increase perceived value",
                "Show how many others are viewing the same item",
            ],
            "tone": "urgent",
            "yield_impact": 30.0,
        },
        {
            "name": "returns_to_exchange",
            "phase": "engagement",
            "description": "Convert return requests into exchanges (retain revenue).",
            "hints": [
                "Ask why they're returning before processing",
                "For wrong size/color: offer instant exchange",
                "For dissatisfaction: recommend a better alternative",
                "Offer store credit bonus over refund: '$55 credit vs $50 refund'",
            ],
            "tone": "understanding",
            "yield_impact": 35.0,
        },
        {
            "name": "cross_category_bridge",
            "phase": "post_close",
            "description": "Introduce customers to new product categories.",
            "hints": [
                "Base on purchase history: 'Since you like X, try Y'",
                "Use seasonal transitions as natural bridges",
                "Offer sample/trial of new category",
                "Show how other customers expanded their purchases",
            ],
            "tone": "curious",
            "yield_impact": 22.0,
        },
        {
            "name": "out_of_stock_capture",
            "phase": "engagement",
            "description": "Turn out-of-stock into future sale + data capture.",
            "hints": [
                "Offer back-in-stock notification (email capture!)",
                "Suggest similar in-stock alternatives",
                "Create waitlist to gauge demand",
                "Offer pre-order with small discount",
            ],
            "tone": "helpful",
            "yield_impact": 18.0,
        },
        {
            "name": "price_comparison_defender",
            "phase": "negotiation",
            "description": "Defend against price comparison shopping.",
            "hints": [
                "Highlight what's included beyond the product: warranty, support",
                "Show total cost of ownership, not just sticker price",
                "Offer price match guarantee if applicable",
                "Emphasize exclusive colors/variants only you carry",
            ],
            "tone": "confident",
            "yield_impact": 20.0,
        },
        {
            "name": "social_proof_surge",
            "phase": "engagement",
            "description": "Deploy social proof at hesitation points.",
            "hints": [
                "'1,247 people bought this in the last 30 days'",
                "Show real-time: 'Sarah in Austin just ordered this'",
                "Display review highlights from verified purchasers",
                "Show influencer/celebrity endorsements if available",
            ],
            "tone": "confident",
            "yield_impact": 22.0,
        },
        {
            "name": "payment_flexibility",
            "phase": "closing",
            "description": "Remove payment friction with flexible options.",
            "hints": [
                "Offer buy-now-pay-later: 'Just $12/month for 4 months'",
                "Show multiple payment methods early",
                "For high-ticket: offer installment plan",
                "Express checkout options for returning customers",
            ],
            "tone": "accommodating",
            "yield_impact": 28.0,
        },
        {
            "name": "subscription_conversion",
            "phase": "post_close",
            "description": "Convert one-time buyers to subscription model.",
            "hints": [
                "After 2+ repeat purchases: 'Save 15% with auto-delivery'",
                "Make it flexible: skip, pause, cancel anytime",
                "Show convenience angle: 'Never run out again'",
                "Offer subscription-exclusive perks",
            ],
            "tone": "helpful",
            "yield_impact": 40.0,
        },
        {
            "name": "seasonal_pre_sell",
            "phase": "engagement",
            "description": "Pre-sell seasonal items before the rush.",
            "hints": [
                "Start 4-6 weeks before season peak",
                "Offer early-bird pricing or exclusive access",
                "Create anticipation: 'New collection drops Friday'",
                "Show previous season success to build excitement",
            ],
            "tone": "exciting",
            "yield_impact": 20.0,
        },
        {
            "name": "vip_customer_treatment",
            "phase": "engagement",
            "description": "Identify and reward VIP customers for maximum LTV.",
            "hints": [
                "Identify top 10% by purchase value",
                "Offer early access to new products/sales",
                "Provide dedicated support channel",
                "Send surprise gifts or handwritten notes",
            ],
            "tone": "exclusive",
            "yield_impact": 35.0,
        },
        {
            "name": "bundle_builder",
            "phase": "engagement",
            "description": "Interactive bundle creation for higher AOV.",
            "hints": [
                "Start with anchor product they're interested in",
                "Add complementary items: 'Complete your set'",
                "Show bundle savings vs buying separately",
                "Let them customize: build-your-own pack",
            ],
            "tone": "enthusiastic",
            "yield_impact": 25.0,
        },
        {
            "name": "referral_program_activation",
            "phase": "post_close",
            "description": "Turn satisfied buyers into brand ambassadors.",
            "hints": [
                "Time it right: after positive review or repeat purchase",
                "Make sharing effortless: unique link, one click",
                "Mutual benefit: 'Give $20, Get $20'",
                "Gamify: leaderboard for top referrers",
            ],
            "tone": "exciting",
            "yield_impact": 30.0,
        },
    ],
}
