# 智能路径解析功能说明

## 概述

小红书工具包现在支持智能识别多种格式的图片和视频路径输入，能够自动处理来自不同平台（如LLM对话、dify等）的各种数据格式。

## 支持的输入格式

### 图片路径格式

1. **逗号分隔字符串**（传统格式）
   ```
   "a.jpg,b.jpg,c.jpg"
   ```

2. **数组字符串（不带引号）**
   ```
   "[a.jpg,b.jpg,c.jpg]"
   ```

3. **JSON数组字符串**
   ```
   '["a.jpg","b.jpg","c.jpg"]'
   ```

4. **真实数组**（来自程序调用）
   ```
   ["a.jpg", "b.jpg", "c.jpg"]
   ```

5. **混合格式数组字符串**
   ```
   "[a.jpg,'b.jpg',\"c.jpg\"]"
   ```

6. **单个文件**
   ```
   "single.jpg"
   ```

7. **带完整路径**
   ```
   "/path/to/a.jpg,/path/to/b.jpg"
   ```

### 视频路径格式

视频路径支持与图片相同的格式，但限制只能有1个视频文件。

### 标签格式

1. **逗号分隔字符串**
   ```
   "生活,分享,美食"
   ```

2. **数组格式**
   ```
   ["生活", "分享", "美食"]
   ```

## 使用方法

### 1. 使用原有的 start_publish_task 工具

```python
# 现在支持各种格式
start_publish_task(
    title="测试标题",
    content="测试内容", 
    images='["a.jpg","b.jpg","c.jpg"]',  # JSON数组格式
    tags="生活,分享"  # 逗号分隔格式
)
```

### 2. 使用新的 smart_publish_note 工具

```python
# 更灵活的智能发布工具
smart_publish_note(
    title="测试标题",
    content="测试内容",
    images=["a.jpg", "b.jpg", "c.jpg"],  # 真实数组
    tags=["生活", "分享", "美食"],  # 数组格式标签
    location="北京"
)
```

### 3. 测试解析功能

```python
# 测试各种输入格式的解析效果
test_smart_parsing(
    images='["a.jpg","b.jpg","c.jpg"]',
    videos="video.mp4", 
    tags=["生活", "分享"]
)
```

## 常见使用场景

### LLM对话场景

用户可以自然地告诉LLM：
```
"帮我发布一则图文笔记，标题：今日分享，内容：今天去了一个很棒的地方，图片路径：a.jpg,b.jpg,c.jpg"
```

LLM能够自动识别并正确解析路径格式。

### dify平台调用

当从dify等平台传递数组数据时：
```json
{
  "title": "测试标题",
  "content": "测试内容",
  "images": ["image1.jpg", "image2.jpg"],
  "tags": ["标签1", "标签2"]
}
```

系统能够智能识别数组格式并正确处理。

### 混合格式场景

即使用户输入的格式不统一：
```python
{
  "images": "[a.jpg,'b.jpg',\"c.jpg\"]",  # 混合引号格式
  "tags": "生活,分享,美食"  # 逗号分隔格式
}
```

系统也能正确解析。

## 技术实现

- 使用 `smart_parse_file_paths()` 函数智能解析路径
- 支持JSON解析、ast.literal_eval、正则表达式等多种解析方式
- 自动清理空格和引号
- 支持容错处理，即使格式不标准也能尽量解析

## 限制和注意事项

1. **文件路径必须是绝对路径**（XHSNote验证要求）
2. **视频文件限制1个**（小红书平台限制）
3. **图片文件最多9张**（小红书平台限制）
4. **标签最多10个**（小红书平台限制）

## 错误处理

如果输入格式无法解析，系统会：
1. 记录详细的错误日志
2. 返回友好的错误提示
3. 建议正确的输入格式