# OpenClaw Unreal Plugin
version: 1.0.0

MCP skill for controlling Unreal Engine Editor via OpenClaw.

## Connection Modes

### Mode A: OpenClaw Gateway (Remote)
The plugin connects to OpenClaw Gateway via HTTP polling. Works automatically when Gateway is running.

### Mode B: MCP Direct (Claude Code / Cursor)
The plugin runs an embedded HTTP server on port **27184**. Use the included MCP bridge:

```bash
# Claude Code
claude mcp add unreal -- node /path/to/Plugins/OpenClaw/MCP~/index.js

# Cursor — add to .cursor/mcp.json
{"mcpServers":{"unreal":{"command":"node","args":["/path/to/Plugins/OpenClaw/MCP~/index.js"]}}}
```

Both modes run simultaneously.

## Editor Panel

**Window → OpenClaw Unreal Plugin** — opens a dockable tab with:
- Connection status indicator
- MCP server info (address, protocol)
- Connect / Disconnect buttons
- Live log of tool calls and messages

## Tools

### Level
- `level.getCurrent` — current level name
- `level.list` — all levels in project
- `level.open` — open level by name
- `level.save` — save current level

### Actor
- `actor.find` — find by name/class
- `actor.getAll` — list all actors
- `actor.create` — create actors: StaticMeshActor (Cube, Sphere, Cylinder, Cone), PointLight, Camera
- `actor.delete` — delete by name
- `actor.getData` — detailed actor info
- `actor.setProperty` — set properties via UE reflection system

### Transform
- `transform.getPosition` / `transform.setPosition`
- `transform.getRotation` / `transform.setRotation`
- `transform.getScale` / `transform.setScale`

> Transform tools require a valid RootComponent (works on StaticMeshActor, PointLight, etc. — not on bare Actor).

### Component
- `component.get` — get component data
- `component.add` — add component (not yet implemented)
- `component.remove` — remove component (not yet implemented)

### Editor
- `editor.play` — start PIE (uses RequestPlaySession)
- `editor.stop` — stop PIE
- `editor.pause` / `editor.resume` — pause/resume PIE
- `editor.getState` — current editor state

### Debug
- `debug.hierarchy` — actor hierarchy tree
- `debug.screenshot` — capture editor viewport
- `debug.log` — write to output log

### Input
- `input.simulateKey` — simulate key press
- `input.simulateMouse` — simulate mouse
- `input.simulateAxis` — simulate axis

### Asset
- `asset.list` — list assets at path
- `asset.import` — import asset (not yet implemented)

### Console
- `console.execute` — run console command
- `console.getLogs` — read project log file; params: `count` (number of lines), `filter` (text filter)

### Blueprint
- `blueprint.list` — list blueprints
- `blueprint.open` — open blueprint (not yet implemented)

## Troubleshooting

### Stale binaries / plugin not loading

Clear the build cache and restart the editor:

```bash
rm -rf YourProject/Plugins/OpenClaw/Binaries YourProject/Plugins/OpenClaw/Intermediate
```

### Connection issues

- Ensure OpenClaw Gateway is running: `openclaw gateway status`
- Check the Editor Panel log for errors
- Verify the MCP port is not blocked by firewall
