---
name: openclaw-trakt
description: Track and recommend TV shows and movies using Trakt.tv. Use when the user asks for show/movie recommendations, wants to track what they're watching, check their watchlist, or get personalized suggestions based on their viewing history. Requires Trakt.tv account with Pro subscription for full functionality.
---

# Trakt.tv Integration for OpenClaw

Integrate with Trakt.tv to track watch history and provide personalized show/movie recommendations.

**📚 Trakt API Documentation:** <https://trakt.docs.apiary.io/>

## First-Time Setup Required

**Before using this skill, run the interactive setup:**

### Automated Setup (Recommended)
```bash
python3 scripts/setup.py
```

This will guide you through:
1. Installing dependencies
2. Creating a Trakt application
3. Configuring credentials
4. Authenticating with PIN
5. Testing the integration

### Manual Setup
If automated setup doesn't work, follow the manual steps in the Setup section below.

### Interactive Setup for OpenClaw
When a user asks to "install Trakt" or "set up Trakt integration," OpenClaw should:
1. Read `INSTALL.md` for detailed interactive flow
2. Or run `python3 scripts/setup.py` and guide user through prompts

---

## Features

- Track watch history (automatically synced by Trakt from streaming services)
- Get personalized recommendations based on viewing habits
- Access user watchlists and collections
- Search for shows and movies
- View trending content

## Prerequisites

1. **Python dependencies:**
   ```bash
   # Install via pip (with --break-system-packages if needed)
   pip3 install requests
   
   # OR use a virtual environment (recommended)
   python3 -m venv ~/.openclaw-venv
   source ~/.openclaw-venv/bin/activate
   pip install requests
   ```
   
   Alternatively, install via Homebrew if available:
   ```bash
   brew install python-requests
   ```

2. **Trakt.tv account** with Pro subscription (required for automatic watch tracking)

3. **Trakt API application** - Create at <https://trakt.tv/oauth/applications>

4. **Configuration file:** `~/.openclaw/trakt_config.json` (see setup below)

## Setup

### 1. Create Trakt Application

1. Visit <https://trakt.tv/oauth/applications>
2. Click "New Application"
3. Fill in the form:
   - Name: "OpenClaw Assistant"
   - Description: "Personal AI assistant integration"
   - Redirect URI: `urn:ietf:wg:oauth:2.0:oob` (for PIN auth)
   - Permissions: Check all that apply
4. Save and note your Client ID and Client Secret

### 2. Create Configuration File

Create `~/.openclaw/trakt_config.json` with your credentials:

```json
{
  "client_id": "YOUR_CLIENT_ID_HERE",
  "client_secret": "YOUR_CLIENT_SECRET_HERE",
  "access_token": "",
  "refresh_token": ""
}
```

Replace `YOUR_CLIENT_ID_HERE` and `YOUR_CLIENT_SECRET_HERE` with your actual values from step 1.

**Note:** Leave `access_token` and `refresh_token` empty - they'll be filled automatically after authentication.

### 3. Authenticate

Run the authentication script:

```bash
python3 scripts/trakt_client.py auth
```

This will output a PIN URL. Visit it, authorize the app, and run:

```bash
python3 scripts/trakt_client.py auth <PIN>
```

Authentication tokens are saved to `~/.openclaw/trakt_config.json`

## Usage

### Get Recommendations

When a user asks for show/movie recommendations:

```bash
python3 scripts/trakt_client.py recommend
```

This returns personalized recommendations based on the user's watch history and ratings.

### Check Watch History

```bash
python3 scripts/trakt_client.py history
```

Returns the user's recent watch history.

### View Watchlist

```bash
python3 scripts/trakt_client.py watchlist
```

Shows content the user has saved to watch later.

### Search

```bash
python3 scripts/trakt_client.py search "Breaking Bad"
```

Search for specific shows or movies.

### Trending Content

```bash
python3 scripts/trakt_client.py trending
```

Get currently trending shows and movies.

## Recommendation Workflow

When a user asks "What should I watch?" or similar:

1. **Get personalized recommendations:**
   ```bash
   python3 scripts/trakt_client.py recommend
   ```

2. **Parse the results** and present them naturally:
   - Show title, year, rating
   - Brief description/genre
   - Why it's recommended (if available)

3. **Optionally check watchlist** to avoid suggesting shows they already plan to watch

4. **Consider recent history** to avoid re-suggesting recently watched content

## API Reference

See `references/api.md` for detailed Trakt API endpoint documentation.

## Common Use Cases

**"What should I watch tonight?"**
- Get recommendations, filter by mood/genre if specified
- Check trending if user wants something popular

**"Add [show] to my watchlist"**
- Search for the show
- Add to Trakt watchlist (requires additional endpoint implementation)

**"What have I been watching lately?"**
- Get watch history
- Summarize recent shows/movies

**"Is [show] trending?"**
- Get trending list
- Search for specific show

## Limitations

- Trakt Pro subscription required for automatic watch tracking from streaming services
- Recommendations improve over time as watch history grows
- API rate limits apply: 1000 requests per 5 minutes (authenticated)
- Full API documentation: <https://trakt.docs.apiary.io/>

## Troubleshooting

**"Authentication failed"**
- Verify CLIENT_ID and CLIENT_SECRET are set correctly in `~/.openclaw/trakt_config.json`
- Ensure PIN is copied accurately (case-sensitive)
- Check that your Trakt application has proper permissions

**"No recommendations returned"**
- User may not have enough watch history yet
- Try falling back to trending content
- Ensure user has rated some content on Trakt

**"API request failed"**
- Check authentication token hasn't expired
- Verify network connectivity
- Check Trakt API status: https://status.trakt.tv
