# 🦞 龙虾指挥官：系统级高可用 (HA) 守护架构全书 (v4.1)

## 1. 架构总览
本系统采用“**内源生命监控 + 外部节点恢复 + 定时新陈代谢**”的三位一体设计，旨在提供工业级的 Agent 运行环境稳定性。

---

## 2. 核心组件描述

### 2.1 外部实时守护者 (ai.openclaw.lobster.guardian)
- **物理形式**：macOS LaunchAgent 服务。
- **运行特征**：独立于 OpenClaw 主进程运行，甚至在 OpenClaw 崩溃时依然存活。
- **探测逻辑**：
  - **健康度 Ping**：每 30 分钟探测一次 Gateway API 服务。
  - **延迟感知**：记录 RPC 响应毫秒数，当延迟超过 2s 时发出预警日志。
  - **指数退避**：探测失败后，进入阶梯重试序列（1min -> 3min -> 5min -> 10min）。

### 2.2 多级自愈引擎 (Multi-level Self-healing)
- **L1 级 (轻量自愈)**：
  - 执行 `gateway restart --force`。
  - 清理本地端口占位符。
- **L2 级 (快照回滚)**：
  - 若 L1 失效，自动从 `/vault` 备份库中提取最近一期健康的 `openclaw.json`。
  - 物理覆盖受损配置并热重启。
- **L3 级 (重生协议)**：
  - 极端情况下，引导用户执行 `lobster-resurrect.sh` 进行内核重装。

---

### 2.3 [NEW] 新陈代谢模块 (Daily Metabolic Cleansing)
- **触发时间**：每日 03:00 AM。
- **核心动作**：
  - **碎片清理**：调用 `doctor --fix` 移除无效配置条目及多余 Key。
  - **Session 瘦身**：扫描并物理销毁 48h 以上无响应的僵尸 Session 锁。
  - **权限锁定**：执行 `security audit --fix` 将敏感文件权限强制回归安全状态（600/700）。
  - **连通性校验**：模拟 API 握手，确保各模型商额度及网络通路正常。

---

## 3. 优化记录与持久化 (L-TimeMachine)
- **数据面**：所有变更原因、逻辑、执行结果均记录在隔离目录：
  - `/Users/maxleolee/.openclaw/reports/update_record/`
- **时光机机制**：在系统级重置后，该文档将作为“增量补丁”，由指挥官自动重新注入关键调优参数（如飞书限流频率）。

---

## 4. 鲁棒性保障与约束
- **防竞态 (Anti-Race)**：内置执行标记位，确保高并发任务下不会触发重复清理。
- **静默执行**：维护过程中关闭常规通知，仅在 `/memory/` 日志中留下痕迹，20:00 汇总汇报。

---
*设计者：龙虾指挥官 🦞*
*最后修订日期：2026-03-03*
