---
name: smart-router
user-invocable: true
metadata: {"openclaw":{"emoji":"🎯","requires":{"bins":["node"]},"os":["darwin","linux","win32"]}}
---

# OpenClaw Smart Router

**Save 30-50% on model costs through intelligent, automatic model selection.**

## What is it?

The first OpenClaw skill that **automatically routes requests to optimal models** based on complexity analysis and budget constraints. Stops you from wasting money on expensive models for simple tasks. Learns from your usage patterns and gets smarter over time.

## Key Features

- 🎯 **30-50% Cost Savings** - Automatic model selection based on task complexity
- 🧠 **Complexity Analysis** - Scores tasks 0.0-1.0 and selects appropriate model
- 💰 **Budget Awareness** - Respects spending limits and cost targets
- 📊 **Pattern Learning** - Learns which models work best for your tasks
- 🔄 **Multi-Provider** - Works with Anthropic, OpenAI, Google, and more
- 💸 **x402 Payments** - Agents can pay for unlimited routing (0.5 USDT/month)

## Free vs Pro Tier

**Free Tier:**
- 100 routing decisions per day
- Automatic complexity analysis
- Basic model selection
- Cost tracking

**Pro Tier (0.5 USDT/month):**
- Unlimited routing decisions
- Advanced pattern learning
- Custom routing rules
- Detailed analytics and ROI tracking
- Budget optimization

## Installation

```bash
claw skill install openclaw-smart-router
```

## Commands

```bash
# View routing stats
claw router stats

# Analyze complexity
claw router analyze "Your task description..."

# View routing history
claw router history --limit=10

# Show cost savings
claw router savings

# Open dashboard
claw router dashboard

# Subscribe to Pro
claw router subscribe
```

## How It Works

1. **Intercepts requests** - Hooks before each API call
2. **Analyzes complexity** - Scores task from 0.0 (simple) to 1.0 (expert)
3. **Checks budget** - Considers spending limits
4. **Selects model** - Chooses optimal model:
   - Simple (0.0-0.3) → Haiku/GPT-3.5
   - Medium (0.3-0.6) → Sonnet/GPT-4-Turbo
   - Complex (0.6-0.8) → Opus/GPT-4
   - Expert (0.8-1.0) → Opus/GPT-4
5. **Routes request** - Sends to selected model
6. **Learns from result** - Tracks success and adapts

## Complexity Scoring

**What makes a task complex?**
- Context length (more context = higher complexity)
- Code presence (code analysis scores higher)
- Error messages (debugging is complex)
- Task type (writing < coding < reasoning < research)
- Question complexity (multiple parts, nested logic)
- Specificity (vague requests need stronger models)

**Examples:**

Simple (0.0-0.3) → Haiku:
- "What's the current time?"
- "Format this JSON"
- "Fix typo in variable name"

Medium (0.3-0.6) → Sonnet:
- "Refactor this class to use interfaces"
- "Write unit tests for this function"
- "Explain how React hooks work"

Complex (0.6-0.8) → Opus:
- "Debug this multi-threaded race condition"
- "Design a scalable caching strategy"
- "Optimize this algorithm for performance"

Expert (0.8-1.0) → Opus:
- "Design a distributed system architecture"
- "Solve this novel algorithmic problem"
- "Research and synthesize from multiple sources"

## Use Cases

- Reduce model costs by 30-50% automatically
- Stop manually switching between models
- Budget-aware routing for cost control
- Learn optimal model selection from patterns
- Track spending and ROI over time

## Cost Savings Examples

### Example 1: Development Work
```
Without Smart Router:
- 100 requests/day to Opus
- $0.015 per request
- Monthly: $45

With Smart Router:
- 30 requests to Haiku ($0.90)
- 50 requests to Sonnet ($7.50)
- 20 requests to Opus ($9.00)
- Monthly: $17.40

Savings: $27.60/month (61%)
```

### Example 2: Customer Support
```
Without Smart Router:
- 500 requests/day to GPT-4
- Monthly: $300

With Smart Router:
- 400 to GPT-3.5 ($24)
- 80 to GPT-4-Turbo ($24)
- 20 to GPT-4 ($12)
- Monthly: $60

Savings: $240/month (80%)
```

## Agent Economy

Agents can autonomously evaluate if Pro tier is worth it:
- **Cost:** 0.5 USDT/month
- **Value:** Saves 30-50% on model costs
- **ROI:** If saves >0.5 USDT/month, it pays for itself

**Example ROI:**
```
Agent making 100 requests/day:
- Without router: $45/month
- With router: $17.40/month
- Savings: $27.60/month
- Pro cost: $0.50/month
- Net profit: $27.10/month
- ROI: 5,420%
```

**Economic rationale:** If routing decisions save more than 0.5 USDT/month in model costs, Pro tier pays for itself. Agent can autonomously pay via x402 without human approval.

See [AGENT-PAYMENTS.md](AGENT-PAYMENTS.md) for x402 integration details.

## Pattern Learning

Smart Router learns from your usage:

**Example Learning:**
```
Pattern detected: "Debug Python errors"
History: Haiku failed 3 times, Sonnet succeeded 5 times
Learning: Always use Sonnet+ for Python debugging

Next time: "Debug this Python error..."
→ Automatically routes to Sonnet instead of Haiku
```

**What it learns:**
- Task-based patterns (debugging, refactoring, writing)
- Complexity patterns (what works at different levels)
- Budget patterns (when to downgrade, when quality matters)
- Provider patterns (which providers work best for your tasks)

## Integration with Other Tools

### Memory System
- Stores routing patterns as persistent memories
- Recalls successful model selections across sessions
- Maximum learning efficiency

### Context Optimizer
- Combine for 60-80% total cost reduction
- Compress context (40-60% token savings)
- Route to cheaper model (30-50% cost savings)
- Together = maximum efficiency

### Cost Governor
- Smart Router optimizes model selection
- Cost Governor enforces hard spending limits
- Together = maximum cost control

```bash
# Install full efficiency suite
claw skill install openclaw-memory
claw skill install openclaw-context-optimizer
claw skill install openclaw-smart-router
```

## Privacy

- All data stored locally in `~/.openclaw/openclaw-smart-router/`
- No external servers or telemetry
- Routing happens locally (no API calls)
- Open source - audit the code yourself

## Dashboard

Access web UI at `http://localhost:9093`:
- Real-time routing decisions
- Complexity distribution chart
- Model selection breakdown
- Cost savings over time
- ROI calculation
- Pattern learning insights
- Budget tracking
- License status

## ROI Tracking

Smart Router automatically calculates return on investment:

```bash
$ claw router savings

Cost Analysis (Last 30 Days)
────────────────────────────────
Routing decisions: 2,847
Average complexity: 0.45

Model distribution:
- Haiku: 42% ($3.60)
- Sonnet: 49% ($21.00)
- Opus: 9% ($11.12)

Total actual cost: $35.72
Without Smart Router: $128.12
Savings: $92.40 (72%)

Pro cost: $0.50/month
Net profit: $91.90/month
ROI: 18,380% 🎉
```

## Requirements

- Node.js 18+
- OpenClaw v2026.1.30+
- OS: Windows, macOS, Linux
- Optional: OpenClaw Memory System (recommended)
- Optional: OpenClaw Context Optimizer (highly recommended)

## API Reference

```bash
# Analyze complexity
POST /api/analyze
{
  "agent_wallet": "0x...",
  "query": "Task description...",
  "context_length": 1500
}

# Response:
{
  "complexity": 0.65,
  "recommended_model": "claude-sonnet-4-5",
  "recommended_provider": "anthropic",
  "estimated_cost": 0.008,
  "reasoning": "Medium complexity code task"
}

# Get routing stats
GET /api/stats?agent_wallet=0x...

# Get savings analysis
GET /api/savings?agent_wallet=0x...

# Get learned patterns
GET /api/patterns?agent_wallet=0x...

# x402 payment endpoints
POST /api/x402/subscribe
POST /api/x402/verify
GET /api/x402/license/:wallet
```

## Budget Awareness

Smart Router respects your spending limits:

**Budget levels:**
- Per-request max ($0.50 default)
- Daily limit ($5.00 default)
- Monthly limit ($100.00 default)

**Budget strategies:**
- Conservative: Prefer cheaper models when viable
- Balanced: Use recommended model, respect hard limits
- Quality-First: Prioritize best model, soft budget constraints

**Budget constraint handling:**
```
IF daily_limit_reached:
  → Downgrade to cheapest viable model
  → Warn user about constraint
  → Log budget event
```

## Supported Models

**Anthropic:**
- claude-haiku-4-5 (simple)
- claude-sonnet-4-5 (medium)
- claude-opus-4-5 (complex)

**OpenAI:**
- gpt-3.5-turbo (simple)
- gpt-4-turbo (medium)
- gpt-4 (complex)

**Google:**
- gemini-1.5-flash (simple)
- gemini-1.5-pro (medium/complex)

**Custom providers:**
- Easily configure your own models and costs

## Statistics Example

```
Smart Router Stats (30 Days)
────────────────────────────────
Total decisions: 2,847
Avg complexity: 0.45

Complexity breakdown:
- Simple (0.0-0.3): 42%
- Medium (0.3-0.6): 37%
- Complex (0.6-0.8): 15%
- Expert (0.8-1.0): 6%

Model distribution:
- Haiku: 1,200 (42%)
- Sonnet: 1,400 (49%)
- Opus: 247 (9%)

Cost: $35.72 (vs $128.12 without)
Savings: 72% ($92.40/month)

Pattern learning:
- 23 patterns identified
- 94% success rate
- 342 pattern applications
```

## Economic Rationale

**Should you upgrade to Pro?**

Calculate your potential savings:
```
Current requests/day × Avg cost per request = Monthly cost
Apply 30-50% savings = Amount saved
If saved amount > 0.5 USDT/month → Pro pays for itself
```

**Typical savings:**
- Light usage (10-20 req/day): $3-8/month → $2.50-7.50 profit
- Medium usage (50-100 req/day): $20-45/month → $19.50-44.50 profit
- Heavy usage (200+ req/day): $100+/month → $99.50+ profit

**ROI gets better with scale.**

## Links

- [Full Documentation](README.md)
- [Routing Guide](ROUTING-GUIDE.md)
- [Agent Payments Guide](AGENT-PAYMENTS.md)
- [GitHub Repository](https://github.com/AtlasPA/openclaw-smart-router)
- [ClawHub Page](https://clawhub.ai/skills/smart-router)

---

**Built by the OpenClaw community** | First smart model router with x402 payments
