---
name: volcengine-search-web
description: Openclaw/Trae 联网搜索国内方案，使用火山引擎联网问答智能体 API 进行网络搜索问答。
---

# Volcengine Search Web Skill - 联网搜索国内方案

专为 **Openclaw、Trae** 等 AI 编程工具设计的联网搜索国内解决方案。

> **免责声明**：本项目为个人开发代码，与火山引擎官方无关，仅供学习参考使用。

## 适用场景

当 Openclaw、Trae 等工具需要联网搜索信息时，可使用此技能作为国内方案替代 Brave Search。支持搜索网络、获取参考资料、富媒体卡片数据，实现追问、引用角标、图文混排、百科划线词等高级功能。

## 为什么选择此方案？

- **无需绑定信用卡** - 国内支付方式即可开通
- **访问稳定** - 国内服务器，响应速度快
- **中文搜索优化** - 更懂中文语境，搜索结果更精准

## 使用步骤

1. 准备清晰具体的问题。
2. 运行脚本 `python scripts/volcengine_search_web.py "<question>"`。运行之前cd到对应的目录。
3. 脚本将返回智能体的回答内容，包括参考来源、追问建议等。

## 认证与凭据来源

- 读取 `VOLCENGINE_SEARCH_API_KEY` 环境变量作为 API Key。
- 需要配置 `VOLCENGINE_SEARCH_BOT_ID` 环境变量指定智能体ID（在控制台创建智能体后获取）。

## 输出格式

- 输出智能体的回答内容。
- 显示参考来源（URL、标题、发布时间等）。
- 显示追问建议（如有）。
- 显示 Token 使用情况。
- 若调用失败，将打印错误信息。

## 示例

```bash
python scripts/volcengine_search_web.py "openclaw的最新动态"
```

## 高级功能

该技能支持以下高级功能（需在控制台开启）：

- **引用角标**：在回答中插入引用标记 `[ref_x]` 指示文本来源
- **图文/视频混排**：在输出中穿插图片或视频
- **百科划线词**：自动将百科词条以下划线超链接形式呈现
- **追问建议**：提供相关追问建议
- **深度思考模式**：通过设置 `model=thinking` 开启
