# Skill Scanner

**Name:** skill-scanner
**Version:** 1.0.0
**Author:** vrtlly.us
**Category:** Security

## Description

Scans ClawHub skills for malicious patterns before and after installation. Detects base64 payloads, reverse shells, data exfiltration, crypto miners, obfuscated URLs, and more.

## Usage

### Scan all installed skills
```bash
python3 scanner.py
```

### Scan a specific skill
```bash
python3 scanner.py --skill <skill-name>
```

### Scan a specific file
```bash
python3 scanner.py --file <path-to-file>
```

### Pre-install scan (download → scan → report → cleanup)
```bash
python3 scanner.py --pre-install <clawhub-slug>
```

### JSON output
```bash
python3 scanner.py --json
python3 scanner.py --skill <name> --json
```

### Safe install hook
```bash
bash install-hook.sh <clawhub-slug>
bash install-hook.sh <clawhub-slug> --force
```

## Detection Patterns

| Category | What it catches |
|---|---|
| Base64 payloads | Long base64 strings near exec/bash/eval |
| Pipe to shell | `curl ... \| bash`, `wget ... \| sh` |
| Raw IP connections | `http://1.2.3.4` style URLs |
| Dangerous functions | `eval()`, `exec()`, `os.system()`, `subprocess(shell=True)` |
| Hidden files | Dotfile creation in unexpected places |
| Env exfiltration | Reading `.env`, API keys sent outbound |
| Obfuscated URLs | rentry.co, pastebin, hastebin redirectors |
| Fake dependencies | References to non-existent packages |
| Data exfil endpoints | webhook.site, requestbin, etc. |
| Crypto mining | xmrig, stratum, mining pool references |
| Password archives | Password-protected zip/tar downloads |

## Risk Scores

- **0-29 (Green):** Clean — no suspicious patterns found
- **30-69 (Yellow):** Suspicious — review warnings before use
- **70-100 (Red):** Dangerous — likely malicious, do not install

## Files

- `scanner.py` — Main scanner engine
- `install-hook.sh` — Safe installation wrapper
- `whitelist.json` — Known-good and known-bad skill lists
- `report-template.md` — Markdown report template
