---
name: openclaw-skill-money-idea-generator
description: "赚钱灵感生成器 | Money Idea Generator. 自动发现 AI 变现机会，生成可落地的赚钱灵感。支持多平台监控：GitHub、抖音、B站、小红书、Twitter。触发词：赚钱灵感、赚钱机会、AI 变现、商业灵感."
metadata:
  openclaw:
    emoji: "💰"
    category: "business"
    tags: ["money", "idea", "business", "AI", "monetization", "startup", "multi-source"]
    requires:
      bins: ["python3", "curl"]
---

# 赚钱灵感生成器

自动发现 AI 变现机会，生成可落地的赚钱灵感。

## 核心功能

### 1. 多平台监控
- GitHub Trending AI 项目
- 抖音热门话题
- B站科技区视频
- 小红书热门笔记
- Twitter AI trending

### 2. 变现潜力分析
- 判断项目是否"能赚钱"
- 分析市场需求和竞争
- 给出潜力评分（高/中/低）

### 3. 灵感生成
- 自动生成赚钱灵感
- 提供具体实现路径
- 估算启动成本和预期收入

### 4. 资产池管理
- 保存灵感到资产池
- 跟踪执行状态
- 记录实际收益

### 5. 个性化推荐
- 根据用户偏好推荐
- 按领域分类（AI 工具、SaaS、内容创作）
- 按难度分级（入门/进阶/专业）

## 使用方式

### 获取今日赚钱灵感

```
给我生成一个赚钱灵感
最近有什么赚钱机会？
```

### 分析特定项目

```
分析这个项目能不能赚钱：https://github.com/xxx/xxx
```

### 获取热门变现机会

```
最近有什么 AI 变现机会？
```

## 变现潜力判断规则

### 高潜力特征
- ✅ 解决明确痛点
- ✅ 技术门槛适中
- ✅ 有付费用户验证
- ✅ 可规模化复制
- ✅ 新增星标 > 100/周

### 低潜力特征
- ❌ 技术门槛太高
- ❌ 市场太小众
- ❌ 已有巨头垄断
- ❌ 需要大量资金
- ❌ 无明确商业模式

## 赚钱灵感分类

| 类别 | 示例 | 启动成本 | 预期收入 |
|------|------|---------|---------|
| **AI 工具开发** | OpenClaw 部署服务 | ¥500 | ¥5,000+/月 |
| **内容创作** | AI 日报订阅 | ¥0 | ¥2,000+/月 |
| **技术服务** | 自动化脚本开发 | ¥0 | ¥3,000+/月 |
| **教育培训** | AI 教程课程 | ¥0 | ¥10,000+/月 |
| **SaaS 产品** | AI Agent 平台 | ¥1,000 | ¥50,000+/月 |

## 配置

在 `config.py` 中配置：
- `GITHUB_TOKEN`: GitHub API Token（可选，提高速率限制）
- `MIN_STARS`: 最小星标数（默认 50）
- `CATEGORIES`: 关注的领域（默认 AI/LLM/Agent）
- `USER_PREFERENCES`: 用户偏好（预算、技能、兴趣）