---
name: manus
description: Agente de IA autónomo de Manus con capacidades de investigación, desarrollo, automatización y generación de medios.
homepage: https://manus.im
metadata: {"clawdbot":{"emoji":"🧠","requires":{"env":["MANUS_API_KEY"]},"primaryEnv":"MANUS_API_KEY"}}
---

# Manus AI Skill

Agente de IA autónomo con acceso a internet, capaz de ejecutar tareas complejas, investigar, desarrollar software, automatizar workflows y generar contenido multimedia.

## Configuración

### API Key

La API key se configura en la variable de entorno `MANUS_API_KEY`:

```bash
export MANUS_API_KEY="sk-..."
# O en ~/.clawdbot/clawdbot.json:
# "skills.manus.apiKey": "sk-..."
```

### Endpoints

| Endpoint | Descripción |
|----------|-------------|
| `https://api.manus.ai/v1/tasks` | Crear y gestionar tareas |
| `https://api.manus.ai/v1/projects` | Gestión de proyectos |
| `https://api.manus.ai/v1/files` | Subir archivos |
| `https://api.manus.ai/v1/webhooks` | Webhooks para notificaciones |

## Uso Básico

### Crear una tarea simple

```bash
cd /home/disier/clawd/skills/manus/scripts
python3 run_task.py "Investiga las últimas noticias de IA"
```

### Conectores integrados

```bash
# Gmail
python3 run_task.py "Revisa mis correos de hoy en Gmail y resumenlos"

# Notion
python3 run_task.py "Crea una página en Notion con el resumen de esta reunión"

# Google Calendar
python3 run_task.py "Agenda una reunión para mañana a las 3pm"

# Slack
python3 run_task.py "Envía un resumen al canal de #updates en Slack"
```

## Scripts Disponibles

| Script | Descripción |
|--------|-------------|
| `run_task.py` | Ejecuta una tarea básica |
| `create_project.py` | Crea un proyecto |
| `upload_file.py` | Sube archivos |
| `check_status.py` | Consulta estado de tarea |
| `get_result.py` | Obtiene resultado |
| `webhook_server.py` | Servidor de webhooks |

## Scripts Detallados

### run_task.py - Ejecutar tarea básica

```bash
python3 run_task.py "TU_PROMPT_AQUI" [--timeout SEGUNDOS]
```

**Ejemplo:**

```bash
# Investigación
python3 run_task.py "Investiga las regulaciones de IA en la UE 2026"

# Desarrollo
python3 run_task.py "Crea una web app de todo list con React"

# Escritura
python3 run_task.py "Escribe un artículo sobre automatización de workflows"

# Automatización
python3 run_task.py "Reserva un vuelo de NYC a LA para el 15 de marzo"
```

### create_project.py - Crear proyecto

```bash
python3 create_project.py "Nombre del proyecto" "Descripción"
```

### upload_file.py - Subir archivos

```bash
python3 upload_file.py /ruta/al/archivo.txt
```

**Útil para:**
- Contexto adicional
- Archivos de datos
- Documentos de referencia

### check_status.py - Ver estado

```bash
python3 check_status.py TASK_ID
```

**Estados posibles:**
- `pending` - En cola
- `running` - Ejecutando
- `completed` - Completado
- `failed` - Falló

### get_result.py - Obtener resultado

```bash
python3 get_result.py TASK_ID
```

Devuelve el resultado completo de la tarea.

## Conectores

Manus incluye conectores integrados:

### Gmail

```python
python3 run_task.py "Lee mis últimos 5 correos de Gmail y extrae los puntos importantes"
```

### Notion

```python
python3 run_task.py "Crea una base de datos en Notion para tracking de proyectos"
```

### Google Calendar

```python
python3 run_task.py "Lee mi agenda de hoy y muéstrame mis reuniones"
```

### Slack

```python
python3 run_task.py "Publica un mensaje en el canal #anuncios"
```

## Data Integrations

### Similarweb

```python
python3 run_task.py "Analiza el tráfico de disier.tech usando Similarweb"
```

## Webhooks

### Recibir notificaciones

```bash
python3 webhook_server.py 8080
```

El servidor escucha en el puerto especificado y muestra notificaciones de tareas completadas.

## OpenAI Compatibilidad

Manus es compatible con el SDK de OpenAI:

```python
from openai import OpenAI

client = OpenAI(
    api_key="sk-...",  # Tu API key de Manus
    base_url="https://api.manus.ai/v1"
)

response = client.chat.completions.create(
    model="manus-1.6-adaptive",
    messages=[{"role": "user", "content": "Hello!"}]
)
```

## Uso desde Clawdbot

### En un agente:

```markdown
Cuando necesites investigación profunda o desarrollo:
1. Usa el script run_task.py de la skill manus
2. Especifica el prompt claro
3. Espera el resultado
4. Integra la respuesta
```

### Ejemplo completo:

```bash
# Investigar y crear contenido
python3 run_task.py "Investiga 5 tendencias de tecnología para 2026 y escribe un artículo de 1000 palabras"

# Con archivo de contexto
python3 upload_file.py contexto.md
python3 run_task.py "Basándote en el archivo subido, crea una presentación"
```

## Mejores Prácticas

### Prompts efectivos

**✅ Buenos:**
- "Investiga las regulaciones de IA en la UE y resume los puntos clave"
- "Crea una web app de clima con React y OpenWeatherMap"
- "Analiza los últimos 10 tweets de una cuenta y genera un reporte"

**❌ Evitar:**
- "Haz algo útil" (muy vago)
- "Mejora esto" (sin contexto)

### Con archivos

Para contexto adicional, sube archivos primero:

```bash
python3 upload_file.py datos.csv
python3 run_task.py "Analiza este CSV y genera un reporte de ventas"
```

### Tareas largas

Para tareas que pueden tomar tiempo:

```bash
python3 run_task.py "Investiga a profundidad el mercado de IA" --timeout 300
```

## Costo

Las tareas consumen créditos. Ver uso con:

```bash
curl "https://api.manus.ai/v1/usage" \
  -H "API_KEY: sk-..."
```

## Notas

- Las tareas ejecutan en sandbox aislado
- Tiene acceso a internet completo
- Puede instalar software
- Mantiene sesiones de servicios autenticados
- Tiempo de ejecución variable según complejidad
