# Gas Town Skill for OpenClaw

Multi-agent coding orchestrator using [Gas Town](https://github.com/steveyegge/gastown) and Claude Code.

## What is Gas Town?

Gas Town coordinates multiple Claude Code agents (polecats) to complete coding tasks in parallel with:
- Git-backed persistent state (hooks)
- Work tracking (beads/convoys)
- Automated merge queue (refinery)
- Health monitoring (witness)

## Installation

### From ClawHub
```bash
clawhub install gastown
```

### Manual
```bash
# Clone to your OpenClaw workspace skills directory
cd ~/.openclaw/workspace/skills
git clone https://github.com/saesak/openclaw-skill-gastown gastown

# Restart OpenClaw to pick up the skill
```

## First-Time Setup

Run `scripts/setup.sh` to install prerequisites, or manually:

```bash
# Install Go (if needed)
# Install gt + bd
go install github.com/steveyegge/gastown/cmd/gt@latest
CGO_ENABLED=0 go install github.com/steveyegge/beads/cmd/bd@latest

# Create workspace
gt install ~/gt --git
cd ~/gt

# Add your project
gt rig add myproject /path/to/repo --branch main

# CRITICAL: Symlink formulas for each rig
cd ~/gt/myproject/.beads && ln -s ../../.beads/formulas formulas

# Fix config issues and start services
gt doctor --fix
gt up
```

## Usage

Just tell the agent what you need. The skill teaches it to:
- Use Mayor as the primary interface
- Dispatch work via `gt sling` with proper formulas
- Track progress via convoys
- Handle the SWARM_START notification loop for batch work

Example:
> "I need to refactor the authentication module into separate services"

The agent will use Gas Town to coordinate multiple polecats working in parallel.

## Key Concepts

- **Mayor** 🦊 — AI coordinator, your primary interface
- **Polecats** 🦨 — Ephemeral workers that complete tasks and self-destruct
- **Witness** 🦅 — Monitors polecat health
- **Refinery** 🦡 — Merges completed work to main
- **Convoys** 🚚 — Track batches of related work
- **GUPP** — "If your hook has work, RUN IT" (the propulsion principle)

## Critical Knowledge

This skill documents important learnings not in the official docs:

1. **Formula Symlink** — New rigs need formulas symlinked or `mol-polecat-work` won't resolve
2. **SWARM_START** — Mayor must notify Witness when dispatching batches, or completion tracking breaks
3. **Command Gotchas** — `gt mayor mail` doesn't exist, use `gt mail send mayor`

## Resources

- [Gas Town GitHub](https://github.com/steveyegge/gastown)
- [Beads GitHub](https://github.com/steveyegge/beads)
- [OpenClaw](https://github.com/openclaw/openclaw)

## License

MIT
