# OpenClaw Shield

Enterprise security scanner for AI agents. Detects credential theft, data exfiltration, and malicious code with static analysis + runtime guards + ClamAV integration. Audit logging and tamper-evident reports.

**When to use:** Security scanning, threat detection, code auditing, runtime protection for AI agents

**What to know:**

**Repository:** https://github.com/pfaria32/OpenClaw-Shield-Security

## Features

### Static Scanner
- Detects credential theft, data exfiltration, destructive operations
- Pattern-based analysis (no external dependencies)
- Python stdlib only (zero supply chain risk)
- Pre-execution scanning

### Runtime Guard  
- File/network/exec allowlists
- Output sanitization
- Policy enforcement
- Real-time protection

### Integration
- ClamAV integration (3.6M virus signatures)
- Telegram alerting on critical findings
- Hash-chained audit logging
- Tamper-evident security logs

## Installation

```bash
cd /home/node/.openclaw/workspace
git clone https://github.com/pfaria32/OpenClaw-Shield-Security.git projects/OpenClaw-Shield

# Test the scanner
python3 projects/OpenClaw-Shield/src/scanner.py /path/to/scan

# Deploy (see repository README for full setup)
```

## Usage

### Manual Scan
```bash
python3 projects/OpenClaw-Shield/src/scanner.py workspace --output shield-report.json
```

### Daily Automated Scans
Set up cron job (see repository deployment guide):
```bash
# Daily at 3 AM UTC
0 3 * * * /path/to/scan-script.sh
```

### Runtime Guard (Optional)
Configure allowlists and enable runtime protection (see deployment/openclaw-config.py in repo).

## Status

✅ **Deployed** on this instance (clawdbot-toronto)
- Daily scans: 3:00 AM UTC  
- ClamAV: Active (host-level)
- Runtime guard: Prepared (not enabled by default)

## Attribution

**Inspired by:** Resonant by Manolo Remiddi  
**Source:** https://github.com/ManoloRemiddi/resonantos-open-system-toolkit/blob/main/BUILD_YOUR_OWN_SHIELD.md

Built on the principle: "Don't trust, verify."

## Documentation

Full docs, threat model, and deployment guide in repository README.
