---
name: openclaw-server-secure-skill
description: Comprehensive security hardening and installation guide for OpenClaw (formerly Clawdbot/Moltbot). Use this skill when the user wants to secure a server, install the OpenClaw agent, or configure Tailscale/Firewall for the agent.
---

# OpenClaw Server Security & Installation

## Overview
This skill guides the setup of a secure, self-hosted OpenClaw instance. It covers SSH hardening, Firewall configuration, Tailscale VPN setup, and the OpenClaw installation itself.

## Workflow

### Phase 1: System Hardening

1. **Lock down SSH**
    - Goal: Keys only, no passwords, no root login.
    - Action: Modify `/etc/ssh/sshd_config`.
    - Commands:
      ```bash
      # Backup config
      sudo cp /etc/ssh/sshd_config /etc/ssh/sshd_config.bak
      # Disable Password Auth
      sudo sed -i 's/^#*PasswordAuthentication .*/PasswordAuthentication no/' /etc/ssh/sshd_config
      # Disable Root Login
      sudo sed -i 's/^#*PermitRootLogin .*/PermitRootLogin no/' /etc/ssh/sshd_config
      # Reload SSH
      sudo sshd -t && sudo systemctl reload ssh
      ```

2. **Default-deny Firewall**
    - Goal: Block everything incoming by default.
    - Action: Install and enable UFW.
    - Commands:
      ```bash
      sudo apt update && sudo apt install ufw -y
      sudo ufw default deny incoming
      sudo ufw default allow outgoing
      sudo ufw enable
      ```
      *Note: Ensure you have console access or a fallback before enabling if SSH is not yet allowed on another interface, though we configure Tailscale next.*

3. **Brute-force Protection**
    - Goal: Auto-ban IPs after failed login attempts.
    - Action: Install Fail2ban.
    - Commands:
      ```bash
      sudo apt install fail2ban -y
      sudo systemctl enable --now fail2ban
      ```

### Phase 2: Network Privacy (Tailscale)

4. **Install Tailscale**
    - Goal: Create a private VPN mesh network.
    - Commands:
      ```bash
      curl -fsSL https://tailscale.com/install.sh | sh
      sudo tailscale up
      ```
    - *Wait for user to authenticate the Tailscale link.*

5. **Configure SSH & Web via Tailscale**
    - Goal: Allow traffic only from the Tailscale subnet (100.64.0.0/10) and remove public access.
    - Commands:
      ```bash
      # Allow SSH over Tailscale
      sudo ufw allow from 100.64.0.0/10 to any port 22 proto tcp
      # Remove public SSH access (Adjust rule name/number as needed)
      sudo ufw delete allow OpenSSH || sudo ufw delete allow 22/tcp
      # Allow Web ports over Tailscale
      sudo ufw allow from 100.64.0.0/10 to any port 443 proto tcp
      sudo ufw allow from 100.64.0.0/10 to any port 80 proto tcp
      ```

6. **Disable IPv6 (Optional)**
    - Goal: Reduce attack surface.
    - Commands:
      ```bash
      sudo sed -i 's/IPV6=yes/IPV6=no/' /etc/default/ufw
      if ! grep -q "net.ipv6.conf.all.disable_ipv6 = 1" /etc/sysctl.conf; then
        echo "net.ipv6.conf.all.disable_ipv6 = 1" | sudo tee -a /etc/sysctl.conf
      fi
      sudo sysctl -p && sudo ufw reload
      ```

### Phase 3: OpenClaw Installation

7. **Install OpenClaw**
    - Commands:
      ```bash
      npm install -g openclaw && openclaw doctor
      ```

8. **Configure Owner Access**
    - **Required Input:** Ask the user for their **Telegram ID**.
    - Action: Update the config to allowlist only that ID.
    - JSON Config Target (verify location via `openclaw doctor`):
      ```json
      { 
        "dmPolicy": "allowlist", 
        "allowFrom": ["YOUR_TELEGRAM_ID"], 
        "groupPolicy": "allowlist" 
      }
      ```

9. **Secure Credentials**
    - Goal: Restrict file permissions.
    - Commands:
      ```bash
      chmod 700 ~/.openclaw/credentials 2>/dev/null || true
      chmod 600 .env 2>/dev/null || true
      ```

10. **Final Audit**
    - Action: Run the built-in security audit.
    - Command:
      ```bash
      openclaw security audit --deep
      ```

## Verification Status
Run to confirm:
```bash
sudo ufw status verbose
ss -tulnp
tailscale status
openclaw doctor
```
