<div dir="rtl" align="right">

# OpenClaw Security Guard

## الحارس الامني لمنصة OpenClaw

<div align="center">

**افحص . راقب . احم**

**اداة تدقيق امني شاملة لحماية منصة OpenClaw للذكاء الاصطناعي**

**بدون تتبع . خصوصية تامة . مفتوح المصدر**

---

[التثبيت](#-التثبيت) |
[البدء السريع](#-البدء-السريع) |
[الاوامر](#-مرجع-الاوامر) |
[نقاط الامان](#-نقاط-الامان) |
[الخصوصية](#-الخصوصية-والامان) |
[المساهمة](#-المساهمة) |
[English](../../README.md)

</div>

---

## لماذا تحتاج هذه الاداة؟

منصة OpenClaw قوية، لكن مع هذه القوة تاتي مسؤولية كبيرة. الاعدادات الافتراضية قد تعرض نظامك لمخاطر امنية جسيمة:

| الخطر | بدون الحارس الامني | مع الحارس الامني |
|-------|---------------------|-------------------|
| مفاتيح API مكشوفة | بيانات الاعتماد قد تتسرب في السجلات والاعدادات | يكتشفها وينبهك فورا |
| حقن الاوامر (Prompt Injection) | المهاجمون يستطيعون اختراق الذكاء الاصطناعي | حظر فوري للمحاولات |
| سياسة الرسائل المباشرة مفتوحة | اي شخص يستطيع التواصل مع الروبوت | تدقيق الاعدادات وتنبيه |
| بدون حدود للتكلفة | انفاق غير محدود على واجهة API | مراقبة التكاليف |
| صندوق الحماية معطل | وصول كامل الى النظام | اصلاح تلقائي متاح |

---

## التثبيت

### المتطلبات

- Node.js الاصدار 22 او اعلى
- npm الاصدار 10 او اعلى

### التثبيت الشامل (موصى به)

```bash
npm install -g openclaw-security-guard
```

### التحقق من التثبيت

```bash
openclaw-guard --version
```

### الاستخدام بدون تثبيت

```bash
npx openclaw-security-guard audit
```

---

## البدء السريع

### 1. تشغيل تدقيق امني

قم بتشغيل اول تدقيق امني لفحص منصة OpenClaw:

```bash
openclaw-guard audit
```

ستظهر نتائج الفحص على النحو التالي:

```
OpenClaw Security Guard v1.0.0
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
Secrets Scanner............ No issues
Config Auditor............. 2 critical
Injection Detector......... No issues
Dependency Scanner......... 1 warning
MCP Server Auditor......... No issues
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
Security Score: 65/100
```

### 2. اصلاح المشكلات

```bash
# الوضع التفاعلي
openclaw-guard fix

# الوضع التلقائي
openclaw-guard fix --auto

# معاينة التغييرات فقط بدون تطبيقها
openclaw-guard fix --dry-run
```

### 3. تشغيل لوحة المراقبة

```bash
openclaw-guard dashboard
```

عند التشغيل لاول مرة، سيطلب منك انشاء كلمة مرور (8 احرف على الاقل). بعدها يمكنك الوصول الى لوحة المراقبة عبر العنوان: `http://localhost:18790`

---

## الماسحات الامنية

تتضمن الاداة خمسة ماسحات امنية متخصصة:

| الماسح | الوظيفة |
|--------|---------|
| **الاسرار** (Secrets) | يكتشف مفاتيح API والرموز المميزة وكلمات المرور في اكثر من 15 صيغة |
| **الاعدادات** (Config) | يدقق اعدادات OpenClaw وفق اكثر من 15 قاعدة امنية |
| **حقن الاوامر** (Prompts) | يكتشف اكثر من 50 نمط حقن |
| **الاعتماديات** (Dependencies) | يفحص حزم npm بحثا عن ثغرات معروفة |
| **خوادم MCP** | يتحقق من سلامة خوادم MCP المثبتة |

---

## مرجع الاوامر

### الخيارات العامة

```bash
openclaw-guard [command] [options]

Options:
  -V, --version        رقم الاصدار
  -c, --config <path>  مسار ملف الاعدادات
  -l, --lang <lang>    اللغة (en|fr|ar)
  -v, --verbose        مخرجات مفصلة
  -q, --quiet          الوضع الصامت
  -h, --help           عرض المساعدة
```

### جدول الاوامر

| الامر | الوصف |
|-------|-------|
| `openclaw-guard audit` | تدقيق امني شامل |
| `openclaw-guard audit --deep` | تدقيق معمق (ابطا لكن اشمل) |
| `openclaw-guard audit --quick` | تدقيق سريع |
| `openclaw-guard audit --ci` | وضع التكامل المستمر |
| `openclaw-guard fix` | اصلاح تفاعلي للمشكلات |
| `openclaw-guard fix --auto` | اصلاح تلقائي بدون تاكيد |
| `openclaw-guard fix --dry-run` | معاينة الاصلاحات بدون تطبيقها |
| `openclaw-guard dashboard` | تشغيل لوحة المراقبة الحية |
| `openclaw-guard dashboard --port 3000` | تشغيل لوحة المراقبة على منفذ مخصص |
| `openclaw-guard scan secrets` | فحص الاسرار المكشوفة |
| `openclaw-guard scan config` | تدقيق الاعدادات |
| `openclaw-guard scan config --strict` | تدقيق صارم للاعدادات |
| `openclaw-guard scan prompts` | كشف انماط حقن الاوامر |
| `openclaw-guard report --format html` | انشاء تقرير بصيغة HTML |
| `openclaw-guard report --format json` | انشاء تقرير بصيغة JSON |
| `openclaw-guard report --format md` | انشاء تقرير بصيغة Markdown |
| `openclaw-guard hooks install` | تثبيت خطافات Git |
| `openclaw-guard hooks uninstall` | ازالة خطافات Git |
| `openclaw-guard hooks status` | التحقق من حالة الخطافات |
| `openclaw-guard about` | معلومات عن الاداة |

---

## نقاط الامان

### كيفية الاحتساب

تبدا نقاط الامان من 100 نقطة، ويتم خصم النقاط وفقا للمشكلات المكتشفة:

| العامل | النقاط المخصومة |
|--------|-----------------|
| صندوق الحماية (Sandbox) ليس في وضع "always" | -20 |
| سياسة الرسائل المباشرة (DM Policy) في وضع "open" | -15 |
| البوابة (Gateway) على عنوان IP عام | -15 |
| الوضع المرتفع (Elevated Mode) مفعل | -10 |
| تحديد المعدل (Rate Limiting) معطل | -5 |
| كل نتيجة حرجة (Critical) | -10 |
| كل نتيجة عالية الخطورة (High) | -5 |
| كل نتيجة متوسطة الخطورة (Medium) | -2 |

### نطاقات التقييم

| النقاط | الحالة | المعنى |
|--------|--------|--------|
| 80-100 | سليم | النظام في حالة امنية جيدة |
| 60-79 | يتطلب اهتماما | توجد مشكلات ينبغي معالجتها |
| 0-59 | حرج | توجد مشكلات امنية خطيرة تستوجب التدخل الفوري |

### تحسين النقاط

1. شغل الاصلاح التلقائي: `openclaw-guard fix --auto`
2. اتبع التوصيات المقدمة
3. اعد تشغيل التدقيق: `openclaw-guard audit`

---

## لوحة المراقبة

### الاعداد الاولي

1. شغل الامر `openclaw-guard dashboard`
2. سيفتح المتصفح على العنوان `http://localhost:18790`
3. ستظهر صفحة الاعداد
4. انشئ كلمة مرور (8 احرف على الاقل)
5. ستدخل مباشرة الى لوحة المراقبة

### عند التشغيل اللاحق

ادخل كلمة المرور التي انشاتها سابقا للوصول الى لوحة المراقبة.

### مزايا لوحة المراقبة

| الميزة | الوصف |
|--------|-------|
| نقاط الامان | تقييم مباشر من 0 الى 100 |
| الطلبات في الدقيقة | عداد فوري للطلبات |
| تكلفة اليوم | تتبع تكاليف واجهة API |
| التهديدات | محاولات الحقن والحظر وتجاوز الحدود |
| حالة الاعدادات | صندوق الحماية والبوابة وسياسة الرسائل |
| التنبيهات | اخر التنبيهات الامنية |

### اعادة تعيين كلمة المرور

في حال نسيان كلمة المرور، احذف ملف المصادقة ثم اعد تشغيل لوحة المراقبة:

```bash
rm ~/.openclaw-security-guard/auth.json
openclaw-guard dashboard
```

---

## الخصوصية والامان

### ما لا تفعله هذه الاداة

- **بدون قياس عن بعد** (No Telemetry): لا نجمع اي بيانات على الاطلاق
- **بدون اتصالات خارجية** (No Phone Home): لا ترسل الاداة اي طلبات عبر الشبكة
- **بدون تتبع** (No Tracking): استخدامك خاص تماما
- **بدون حوسبة سحابية** (No Cloud): كل شيء يعمل محليا على جهازك

### ما تفعله هذه الاداة

- تعمل بالكامل على جهازك المحلي
- لوحة المراقبة مرتبطة بالعنوان المحلي (localhost) فقط
- حماية لوحة المراقبة بكلمة مرور
- لا توجد اعتماديات خارجية وقت التشغيل

### امان الشيفرة المصدرية

خضعت هذه الاداة لتدقيق امني شامل:

- لا يوجد تنفيذ ديناميكي للشيفرة
- لا يوجد حقن لاوامر الصدفة (Shell)
- التحقق من المدخلات باستخدام Zod
- حماية من اختراق المسارات (Path Traversal)
- حماية من هجمات XSS في التقارير
- مقارنة كلمات المرور بطريقة امنة زمنيا (Timing-safe)
- رموز جلسات امنة

---

## الاعداد

انشئ ملف `.openclaw-guard.json` في مجلد المشروع او المجلد الرئيسي:

```json
{
  "scanners": {
    "secrets": {
      "enabled": true,
      "exclude": ["*.test.js", "node_modules/**"]
    },
    "config": {
      "enabled": true,
      "strict": true
    },
    "prompts": {
      "enabled": true,
      "sensitivity": "high"
    }
  },
  "dashboard": {
    "port": 18790
  },
  "reporting": {
    "format": "html",
    "outputDir": "./security-reports"
  }
}
```

---

## المساهمة

نرحب بمساهماتكم! يرجى الاطلاع على [دليل المساهمة](../../CONTRIBUTING.md).

### كيفية المساهمة

```bash
# استنساخ المستودع
git clone https://github.com/2pidata/openclaw-security-guard.git
cd openclaw-security-guard

# تثبيت الاعتماديات
npm install

# تشغيل الاختبارات
npm test

# التشغيل في وضع التطوير
npm run dev
```

### طرق المساهمة

- الابلاغ عن الاخطاء
- اقتراح ميزات جديدة
- تحسين التوثيق
- اضافة ترجمات
- تقديم طلبات سحب (Pull Requests)

---

## روابط مهمة

- [المستودع الرئيسي على GitHub](https://github.com/2pidata/openclaw-security-guard)
- [الابلاغ عن خلل](https://github.com/2pidata/openclaw-security-guard/issues)
- [دليل المساهمة](../../CONTRIBUTING.md)
- [سياسة الامان](../../SECURITY.md)
- [الموقع الالكتروني](https://2pidata.com)

---

<div align="center">

**صنعه [Miloud Belarebia](https://github.com/miloudbelarebia)**

**[2pidata.com](https://2pidata.com)** | **#databelarebia**

</div>

</div>
