# 📚 OpenClaw Security Guard - Documentation

<div align="center">

<img src="./assets/logo.png" alt="OpenClaw Security Guard" width="150">

## Complete Documentation

**The security layer your AI assistant needs**

[![npm](https://img.shields.io/npm/v/openclaw-security-guard?style=flat-square)](https://www.npmjs.com/package/openclaw-security-guard)
[![License](https://img.shields.io/badge/License-MIT-green?style=flat-square)](../LICENSE)

**Created by [Miloud Belarebia](https://2pidata.com)**

</div>

---

## 📖 Documentation Index

### Getting Started

| Document | Description |
|----------|-------------|
| [🚀 Quick Start](./guides/getting-started.md) | Get running in 5 minutes |
| [📥 Installation](./en/README.md#installation) | Installation instructions |

### User Guides

| Document | Description |
|----------|-------------|
| [🇬🇧 English Documentation](./en/README.md) | Complete English docs |
| [🇫🇷 Documentation Française](./fr/README.md) | Documentation complète en français |
| [🇲🇦 التوثيق بالعربية](./ar/README.md) | التوثيق بالعربية |

### Reference

| Document | Description |
|----------|-------------|
| [📋 CLI Reference](./api/cli.md) | All CLI commands and options |
| [🔌 Programmatic API](./api/programmatic.md) | Use in your Node.js apps |

### Project

| Document | Description |
|----------|-------------|
| [🤝 Contributing](../CONTRIBUTING.md) | How to contribute |
| [🔒 Security Policy](../SECURITY.md) | Security practices |
| [📝 Changelog](../CHANGELOG.md) | Version history |
| [📜 License](../LICENSE) | MIT License |

---

## 🌍 Language Support

| Language | Status | Link |
|----------|--------|------|
| 🇬🇧 English | ✅ Complete | [Read](./en/README.md) |
| 🇫🇷 Français | ✅ Complete | [Lire](./fr/README.md) |
| 🇲🇦 العربية | ✅ Complete | [اقرأ](./ar/README.md) |

---

## ⚡ Quick Links

### Most Common Tasks

```bash
# Run security audit
openclaw-guard audit

# Fix issues automatically
openclaw-guard fix --auto

# Start dashboard
openclaw-guard dashboard

# Generate report
openclaw-guard report -f html
```

### FAQ

- [Is my data sent anywhere?](./en/README.md#faq) - **No, 100% local**
- [How do I reset my dashboard password?](./en/README.md#password-reset)
- [Can I use this in CI/CD?](./en/README.md#cicd-integration) - **Yes!**

---

## 🆘 Need Help?

- 📖 Read the [documentation](./en/README.md)
- 🐛 [Report a bug](https://github.com/2pidata/openclaw-security-guard/issues)
- 💡 [Request a feature](https://github.com/2pidata/openclaw-security-guard/issues)
- 🌐 Visit [2pidata.com](https://2pidata.com)

---

<div align="center">

**Made with ❤️ by [Miloud Belarebia](https://github.com/2pidata)**

[GitHub](https://github.com/2pidata/openclaw-security-guard) •
[npm](https://www.npmjs.com/package/openclaw-security-guard) •
[2pidata.com](https://2pidata.com)

#databelarebia 🇲🇦

</div>
