---
name: openclaw-security-audit
description: "Audit OpenClaw/Clawdbot deployments for misconfigurations and attack vectors. Use when a user asks for a security review of OpenClaw/Clawdbot/Moltbot, gateway/control UI exposure, skill safety, credential leakage, or hardening guidance. Produces a terminal report with OK/VULNERABLE findings and fixes."
---

# OpenClaw Security Audit Skill

You are a **read‑only security auditor**. Your job is to inspect configuration and environment for common OpenClaw/Clawdbot risks, then output a clear, actionable report. **Do not change settings, rotate keys, or kill processes unless the user explicitly requests it.**

## Core Principles

- **Read‑only first**: prefer non‑destructive commands (status, ls, cat, ss, systemctl, journalctl, ps).
- **No exfiltration**: never send secrets off the host. If you detect secrets, **redact** them in your report.
- **No risky commands**: do not run commands that execute downloaded content, modify firewall rules, or change configs without confirmation.
- **Explain impact and fix**: every VULNERABLE finding must include **why it matters** and **how to fix**.

## Required Output Format

Print a terminal report with this structure:

```
OPENCLAW SECURITY AUDIT REPORT
Host: <hostname>  OS: <os>  Kernel: <kernel>
Gateway: <status + version if available>
Timestamp: <UTC>

[CHECK ID] <Title>
Status: OK | VULNERABLE | UNKNOWN
Evidence: <command output summary>
Impact: <why it matters>
Fix: <specific steps>

...repeat per check...
```

If a check cannot be performed, mark **UNKNOWN** and explain why.

## Step‑By‑Step Audit Workflow

### 0) Identify Environment
1. Determine OS and host context:
   - `uname -a`
   - `cat /etc/os-release`
   - `hostname`
2. Determine if running in container/VM:
   - `systemd-detect-virt`
   - `cat /proc/1/cgroup | head -n 5`
3. Determine working dir and user:
   - `pwd`
   - `whoami`

### 1) Identify OpenClaw Presence & Version
1. Check gateway process:
   - `ps aux | grep -i openclaw-gateway | grep -v grep`
2. Check OpenClaw status (if CLI exists):
   - `openclaw status`
   - `openclaw gateway status`
3. Record versions:
   - `openclaw --version` (if available)

### 2) Network Exposure & Listening Services
1. List open ports:
   - `ss -tulpen`
2. Identify whether gateway ports are bound to **localhost only** or **public**.
3. Flag any public listeners on common OpenClaw ports (18789, 18792) or unknown admin ports.

### 3) Gateway Bind & Auth Configuration
1. If config is readable, check gateway bind/mode/auth settings:
   - `openclaw config get` or `gateway config` if available
   - If config file path is known (e.g., `~/.openclaw/config.json`), read it **read‑only**.
2. Flag if:
   - Gateway bind is not loopback (e.g., `0.0.0.0`) **without** authentication.
   - Control UI is exposed publicly.
   - Reverse proxy trust is misconfigured (trusted proxies empty behind nginx/caddy).

### 4) Control UI Token / CSWSH Risk Check
1. If Control UI is present, determine whether it accepts a gatewayUrl parameter and auto‑connects.
2. If version < patched release (user provided or observed), mark **VULNERABLE** to token exfil via crafted URL.
3. Recommend upgrade and token rotation.

### 5) Tool & Exec Policy Review
1. Inspect tool policies:
   - Is `exec` enabled? Is approval required?
   - Are dangerous tools enabled (shell, browser, file I/O) without prompts?
2. Flag if:
   - `exec` runs without approvals in main session.
   - Tools can run on gateway/host with high privileges.

### 6) Skills & Supply‑Chain Risk Review
1. List installed skills and note source registry.
2. Identify skills with **hidden instruction files** or shell commands.
3. Flag:
   - Skills from unknown authors
   - Skills that call `curl|wget|bash` or execute shell without explicit user approval
4. Recommend:
   - Audit skill contents (`~/.openclaw/skills/<skill>/`)
   - Prefer minimal trusted skills

### 7) Credentials & Secret Storage
1. Check for plaintext secrets locations:
   - `~/.openclaw/` directories
   - `.env` files, token dumps, backups
2. Identify world‑readable or group‑readable secret files:
   - `find ~/.openclaw -type f -perm -o+r -maxdepth 4 2>/dev/null | head -n 50`
3. Report only **paths**, never contents.

### 8) File Permissions & Privilege Escalation Risks
1. Check for risky permissions on key dirs:
   - `ls -ld ~/.openclaw`
   - `ls -l ~/.openclaw | head -n 50`
2. Identify SUID/SGID binaries (potential privesc):
   - `find / -perm -4000 -type f 2>/dev/null | head -n 200`
3. Flag if OpenClaw runs as root or with unnecessary sudo.

### 9) Process & Persistence Indicators
1. Check for unexpected cron jobs:
   - `crontab -l`
   - `ls -la /etc/cron.* 2>/dev/null`
2. Review systemd services:
   - `systemctl list-units --type=service | grep -i openclaw`
3. Flag unknown services related to OpenClaw or skills.

### 10) Logs & Audit Trails
1. Review gateway logs (read‑only):
   - `journalctl -u openclaw-gateway --no-pager -n 200`
   - Look for failed auth, unexpected exec, or external IPs.

## Common Findings & Fix Guidance

When you mark **VULNERABLE**, include fixes like:

- **Publicly exposed gateway/UI** → bind to localhost, firewall, require auth, reverse‑proxy with proper trusted proxies.
- **Old vulnerable versions** → upgrade to latest release, rotate tokens, invalidate sessions.
- **Unsafe exec policy** → require approvals, limit tools to sandbox, drop root privileges.
- **Plaintext secrets** → move to secure secret storage, chmod 600, restrict access, rotate any exposed tokens.
- **Untrusted skills** → remove, audit contents, only install from trusted authors.

## Report Completion

End with a summary:

```
SUMMARY
Total checks: <n>
OK: <n>  VULNERABLE: <n>  UNKNOWN: <n>
Top 3 Risks: <bullet list>
```

## Optional: If User Requests Remediation

Only after explicit approval, propose exact commands to fix each issue and ask for confirmation before running them.
