# Screenshots Guide

**截图指南和占位符**  
**Version:** 1.0  
**Date:** March 2, 2026

---

## 📸 需要的截图

### 1. 配置向导界面

**文件：** `config_wizard.png`  
**尺寸：** 1200x800  
**内容：**

```
╔══════════════════════════════════════════════════════════╗
║          OpenClaw Router Skill v3.0 - 配置向导            ║
╚══════════════════════════════════════════════════════════╝

🔍 环境检测...
✅ Ollama 已安装，发现 2 个模型
   • qwen2.5:14b-32k
   • qwen2.5:7b-32k
✅ 阿里云百炼已配置 (Key: sk-5d5ca...)

📋 推荐配置:
  主路由：qwen2.5:14b-32k (本地，免费)
  验证：dashscope/qwen3.5-plus (云端，¥0.002/1k)
  专家：dashscope/qwen3-max (云端，¥0.04/1k)
  
  阈值模式：balanced
  预算建议：¥100/月

[1] 使用推荐配置 (推荐)
[2] 自定义配置
[4] 稍后设置

输入选项 [1-4]:
```

**如何获取：**
```bash
cd /root/.openclaw/workspace/router_skill
python3 router_config_wizard.py
# 截图终端窗口
```

---

### 2. Token 用量显示

**文件：** `token_usage.png`  
**尺寸：** 1200x600  
**内容：**

```markdown
用户：写个 Python 函数，计算斐波那契数列

助手：[代码输出]

---
【本次用量】
- 使用模型：qwen2.5:14b-32k (本地)
- Token 估算：输入~50 / 输出~400 = 总计~450
- 成本：¥0 (本地免费)

【套餐剩余】
- 百炼包月：¥200/月 (剩 28 天)
- 估算已用：~5%
- 日均可用：¥7.1
- 状态：✅ 额度充足
---
```

**如何获取：**
1. 启用 Router Skill
2. 运行一个代码生成任务
3. 截图回答底部的用量显示

---

### 3. 预算追踪界面

**文件：** `budget_tracking.png`  
**尺寸：** 1200x800  
**内容：**

```
╔══════════════════════════════════════════════════════════╗
║          Router Skill - 预算追踪                          ║
╚══════════════════════════════════════════════════════════╝

本月预算：¥200
已用：¥45.60 (22.8%)
剩余：¥154.40
剩余天数：28 天

日均可用：¥7.1
今日已用：¥2.30

────────────────────────────────────────────────────────────

使用分布:
  本地模型：████████████████████ 80% (¥0)
  L2 验证：  ████ 15% (¥5.60)
  L3 专家：  █ 5% (¥40)

────────────────────────────────────────────────────────────

告警阈值:
  ✅ 50% - 未触发
  ✅ 80% - 未触发
  ✅ 95% - 未触发
```

**如何获取：**
```bash
openclaw router budget --show
# 截图输出
```

---

### 4. 模型路由演示

**文件：** `model_routing.png`  
**尺寸：** 1200x800  
**内容：**

```
╔══════════════════════════════════════════════════════════╗
║          Router Skill - 模型路由演示                      ║
╚══════════════════════════════════════════════════════════╝

任务 1: "1+1=?"
  自评：5.0 分 → 本地 14b (直接提交)
  ✅ 完成，成本：¥0

任务 2: "写个 Flask API"
  自评：3.2 分 → 本地 14b + 验证
  ✅ 验证通过，成本：¥0.02

任务 3: "公司 3 年技术战略"
  自评：2.0 分 → L3 专家模型
  ✅ 完成，成本：¥0.12

────────────────────────────────────────────────────────────

总计:
  本地处理：2 次 (67%)
  验证：1 次 (33%)
  L3 专家：0 次 (0%)
  
  总成本：¥0.14
  传统方案：¥0.36
  节省：61% ✅
```

**如何获取：**
```bash
openclaw router demo
# 或手动运行演示任务并截图
```

---

### 5. 多语言支持

**文件：** `multilingual.png`  
**尺寸：** 1200x600  
**内容：**

```
╔══════════════════════════════════════════════════════════╗
║          Router Skill - 多语言支持                        ║
╚══════════════════════════════════════════════════════════╝

语言切换:
  [EN] English
  [ZH] 中文

当前：中文

────────────────────────────────────────────────────────────

文档语言:
  ✅ README.md (中文)
  ✅ README.md (English)
  ✅ FAQ.md (中文)
  ✅ FAQ.md (English)
  ✅ EXAMPLES.md (中文)
  ✅ EXAMPLES.md (English)

────────────────────────────────────────────────────────────

i18n 模块:
  ✅ 自动检测
  ✅ 50+ 翻译字符串
  ✅ 参数格式化
  ✅ 回退到英文
```

**如何获取：**
```bash
openclaw router i18n --show
# 截图输出
```

---

### 6. 云服务商支持

**文件：** `cloud_providers.png`  
**尺寸：** 1200x800  
**内容：**

```
╔══════════════════════════════════════════════════════════╗
║          Router Skill - 全球云服务商支持                   ║
╚══════════════════════════════════════════════════════════╝

已检测的云服务商:

✅ 阿里云百炼
   Key: sk-5d5ca...
   模型：qwen3.5-plus, qwen3-max, kimi-k2.5...

✅ OpenAI
   Key: sk-proj-...
   模型：gpt-4, gpt-4o, gpt-3.5-turbo...

✅ Anthropic
   Key: sk-ant-...
   模型：claude-3-opus, claude-3-sonnet...

✅ AWS Bedrock
   Key: AKIA...
   模型：Various via Bedrock

✅ Azure OpenAI
   Endpoint: https://...
   模型：GPT-4, GPT-3.5

✅ Google Vertex AI
   Credentials: Configured
   模型：Gemini Pro, Gemini Ultra

────────────────────────────────────────────────────────────

总计：6 大云服务商，46+ 模型
```

**如何获取：**
```bash
openclaw router providers --show
# 截图输出
```

---

## 📷 截图工具推荐

### Linux

```bash
# 全屏截图
gnome-screenshot -f screenshot.png

# 选择区域截图
gnome-screenshot -a -f screenshot.png

# 延迟截图
gnome-screenshot -d 5 -f screenshot.png
```

### macOS

```bash
# 全屏截图
cmd + shift + 3

# 选择区域截图
cmd + shift + 4

# 窗口截图
cmd + shift + 4, then space
```

### Windows

```bash
# 截图工具
Win + Shift + S

# 全屏截图
PrtScn

# 活动窗口截图
Alt + PrtScn
```

---

## 🎨 截图优化建议

### 终端主题

推荐使用以下主题以获得最佳截图效果：

- **背景：** 深色 (#1e1e1e 或 #000000)
- **文字：** 亮色 (#ffffff 或 #f8f8f2)
- **强调色：** 绿色 (#50fa7b), 蓝色 (#8be9fd)

### 字体

- **推荐：** Fira Code, JetBrains Mono, Cascadia Code
- **大小：** 14-16px
- **行距：** 1.2-1.5

### 窗口大小

- **推荐：** 1200x800 或 1600x900
- **最小：** 800x600
- **最大：** 1920x1080

---

## 📋 截图清单

提交前确保有以下截图：

- [ ] config_wizard.png - 配置向导
- [ ] token_usage.png - Token 用量
- [ ] budget_tracking.png - 预算追踪
- [ ] model_routing.png - 路由演示
- [ ] multilingual.png - 多语言
- [ ] cloud_providers.png - 云服务商

**可选截图：**

- [ ] test_results.png - 测试结果
- [ ] compliance.png - 合规文档
- [ ] pricing.png - 定价对比

---

## 🖼️ 截图占位符

如果暂时没有真实截图，可以使用：

1. **ASCII 艺术图**（如上所示）
2. **代码块模拟**
3. **文字描述**

**注意：** 正式提交前最好有真实截图以提高转化率。

---

_Last updated: March 2, 2026_
