# Terms of Service

**Effective Date:** March 2, 2026  
**Last Updated:** March 2, 2026  
**Version:** 1.0

---

## 1. Agreement to Terms

By accessing or using OpenClaw Router Skill (the "Service"), you agree to be bound by these Terms of Service ("Terms").

**If you do not agree to these Terms, do not use the Service.**

---

## 2. Description of Service

Router Skill is an intelligent model routing system that:

- Automatically selects optimal AI models for your tasks
- Provides cost optimization and budget management
- Supports multiple cloud providers and local models
- Displays usage statistics and cost tracking

### 2.1 Service Tiers

| Tier | Price | Features |
|------|-------|----------|
| **Free** | $0 | 1000 requests/month, basic features |
| **Premium** | $9.99/month | Unlimited requests, advanced features |
| **Enterprise** | $29.99/month | All features + priority support + SLA |

---

## 3. Eligibility

You must:

- ✅ Be at least 16 years old
- ✅ Have legal capacity to enter into agreements
- ✅ Not be prohibited from using the Service under applicable law
- ✅ Use the Service in compliance with all applicable laws

---

## 4. Account Registration

### 4.1 Registration Requirements

To use certain features, you must:

- Provide accurate and complete information
- Maintain and update your information
- Keep your credentials secure
- Notify us of any unauthorized use

### 4.2 Account Responsibility

You are responsible for:

- All activities under your account
- Maintaining account security
- Notifying us of security breaches

---

## 5. Acceptable Use

### 5.1 Permitted Uses

You may use the Service to:

- Route AI model requests intelligently
- Track usage and costs
- Manage budgets and alerts
- Access supported cloud providers

### 5.2 Prohibited Uses

You **MUST NOT** use the Service to:

- ❌ Violate any applicable laws or regulations
- ❌ Infringe intellectual property rights
- ❌ Transmit malware or malicious code
- ❌ Attempt to gain unauthorized access
- ❌ Reverse engineer or decompile the Service
- ❌ Use for illegal or fraudulent purposes
- ❌ Harass, abuse, or harm others
- ❌ Transmit spam or unsolicited messages

### 5.3 AI Model Usage

When using cloud AI models through our Service:

- ✅ Comply with each provider's terms of service
- ✅ Do not use for prohibited content
- ✅ Respect rate limits and quotas
- ✅ Pay for your API usage

---

## 6. Intellectual Property

### 6.1 Our Property

The Service and its original content are protected by:

- Copyright laws
- Trademark laws
- Patent laws
- Trade secret laws

**All rights reserved.**

### 6.2 Your Content

You retain ownership of:

- Your conversation content
- Your configuration data
- Your usage data

### 6.3 License Grant

You grant us a limited license to:

- Process your data to provide the Service
- Display usage statistics (anonymized)
- Improve the Service

---

## 7. Payment and Billing

### 7.1 Free Tier

- 1000 requests per month
- Basic features only
- No payment required

### 7.2 Premium Tier

- $9.99 USD per month
- Billed monthly
- Cancel anytime

### 7.3 Enterprise Tier

- $29.99 USD per month
- Billed monthly or annually
- SLA included

### 7.4 Payment Methods

We accept:

- Credit cards (Visa, MasterCard, Amex)
- PayPal
- Alipay (China)
- WeChat Pay (China)

### 7.5 Refund Policy

- **Free tier:** No refunds (free)
- **Premium tier:** Pro-rated refunds within 30 days
- **Enterprise tier:** As per SLA agreement

### 7.6 Price Changes

We may change prices:

- With 30 days notice
- For new subscriptions only
- Existing subscriptions honored until renewal

---

## 8. Third-Party Services

### 8.1 Cloud Providers

The Service integrates with:

- Alibaba Cloud
- OpenAI
- Anthropic
- AWS Bedrock
- Azure OpenAI
- Google Vertex AI

**You are responsible for:**

- Your API keys
- Compliance with their terms
- Payment for their services

### 8.2 Third-Party Links

The Service may contain links to third-party sites. We are not responsible for:

- Their content
- Their privacy practices
- Their terms of service

---

## 9. Disclaimers

### 9.1 "As Is" Basis

THE SERVICE IS PROVIDED "AS IS" AND "AS AVAILABLE" WITHOUT WARRANTIES OF ANY KIND.

### 9.2 No Warranties

WE DISCLAIM ALL WARRANTIES:

- ❌ No warranty of merchantability
- ❌ No warranty of fitness for particular purpose
- ❌ No warranty of non-infringement
- ❌ No warranty of uninterrupted service
- ❌ No warranty of error-free service

### 9.3 AI Model Accuracy

WE DO NOT WARRANT:

- Accuracy of AI model outputs
- Completeness of information
- Suitability for your purposes

**You are responsible for verifying AI outputs.**

---

## 10. Limitation of Liability

### 10.1 Maximum Liability

TO THE MAXIMUM EXTENT PERMITTED BY LAW:

- Our total liability shall not exceed the amount you paid in the last 12 months
- For free users: Maximum liability is $100 USD

### 10.2 Excluded Damages

WE ARE NOT LIABLE FOR:

- Indirect damages
- Incidental damages
- Consequential damages
- Punitive damages
- Lost profits
- Lost data
- Business interruption

### 10.3 Essential Basis

This limitation of liability is an essential basis of our agreement.

---

## 11. Indemnification

You agree to indemnify and hold us harmless from:

- Claims arising from your use of the Service
- Violation of these Terms
- Infringement of third-party rights
- Your violation of any laws

---

## 12. Term and Termination

### 12.1 Term

These Terms remain in effect while you use the Service.

### 12.2 Termination by You

You may terminate:

- Your account at any time
- Your subscription at any time (pro-rated refund)

### 12.3 Termination by Us

We may terminate:

- Your account for violation of Terms
- The Service with 30 days notice
- Immediately for illegal use

### 12.4 Effect of Termination

Upon termination:

- Your license to use the Service ends
- We will delete your data (per Privacy Policy)
- Pro-rated refunds will be issued (if applicable)

---

## 13. Dispute Resolution

### 13.1 Informal Resolution

We encourage you to contact us first:

- Email: pepsiboy87@example.com
- GitHub Issues: https://github.com/pepsiboy87/openclaw-router/issues

### 13.2 Governing Law

These Terms are governed by:

- **Primary:** Laws of the People's Republic of China
- **EU Residents:** Mandatory provisions of local law apply
- **California Residents:** California Consumer Privacy Act applies

### 13.3 Jurisdiction

- **Primary:** Courts of People's Republic of China
- **EU Residents:** Courts of your country of residence
- **Class Action Waiver:** No class actions permitted

### 13.4 Arbitration (Optional)

For disputes under $10,000 USD:

- Binding arbitration available
- Faster resolution
- Lower costs

---

## 14. Changes to Terms

We may modify these Terms:

- **Notice:** 30 days notice for material changes
- **Posting:** Changes posted on this page
- **Acceptance:** Continued use constitutes acceptance

**Check these Terms periodically for updates.**

---

## 15. Miscellaneous

### 15.1 Entire Agreement

These Terms constitute the entire agreement between you and us.

### 15.2 Severability

If any provision is unenforceable, the remaining provisions remain in effect.

### 15.3 Waiver

Our failure to enforce any right is not a waiver of that right.

### 15.4 Assignment

You may not assign these Terms. We may assign without your consent.

### 15.5 Force Majeure

We are not liable for delays beyond our reasonable control.

### 15.6 Contact Information

| Purpose | Contact |
|---------|---------|
| General Questions | pepsiboy87@example.com |
| Legal Questions | pepsiboy87@example.com |
| Privacy Questions | pepsiboy87@example.com |
| Billing Questions | pepsiboy87@example.com |

---

## 16. Regional Supplements

### 16.1 European Union

For EU residents:

- GDPR rights apply
- 14-day cooling-off period
- Local consumer protections apply

### 16.2 California

For California residents:

- CCPA rights apply
- Shine the Light law applies
- Specific disclosure requirements met

### 16.3 China

For China residents:

- PIPL rights apply
- Local data storage requirements met
- Specific consumer protections apply

---

## 17. Acknowledgment

BY USING THE SERVICE, YOU ACKNOWLEDGE THAT YOU:

- Have read these Terms
- Understand these Terms
- Agree to be bound by these Terms
- Are at least 16 years old

---

_Last reviewed: March 2, 2026_  
_Next review: September 2, 2026_
