# Privacy Policy

**Effective Date:** March 2, 2026  
**Last Updated:** March 2, 2026  
**Version:** 1.0

---

## 1. Introduction

OpenClaw Router Skill ("we", "us", or "our") respects your privacy and is committed to protecting your personal data. This privacy policy explains how we collect, use, and safeguard your information when you use our Router Skill application (the "Service").

**Please read this policy carefully to understand how we handle your data.**

---

## 2. Information We Collect

### 2.1 Information You Provide

We collect the following information that you provide to us:

- **Configuration Data:** API keys, model preferences, budget settings (stored locally only)
- **Usage Data:** Token counts, cost estimates, model selection history
- **Feedback:** Issues reports, feature requests, support communications

### 2.2 Information Collected Automatically

We automatically collect:

- **Device Information:** Operating system, Python version, OpenClaw version
- **Usage Statistics:** Request counts, model usage patterns (anonymized)
- **Performance Data:** Response times, error rates (anonymized)

### 2.3 Information We DO NOT Collect

We explicitly **DO NOT** collect:

- ❌ Your actual conversation content
- ❌ Your API request/response data
- ❌ Personal identification information (unless you voluntarily provide it)
- ❌ Payment information (handled by third-party processors)

---

## 3. How We Use Your Information

We use the collected information for:

### 3.1 Service Provision

- To configure and optimize model routing
- To display usage statistics and cost tracking
- To provide budget alerts and notifications

### 3.2 Service Improvement

- To analyze usage patterns (anonymized)
- To identify and fix bugs
- To develop new features

### 3.3 Communication

- To respond to your support requests
- To send important service notifications
- To inform you about updates (if you opt-in)

---

## 4. Data Storage and Security

### 4.1 Local Storage

**Most of your data is stored locally:**

- Configuration files: `~/.openclaw/router_config.yaml`
- Usage logs: `~/.openclaw/router_logs/`
- API keys: Stored in environment variables (recommended) or encrypted locally

### 4.2 Cloud Storage

**Minimal data is transmitted to our servers:**

- Anonymous usage statistics (opt-in)
- Crash reports (opt-in)
- Support communications

### 4.3 Security Measures

We implement:

- ✅ Local encryption for sensitive data
- ✅ HTTPS for all data transmission
- ✅ Access controls and authentication
- ✅ Regular security audits
- ✅ No plaintext API key storage

---

## 5. Data Sharing

### 5.1 We DO Share Data With:

| Third Party | Purpose | Data Shared |
|-------------|---------|-------------|
| **Cloud Providers** | Model inference | Your API requests (required for service) |
| **Payment Processors** | Subscription billing | Payment information only |
| **Analytics Services** | Usage analytics (opt-in) | Anonymized usage data |
| **Support Platforms** | Customer support | Your support communications |

### 5.2 We DO NOT Share/Sell/Rent:

- ❌ Your personal data to advertisers
- ❌ Your conversation content to third parties
- ❌ Your usage data without your consent

---

## 6. Your Rights

Depending on your location, you have the following rights:

### 6.1 Global Rights

- **Access:** Request a copy of your data
- **Correction:** Request correction of inaccurate data
- **Deletion:** Request deletion of your data
- **Export:** Request data portability

### 6.2 EU/EEA Residents (GDPR)

- **Right to be forgotten:** Request complete data deletion
- **Right to restrict processing:** Limit how we use your data
- **Right to object:** Object to certain processing activities
- **Right to withdraw consent:** Withdraw consent at any time

### 6.3 California Residents (CCPA)

- **Right to know:** Know what data is collected
- **Right to delete:** Delete personal information
- **Right to opt-out:** Opt-out of data sales (we don't sell data)
- **Right to non-discrimination:** Equal service regardless of privacy choices

### 6.4 China Residents (PIPL)

- **Right to informed:** Know how data is used
- **Right to access:** Access your personal information
- **Right to correction:** Correct inaccurate data
- **Right to deletion:** Delete data under certain conditions

### 6.5 How to Exercise Your Rights

Contact us at: **pepsiboy87@example.com**

We will respond within:
- **GDPR:** 30 days
- **CCPA:** 45 days
- **PIPL:** 15 days

---

## 7. International Data Transfers

### 7.1 Where Your Data Is Processed

Your data may be processed in:

- **China:** Primary development and support
- **United States:** Cloud services (AWS, OpenAI, etc.)
- **European Union:** EU cloud regions (if selected)
- **Other regions:** Based on your cloud provider selection

### 7.2 Safeguards

For international transfers, we ensure:

- ✅ Standard Contractual Clauses (SCCs)
- ✅ Adequacy decisions (where applicable)
- ✅ Appropriate technical safeguards

---

## 8. Children's Privacy

Our Service is **not intended for children under 16**.

We do not knowingly collect data from children under 16. If we discover such collection, we will delete the data immediately.

---

## 9. Data Retention

We retain your data:

- **Active users:** As long as your account is active
- **Inactive users:** Up to 2 years after last activity
- **Deleted accounts:** 30 days (for recovery), then permanently deleted
- **Legal requirements:** As required by applicable law

---

## 10. Changes to This Policy

We may update this privacy policy:

- **Notification:** We will notify you of material changes
- **Effective date:** Changes take effect on the stated date
- **Continued use:** Continued use constitutes acceptance

**Check this policy periodically for updates.**

---

## 11. Contact Us

For privacy-related questions:

| Method | Details |
|--------|---------|
| **Email:** | pepsiboy87@example.com |
| **GitHub:** | https://github.com/pepsiboy87/openclaw-router/issues |
| **Address:** | [Your Business Address] |

**Data Protection Officer (DPO):** pepsiboy87@example.com

---

## 12. Additional Terms

### 12.1 Third-Party Links

Our Service may contain links to third-party websites. We are not responsible for their privacy practices.

### 12.2 Business Transfers

In case of merger, acquisition, or sale, we will notify you before data is transferred.

### 12.3 Legal Requirements

We may disclose data if required by law or to protect our rights.

---

## 13. Definitions

| Term | Definition |
|------|------------|
| **Personal Data** | Any information relating to an identified or identifiable individual |
| **Processing** | Any operation performed on personal data |
| **Controller** | Entity that determines purposes and means of processing |
| **Processor** | Entity that processes data on behalf of controller |

---

## 14. Governing Law

This policy is governed by:

- **Primary:** Laws of the People's Republic of China
- **EU Residents:** GDPR supplements this policy
- **California Residents:** CCPA supplements this policy
- **Other regions:** Applicable local privacy laws

---

## 15. Acceptance

By using Router Skill, you acknowledge that you have read and understood this Privacy Policy.

**If you do not agree with this policy, please do not use our Service.**

---

_Last reviewed: March 2, 2026_  
_Next review: September 2, 2026_
