# GDPR Compliance Guide

**For European Union Users**  
**Version:** 1.0  
**Last Updated:** March 2, 2026

---

## 🇪🇺 GDPR Information for EU Users

OpenClaw Router Skill is committed to complying with the General Data Protection Regulation (GDPR).

---

## 1. Data Controller

**Data Controller:** pepsiboy87  
**Contact:** pepsiboy87@example.com  
**Address:** [Your Business Address]

---

## 2. Legal Basis for Processing

We process your data based on:

| Processing Activity | Legal Basis |
|---------------------|-------------|
| Service provision | Contract performance (Art. 6(1)(b)) |
| Usage analytics | Consent (Art. 6(1)(a)) |
| Security | Legitimate interest (Art. 6(1)(f)) |
| Legal compliance | Legal obligation (Art. 6(1)(c)) |

---

## 3. Your GDPR Rights

### 3.1 Right to Access (Art. 15)

You have the right to obtain:

- Confirmation of data processing
- Copy of your personal data
- Purpose of processing
- Categories of data
- Recipients of data

**How to exercise:** Email pepsiboy87@example.com

### 3.2 Right to Rectification (Art. 16)

You have the right to correct:

- Inaccurate data
- Incomplete data

**How to exercise:** Email pepsiboy87@example.com

### 3.3 Right to Erasure (Art. 17)

You have the right to deletion when:

- Data is no longer necessary
- You withdraw consent
- You object to processing
- Data was unlawfully processed

**How to exercise:** Email pepsiboy87@example.com  
**Response time:** 30 days

### 3.4 Right to Restriction (Art. 18)

You have the right to restrict processing when:

- Accuracy is contested
- Processing is unlawful
- Data is needed for legal claims

**How to exercise:** Email pepsiboy87@example.com

### 3.5 Right to Data Portability (Art. 20)

You have the right to receive your data in:

- Structured format
- Commonly used format
- Machine-readable format

**How to exercise:** Email pepsiboy87@example.com

### 3.6 Right to Object (Art. 21)

You have the right to object to:

- Processing based on legitimate interest
- Direct marketing
- Profiling

**How to exercise:** Email pepsiboy87@example.com

### 3.7 Right to Withdraw Consent (Art. 7)

You have the right to withdraw consent at any time.

**How to exercise:** Email pepsiboy87@example.com

---

## 4. Data Transfers Outside EU

### 4.1 Where Data Is Transferred

Your data may be transferred to:

- **China:** Primary development
- **United States:** Cloud services
- **Other countries:** Based on your selection

### 4.2 Safeguards

We ensure adequate protection through:

- ✅ Standard Contractual Clauses (SCCs)
- ✅ Adequacy decisions
- ✅ Technical safeguards

---

## 5. Data Retention

We retain your data:

| Data Type | Retention Period |
|-----------|------------------|
| Active accounts | As long as account is active |
| Inactive accounts | 2 years after last activity |
| Deleted accounts | 30 days (recovery), then deleted |
| Legal requirements | As required by law |

---

## 6. Security Measures

We implement:

- ✅ Encryption at rest and in transit
- ✅ Access controls
- ✅ Regular security audits
- ✅ Incident response plan
- ✅ Data minimization

---

## 7. Data Breach Notification

In case of data breach:

- **Notification to authority:** Within 72 hours
- **Notification to you:** If high risk
- **Contact:** pepsiboy87@example.com

---

## 8. Automated Decision Making

We do **NOT** use:

- ❌ Automated decision-making with legal effects
- ❌ Profiling with significant effects

---

## 9. Children's Data

Our Service is **not intended for children under 16**.

We do not knowingly collect data from children under 16.

---

## 10. Complaints

### 10.1 Internal Complaint Process

1. Contact us: pepsiboy87@example.com
2. We respond within 30 days
3. We attempt to resolve your complaint

### 10.2 External Complaint

If not satisfied, you can complain to:

- **Your local Data Protection Authority**
- **Lead Authority:** [Your country's DPA]

---

## 11. Updates

We may update this guide:

- **Notice:** Posted on this page
- **Effective date:** Stated in update
- **Review:** Every 6 months

---

## 12. Contact

**Data Protection Officer:** pepsiboy87@example.com

**Address:** [Your Business Address]

---

_Last reviewed: March 2, 2026_  
_Next review: September 2, 2026_
