# OpenClaw Router Skill - 使用示例

**版本：** 1.0.0  
**用途：** 展示实际使用场景

---

## 🚀 快速开始示例

### 示例 1: 首次安装配置

```bash
# 安装 Router Skill
bash install_router.sh

# 自动运行配置向导
🔍 检测环境...
✅ Ollama 已安装，发现 2 个模型
   • qwen2.5:14b-32k
   • qwen2.5:7b-32k
✅ 阿里云百炼已配置 (Key: sk-5d5ca...)

📋 推荐配置:
  主路由：qwen2.5:14b-32k (本地，免费)
  验证：dashscope/qwen3.5-plus (云端，¥0.002/1k)
  专家：dashscope/qwen3-max (云端，¥0.04/1k)
  
  阈值模式：balanced
  预算建议：¥100/月

[1] 使用推荐配置
[2] 自定义配置
[4] 稍后设置

输入选项 [1-4]: 1

✅ 配置完成！
```

---

### 示例 2: 简单问答（本地处理）

```
用户：今天几号？

助手：今天是 2026 年 3 月 2 日，周一。

---
【本次用量】
- 使用模型：qwen2.5:14b-32k (本地)
- Token 估算：输入~10 / 输出~30 = 总计~40
- 成本：¥0 (本地免费)

【套餐剩余】
- 百炼包月：¥200/月 (剩 28 天)
- 估算已用：~0%
- 日均可用：¥7.1
- 状态：✅ 额度充足
---
```

---

### 示例 3: 代码生成（本地处理）

```
用户：写个 Python 函数，计算斐波那契数列

助手：
```python
def fibonacci(n):
    """计算斐波那契数列的第 n 个数"""
    if n <= 0:
        return 0
    elif n == 1:
        return 1
    else:
        a, b = 0, 1
        for _ in range(2, n + 1):
            a, b = b, a + b
        return b

# 测试
for i in range(10):
    print(f"F({i}) = {fibonacci(i)}")
```

---
【本次用量】
- 使用模型：qwen2.5:14b-32k (本地)
- Token 估算：输入~50 / 输出~400 = 总计~450
- 成本：¥0 (本地免费)

【套餐剩余】
- 百炼包月：¥200/月 (剩 28 天)
- 估算已用：~0%
- 状态：✅ 额度充足
---
```

---

### 示例 4: 复杂方案设计（云端 L3）

```
用户：[BEST] 帮我设计公司 3 年技术发展战略

助手：（检测到复杂任务，自动使用 L3 专家模型）

# 公司 3 年技术发展战略

## 一、现状分析
...

## 二、战略目标
...

## 三、实施路径
...

## 四、风险评估
...

---
【本次用量】
- 使用模型：dashscope/qwen3-max (云端 L3)
- Token 估算：输入~200 / 输出~3000 = 总计~3200
- 成本：¥0.128 (包月额度)

【套餐剩余】
- 百炼包月：¥200/月 (剩 28 天)
- 估算已用：~1%
- 日均可用：¥7.1
- 状态：✅ 额度充足
---
```

---

### 示例 5: 边界情况（本地 + 验证）

```
用户：设计一个电商平台的数据库架构

助手：（本地 14b 完成，自评 3.2 分，触发验证）

【本地模型答案】
```sql
CREATE TABLE users (...);
CREATE TABLE products (...);
CREATE TABLE orders (...);
```

【验证报告】
- 验证器：dashscope/qwen3.5-plus
- 准确性：⭐⭐⭐⭐ (4/5)
- 完整性：⭐⭐⭐ (3/5)
- 建议：补充索引和审计字段

【最终答案】
（整合本地答案和验证建议）
```

---

## 🎯 不同场景示例

### 场景 1: 纯本地部署

```yaml
环境：
  - Ollama: ✅ qwen2.5:14b, qwen2.5:72b
  - 云 API: ❌

推荐配置：
  主路由：qwen2.5:14b
  专家：qwen2.5:72b
  阈值：auto_pass=3.5

适用用户：
  - 有高性能本地机器
  - 注重隐私
  - 预算有限
```

---

### 场景 2: 混合部署（推荐）

```yaml
环境：
  - Ollama: ✅ qwen2.5:14b
  - 云 API: ✅ 阿里云百炼

推荐配置：
  主路由：qwen2.5:14b (本地)
  验证：qwen3.5-plus (云端)
  专家：qwen3-max (云端)
  阈值：auto_pass=3.5, verify=3.0-3.5

适用用户：
  - 大多数用户
  - 平衡成本与质量
  - 日常开发
```

---

### 场景 3: 纯云端部署

```yaml
环境：
  - Ollama: ❌
  - 云 API: ✅ 阿里云 + OpenAI

推荐配置：
  主路由：qwen3.5-plus
  专家：qwen3-max / gpt-4
  阈值：auto_pass=4.0 (保守)

适用用户：
  - 无本地机器
  - 笔记本用户
  - 需要最强能力
```

---

## 📊 成本对比示例

### 任务：100 次请求

| 方案 | 本地 | L2 | L3 | 总成本 |
|------|------|----|----|--------|
| **传统方案** | 0 | 0 | 100 | ¥4.00 |
| **Router v3.0** | 80 | 15 | 5 | ¥1.60 |
| **节省** | - | - | - | **60%** |

---

### 月度预估（基于相似用户）

| 用户类型 | 传统方案 | Router v3.0 | 节省 |
|----------|----------|-------------|------|
| 个人开发者 | ¥150/月 | ¥60/月 | 60% |
| 小企业 | ¥500/月 | ¥200/月 | 60% |
| AI 工作室 | ¥2000/月 | ¥800/月 | 60% |

---

## 🔧 高级用法

### 1. 使用标签强制模型

```
用户：[L3] 这个问题很关键，用专家模型

助手：（强制使用 L3，即使自评得分高）
```

```
用户：[FAST] 快速回答，不用验证

助手：（跳过验证，直接本地回答）
```

```
用户：[VERIFY] 帮我验证这段代码

助手：（强制触发验证流程）
```

---

### 2. 自定义阈值

```yaml
# 编辑配置文件
~/.openclaw/router_config.yaml

thresholds:
  mode: "custom"
  auto_pass: 4.0      # 提高阈值，更保守
  verify_min: 3.5
  verify_max: 4.0
  escalate_below: 3.5
```

---

### 3. 预算告警

```yaml
budget:
  monthly: 200
  alert_at: [50, 80, 95]  # 50%/80%/95% 时告警
```

---

## 📞 需要帮助？

- **文档：** https://github.com/pepsiboy87/openclaw-router
- **Issue：** https://github.com/pepsiboy87/openclaw-router/issues
- **邮箱：** pepsiboy87@example.com

---

_让每个 AI 助手都拥有智能路由能力！_
