# CCPA Compliance Guide

**For California Residents**  
**Version:** 1.0  
**Last Updated:** March 2, 2026

---

## 🇺🇸 CCPA Information for California Users

OpenClaw Router Skill complies with the California Consumer Privacy Act (CCPA).

---

## 1. Your CCPA Rights

### 1.1 Right to Know

You have the right to know:

- What personal information we collect
- Sources of personal information
- Purpose of collection
- Third parties we share with

**How to exercise:** Email pepsiboy87@example.com

### 1.2 Right to Delete

You have the right to delete:

- Personal information we collected
- With some exceptions (legal requirements)

**How to exercise:** Email pepsiboy87@example.com  
**Response time:** 45 days

### 1.3 Right to Opt-Out

You have the right to opt-out of:

- Sale of personal information

**Note:** We do **NOT** sell your personal information.

### 1.4 Right to Non-Discrimination

You have the right to:

- Equal service regardless of privacy choices
- No price discrimination
- No quality discrimination

---

## 2. Personal Information We Collect

### 2.1 Categories Collected

| Category | Examples | Purpose |
|----------|----------|---------|
| **Identifiers** | Email, IP address | Service provision |
| **Commercial info** | Purchase history | Billing |
| **Internet activity** | Usage data | Service improvement |
| **Professional info** | Job title (if provided) | Support |

### 2.2 Categories NOT Collected

We do **NOT** collect:

- ❌ Social Security Numbers
- ❌ Financial account numbers
- ❌ Health information
- ❌ Biometric information

---

## 3. How We Use Your Information

We use your information for:

| Purpose | Legal Basis |
|---------|-------------|
| Service provision | Contract performance |
| Customer support | Legitimate interest |
| Billing | Contract performance |
| Security | Legitimate interest |
| Legal compliance | Legal obligation |

---

## 4. How We Share Your Information

### 4.1 We Share With:

| Category | Recipients | Purpose |
|----------|-----------|---------|
| Service providers | Cloud providers, payment processors | Service delivery |
| Legal | Government authorities | Legal compliance |
| Business transfers | Successor entities | Mergers/acquisitions |

### 4.2 We Do NOT:

- ❌ Sell your personal information
- ❌ Share with advertisers
- ❌ Share with data brokers

---

## 5. Financial Incentives

We do **NOT** offer financial incentives for:

- ❌ Waiving privacy rights
- ❌ Providing more data
- ❌ Allowing data sales

---

## 6. How to Exercise Your Rights

### 6.1 Submission Methods

You can submit requests via:

- **Email:** pepsiboy87@example.com
- **Web form:** [Coming soon]
- **Mail:** [Your Business Address]

### 6.2 Verification Process

We verify your identity through:

- Email verification
- Account authentication
- Additional info if needed

### 6.3 Response Timeline

- **Acknowledgment:** Within 10 days
- **Response:** Within 45 days
- **Extension:** Up to 90 days (if needed)

### 6.4 Authorized Agents

You can designate an authorized agent:

- Written authorization required
- We verify the authorization
- Same response timeline

---

## 7. No Discrimination

We will **NOT** discriminate against you for exercising your rights:

- ❌ No denial of service
- ❌ No price differences
- ❌ No quality differences
- ❌ No suggestion of price difference

---

## 8. Data Retention

We retain personal information:

| Purpose | Retention Period |
|---------|------------------|
| Active accounts | As long as needed |
| Legal compliance | As required by law |
| Dispute resolution | As needed for disputes |

---

## 9. Updates

We may update this notice:

- **Notice:** Posted on this page
- **Effective date:** Stated in update
- **Review:** Annually

---

## 10. Contact

**For CCPA questions:**

- **Email:** pepsiboy87@example.com
- **Address:** [Your Business Address]
- **Phone:** [Your Phone Number]

---

## 11. Statistics

### 11.1 CCPA Requests (2026)

| Request Type | Count | Fulfilled |
|--------------|-------|-----------|
| Right to Know | 0 | 0 |
| Right to Delete | 0 | 0 |
| Right to Opt-Out | 0 | 0 |

**Note:** Service launched March 2026

### 11.2 Response Times

- **Average response time:** N/A (new service)
- **Target:** Within 45 days
- **Compliance rate:** 100%

---

_Last reviewed: March 2, 2026_  
_Next review: March 2, 2027_
