# 💰 Router Skill 定价策略

**版本：** 1.0.0  
**日期：** 2026-03-02  
**状态：** ✅ 已更新（完全免费 + 付费支持）

---

## 🎉 完全免费开源！

**Router Skill v3.0 采用 MIT 许可证，完全免费开源！**

**核心功能：**
- ✅ 基础路由 - 免费
- ✅ Token 追踪 - 免费
- ✅ 环境检测 - 免费
- ✅ 配置向导 - 免费
- ✅ 模型选择 - 免费
- ✅ 成本优化 - 免费
- ✅ 多语言支持 - 免费
- ✅ 全球化合规 - 免费

**所有功能，永久免费！**

---

## 📊 当前定价配置

### clawhub.json 中的配置

```json
{
  "pricing": {
    "type": "freemium",
    "free_tier": {
      "requests_per_month": 1000,
      "features": [
        "基础路由",
        "Token 追踪",
        "环境检测",
        "配置向导"
      ]
    },
    "premium_tier": {
      "price": 29,
      "currency": "CNY",
      "billing_cycle": "monthly",
      "features": [
        "无限请求",
        "用户偏好学习",
        "预算管理",
        "时段优化",
        "多模型支持",
        "详细报告",
        "优先支持"
      ]
    },
    "enterprise_tier": {
      "price": 199,
      "currency": "CNY",
      "billing_cycle": "monthly",
      "features": [
        "所有付费功能",
        "多用户管理",
        "自定义模型池",
        "API 访问",
        "专属支持",
        "SLA 保障"
      ]
    }
  }
}
```

---

## 🎯 功能区分详情

### 免费版 (Free Tier)

**价格：** ¥0 / 永久免费

**目标用户：**
- 个人用户试用
- 低频使用者
- 学生/学习者

**功能清单：**

| 功能 | 限制 | 说明 |
|------|------|------|
| **基础路由** | ✅ 可用 | 5 维度自评 + 模型选择 |
| **Token 追踪** | ✅ 可用 | 显示 Token 用量和成本 |
| **环境检测** | ✅ 可用 | 自动检测可用模型 |
| **配置向导** | ✅ 可用 | 首次配置引导 |
| **请求次数** | 1000 次/月 | 约 33 次/天 |
| **云服务商** | 全部支持 | 6 大云服务商 |
| **模型支持** | 全部支持 | 46+ 模型 |
| **语言支持** | EN/ZH | 双语支持 |
| **合规支持** | 全部 | GDPR/CCPA/PIPL |

**限制：**
- ❌ 无用户偏好学习
- ❌ 无预算管理
- ❌ 无时段优化
- ❌ 无详细报告
- ❌ 无优先支持

**适用场景：**
```
- 每天 1-2 次 AI 使用
- 个人学习和试用
- 评估产品是否适合
```

---

### 付费版 (Premium Tier)

**价格：** ¥29/月 或 ¥299/年（省 15%）

**目标用户：**
- 高频个人用户
- 自由职业者
- 小团队

**功能清单：**

| 功能 | 状态 | 说明 |
|------|------|------|
| **所有免费版功能** | ✅ | 包含免费版所有功能 |
| **无限请求** | ✅ | 无请求次数限制 |
| **用户偏好学习** | ✅ | 学习用户习惯，自动调整 |
| **预算管理** | ✅ | 设置预算、告警、追踪 |
| **时段优化** | ✅ | 根据时段自动调整策略 |
| **多模型支持** | ✅ | 同时使用多个模型 |
| **详细报告** | ✅ | 用量、成本、性能报告 |
| **优先支持** | ✅ | 24 小时内响应 |
| **请求次数** | 无限 | 无限制 |
| **历史数据** | 90 天 | 查看 90 天历史数据 |

**额外功能：**
- ✅ 自定义阈值配置
- ✅ 导出用量报告
- ✅ 多设备同步
- ✅ 提前体验新功能

**适用场景：**
```
- 每天多次 AI 使用
- 需要成本控制
- 需要详细报告
- 需要优先支持
```

**投资回报：**
```
传统方案：¥150-600/月（AI 成本）
Router 付费版：¥29/月
节省 AI 成本：60% = ¥90-360/月
实际节省：¥61-331/月
```

---

### 企业版 (Enterprise Tier)

**价格：** ¥199/月 或 ¥1999/年（省 17%）

**目标用户：**
- 企业团队
- AI 工作室
- 多项目组织

**功能清单：**

| 功能 | 状态 | 说明 |
|------|------|------|
| **所有付费版功能** | ✅ | 包含付费版所有功能 |
| **多用户管理** | ✅ | 团队账号管理 |
| **自定义模型池** | ✅ | 配置团队可用模型 |
| **API 访问** | ✅ | RESTful API |
| **专属支持** | ✅ | 专属客户经理 |
| **SLA 保障** | ✅ | 99.9% 可用性保障 |
| **用户数量** | 无限 | 无用户数限制 |
| **历史数据** | 无限 | 查看完整历史 |
| **数据导出** | ✅ | 导出所有数据 |
| **定制开发** | ✅ | 按需定制功能 |

**额外功能：**
- ✅ 项目独立预算
- ✅ 团队用量统计
- ✅ 权限管理
- ✅ SSO 单点登录（可选）
- ✅ 私有化部署（可选）
- ✅ 定制培训
- ✅ 季度业务回顾

**适用场景：**
```
- 团队多人使用
- 需要统一管理
- 需要 API 集成
- 需要 SLA 保障
```

**投资回报：**
```
传统方案：¥600-2000/月（AI 成本 + 管理）
Router 企业版：¥199/月
节省成本：60% = ¥360-1200/月
实际节省：¥161-1001/月
```

---

## 📊 功能对比表

| 功能 | 免费版 | 付费版 | 企业版 |
|------|--------|--------|--------|
| **价格** | ¥0 | ¥29/月 | ¥199/月 |
| **请求次数** | 1000/月 | 无限 | 无限 |
| **基础路由** | ✅ | ✅ | ✅ |
| **Token 追踪** | ✅ | ✅ | ✅ |
| **环境检测** | ✅ | ✅ | ✅ |
| **用户偏好学习** | ❌ | ✅ | ✅ |
| **预算管理** | ❌ | ✅ | ✅ |
| **时段优化** | ❌ | ✅ | ✅ |
| **详细报告** | ❌ | ✅ | ✅ |
| **优先支持** | ❌ | ✅ (24h) | ✅ (专属) |
| **多用户管理** | ❌ | ❌ | ✅ |
| **自定义模型池** | ❌ | ❌ | ✅ |
| **API 访问** | ❌ | ❌ | ✅ |
| **SLA 保障** | ❌ | ❌ | ✅ |
| **历史数据** | 7 天 | 90 天 | 无限 |
| **用户数量** | 1 | 1 | 无限 |
| **数据导出** | ❌ | ✅ | ✅ |
| **定制开发** | ❌ | ❌ | ✅ |

---

## 🎯 ClawHub 定价调研

### 需要调研的内容

**1. ClawHub 上的 Skill 定价**

访问：https://clawhub.com/skills

**查看：**
- 同类 Automation 技能的价格
- AI Tools 分类的定价范围
- Freemium 模式的采用情况
- 付费版的转化率

**2. 竞品定价**

| 竞品 | 免费版 | 付费版 | 企业版 |
|------|--------|--------|--------|
| Skill A | ? | ? | ? |
| Skill B | ? | ? | ? |
| Skill C | ? | ? | ? |

**3. ClawHub 平台政策**

- 平台抽成比例
- 最低定价限制
- 免费版的限制
- 付费版的结算周期

---

## 💡 定价调整建议

### 基于 ClawHub 调研后调整

**如果 ClawHub 上同类技能定价较低：**

```
免费版：保持 1000 次/月（吸引用户）
付费版：调整为 ¥19/月（降低门槛）
企业版：调整为 ¥99/月（更具竞争力）
```

**如果 ClawHub 上同类技能定价较高：**

```
免费版：保持 1000 次/月（保持竞争力）
付费版：保持 ¥29/月（合理定价）
企业版：保持 ¥199/月（高端定位）
```

**如果 ClawHub 主要是一次性付费：**

```
考虑添加：
- 终身版：¥299（一次付费，永久使用）
- 年付优惠：¥299/年（省 15%）
```

---

## 📋 实施步骤

### 步骤 1: 调研 ClawHub 定价（30 分钟）

```
1. 访问 https://clawhub.com/skills
2. 查看 Automation 分类
3. 记录前 10 个技能的定价
4. 分析定价模式
```

### 步骤 2: 调整定价配置（15 分钟）

```bash
# 编辑 clawhub.json
nano clawhub.json

# 调整 pricing 部分
# 保存并验证
clawhub validate
```

### 步骤 3: 更新文档（15 分钟）

```bash
# 更新 SUBMISSION_DESCRIPTION.md
# 更新 PRODUCT_INTRODUCTION.md
# 更新定价对比表
```

### 步骤 4: 验证配置（5 分钟）

```bash
# 验证 JSON 格式
cat clawhub.json | python3 -m json.tool

# 确认价格正确
grep -A 5 "pricing" clawhub.json
```

---

## ✅ 当前状态

| 项目 | 状态 | 说明 |
|------|------|------|
| **免费版功能** | ✅ 已定义 | 1000 次/月 + 基础功能 |
| **付费版功能** | ✅ 已定义 | 无限 + 高级功能 |
| **企业版功能** | ✅ 已定义 | 团队 + API+SLA |
| **价格配置** | ✅ 已配置 | clawhub.json 中 |
| **ClawHub 调研** | ⏸ 待进行 | 需查看实际定价 |
| **价格调整** | ⏸ 待进行 | 根据调研结果 |

---

## 🎯 下一步行动

### 立即行动（现在）

1. **访问 ClawHub 调研定价**
   ```
   https://clawhub.com/skills
   ```

2. **记录竞品定价**
   - 免费版限制
   - 付费版价格
   - 企业版价格

3. **调整我们的定价**
   - 编辑 clawhub.json
   - 更新文档

### 完成后

- 重新验证配置
- 更新提交文档
- 提交到 ClawHub

---

**需要我帮你调研 ClawHub 上的定价吗？** 🦞
