# 任务 7：让 AI 做一张 PPT

## 目标
让 AI 生成一个真实可打开的 PPTX 文件。

## 为什么重要
PPT 是职场最常用的文件格式之一。AI 可以帮你从零构建演示文稿的结构和内容，省去排版的痛苦。

## 动手步骤

### 第一步：告诉 AI 主题和需求

> "帮我做一个 5 页的 PPT，主题是'2026年Q1工作总结'"

> "帮我做一个产品介绍 PPT，产品叫 XX，主要功能是：……"

> "帮我把这篇文章做成 PPT：[粘贴文章内容]"

### 第二步：AI 会做什么

1. 规划 PPT 结构（封面、目录、内容页、总结）
2. 为每页生成内容要点
3. 使用 `python-pptx` 库生成 `.pptx` 文件
4. 保存到 workspace 文件夹

### 示例 PPT 结构

```
第1页：封面 - 2026年Q1工作总结
第2页：目录
第3页：业务成果（数据、亮点）
第4页：遇到的挑战与解决方案
第5页：Q2 展望与计划
```

### 注意
- 生成的 PPT 是标准 .pptx 格式，可用 PowerPoint / Keynote / WPS 打开
- 样式偏简洁，适合进一步在 PPT 软件中美化
- 如需特定模板风格，可提前告知

### 延伸玩法
- "帮我在第 3 页加一个数据图表"
- "帮我把 PPT 内容翻译成英文版"
- "帮我根据这份 PPT 写一个演讲稿"
- "帮我把这个 Excel 数据做成 PPT"

## ✅ 完成标志
workspace 中存在 `.pptx` 文件。
