---
name: openclaw-podcast
description: Transform your OpenClaw workspace into personalized AI-powered podcast briefings. Get daily audio updates on your work, priorities, and strategy in 8 compelling styles—from documentary narrator to strategic advisor. Connects directly to your agent's memory and files. Includes 3 free hours of podcast generation with your Superlore.ai API key. Schedule morning, midday, or evening briefings that keep you informed without reading screens.
metadata:
  openclaw:
    requires:
      env:
        - name: SUPERLORE_API_KEY
          description: "API key from superlore.ai — get one free at https://superlore.ai or use the setup wizard's email OTP flow"
          required: true
    permissions:
      - network: "HTTPS requests to superlore-api.onrender.com (official Superlore API hosted on Render)"
      - filesystem: "Reads workspace files (memory/*.md, JOBS.md, HEARTBEAT.md, MEMORY.md). Setup wizard optionally appends env var to ~/.zshrc or ~/.bashrc (user-confirmed)."
      - cron: "Setup wizard outputs openclaw cron commands for scheduling. Runs them only with explicit user confirmation."
---

# openclaw-podcast

**Your AI agent already knows everything about your work. Now it can brief you on it.**

Every day, your OpenClaw agent accumulates context — your accomplishments, your metrics, your blockers, your priorities. This skill turns all of that into a professional podcast briefing via [Superlore.ai](https://superlore.ai). No forms to fill out. No manual summaries. Just press play.

**3 free hours included with your API key. Setup takes 2 minutes.**

---

## 🎧 Hear It For Yourself — 8 Sample Episodes

These are real episodes generated by this skill for fictional personas. Each one demonstrates a different briefing style. Listen and imagine: *what would this sound like if the AI knew YOUR workspace?*

---

### 🎙️ The Briefing
**Sarah Chen** — VP Engineering, TaskFlow (B2B SaaS, Series B)

> *"The latency drop from 340 milliseconds to 47 milliseconds isn't just a performance win — it's a signal that the architecture is finally doing what it was designed to do..."*

Sarah's agent reads her sprint board, PR merge history, incident logs, and engineering metrics every evening and delivers a polished documentary-style briefing — like having a personal analyst who's been embedded with her team for months.

🎧 **[Listen: The Briefing — Sarah Chen](https://superlore.ai/episode/cmlyu95qm0006mvy4gue30cj6)**

---

### 📈 Opportunities & Tactics
**Blake Rivera** — Founder, Lumière Skin (DTC Skincare, $312K/month)

> *"The subscription conversion gap is hiding $100,000 in monthly recurring revenue inside your existing customer base. And there's a spa chain inquiry sitting unanswered for 8 days..."*

Blake's agent spotted a 12% vs 18-25% industry benchmark gap in subscription conversions, calculated the revenue sitting on the table, and flagged a missed wholesale opportunity — all from reading his metrics files.

🎧 **[Listen: Opportunities & Tactics — Blake Rivera](https://superlore.ai/episode/cmlyu9al90008mvy46oxs4fvm)**

---

### 🚀 10X Thinking
**Marcus Webb** — Solo Developer, Nexus AI Framework (2,847 GitHub stars)

> *"LangChain has 80,000 stars. You have 2,847. But that might be the wrong comparison entirely. What if Nexus isn't a framework — what if it's the standard?"*

Marcus's agent reads his GitHub activity, Discord metrics, and technical notes — then challenges his assumptions about what he's actually building and who he should be competing with.

🎧 **[Listen: 10X Thinking — Marcus Webb](https://superlore.ai/episode/cmlyu9f78000amvy4i27vek90)**

---

### 🧭 The Advisor
**Priya Nair** — First-Time Founder, SkillBridge (EdTech, Pre-Seed)

> *"I notice you spent 40 hours on product this month and 8 hours on fundraising. With 7 months of runway and a Precursor pitch in 8 days, that's a pattern worth naming..."*

Priya's agent reviews her time allocation, pipeline status, and discovery call notes — then delivers the honest mentor feedback she might not be getting anywhere else.

🎧 **[Listen: The Advisor — Priya Nair](https://superlore.ai/episode/cmlyu9jic000cmvy4dzqi4fmc)**

---

### 🎯 Focus & Priorities
**Alex Kim** — Engineering Manager, FAANG-Scale ($2.4B ad revenue org)

> *"4.5 hours in meetings, 2.5 hours in Slack, 1.5 hours of actual deep work. That's not engineering leadership — that's reactive management. And two engineers are quietly making noise about leaving..."*

Alex's agent analyzes his calendar log, Slack volume, and org context — then cuts straight to what's actually important versus what just feels urgent.

🎧 **[Listen: Focus & Priorities — Alex Kim](https://superlore.ai/episode/cmlyu9o3v000emvy4qi9rgzli)**

---

### 📊 Growth & Scale
**Jordan Park** — Growth Lead, Meridian Finance (YC W23, 84K users)

> *"The cohort data is unambiguous: users who connect a second bank account within 48 hours have 3.2x better 90-day retention. That single insight is worth rebuilding your onboarding around..."*

Jordan's agent processed 30-day cohort analysis results, calculated the AARRR funnel bottlenecks, and identified the one activation metric that changes everything.

🎧 **[Listen: Growth & Scale — Jordan Park](https://superlore.ai/episode/cmlyu9scx000gmvy45wozwrq7)**

---

### 📅 Week in Review
**Elena Vasquez** — CTO, ClearPath Health (Series A, 31 hospital clients)

> *"Monday was the compliance unlock. Tuesday was the technical launch. Wednesday opened a $180K door. Thursday fixed what broke. Friday built the map. The story of this week is a team that ships fast and fixes faster..."*

Elena's agent synthesizes the week's wins, deployments, customer conversations, and metrics into a narrative arc — giving her the zoom-out perspective that's hard to find when you're in the middle of it.

🎧 **[Listen: Week in Review — Elena Vasquez](https://superlore.ai/episode/cmlyu9wx7000imvy4unlzu3gn)**

---

### 🔮 The Futurist
**David Okonkwo** — Founder, Terravolt Energy (Climate-Tech, $4.2M Seed)

> *"The 43% curtailment reduction isn't just a pilot result — it's proof that AI can unlock 85 gigawatts of stranded renewable capacity sitting idle on the US grid. That's the size of the prize you're building toward..."*

David's agent connects today's Duke Energy pilot results, provisional patent filing, and DOE grant submission to the 3/6/12-month trajectory — keeping the mission visible when the details get overwhelming.

🎧 **[Listen: The Futurist — David Okonkwo](https://superlore.ai/episode/cmlyua1c8000kmvy47l1f9b5a)**

---

## ✨ What Makes This Different

Most AI summaries are generic. They know what you typed in a chat box. This skill knows what you actually *did* — because it reads the same workspace files your agent uses every day.

**The difference in practice:**

| Generic AI Summary | OpenClaw Podcast |
|---|---|
| "You worked on some engineering tasks today" | "The latency drop from 340ms to 47ms unblocks the enterprise tier rollout you've been waiting on for two months" |
| "You should focus on your priorities" | "You spent 40 hours on product this month and 8 on fundraising — with 7 months of runway, that ratio needs to flip" |
| "Consider growth opportunities" | "Your subscription conversion at 12% vs. the 18-25% industry benchmark is $100K/month hiding in your existing customer base" |

The AI knows your project names. Your metrics. Your blockers. Your job board. The context that takes 10 minutes to explain to a consultant — your agent already has it.

**What Superlore adds on top:**
- 📝 **Notes** — Save insights from episodes to your library
- 🎵 **Episode library** — Listen back to any briefing, any time
- 🗣️ **Premium TTS voices** — Kokoro-powered, natural-sounding audio
- 🎨 **AI cover art** — Every episode gets a unique generated image
- ⚡ **Fast generation** — Episodes ready in ~2 minutes

---

## Setup

The fastest path to your first briefing is the setup wizard:

```bash
node scripts/setup-crons.js
```

The wizard handles everything in 7 steps — including account creation with just your email:

1. **Connect Your Account** — Sign up or log in via email (6-digit code), or paste an existing API key
2. **Choose your styles** — Pick from 8 built-in briefing styles
3. **Custom style** — Optionally design your own briefing focus, tone, and voice
4. **Music bed** — Choose ambient background music or voice-only
5. **Schedule** — Set a time for each style (morning/midday/evening/weekly/custom cron)
6. **Preview episode** — Generates a real episode so you can hear the quality immediately
7. **Activate** — Outputs `openclaw cron add` commands; optionally runs them for you

**Already have an API key?** Manual setup:

```bash
export SUPERLORE_API_KEY=your-api-key-here
node scripts/generate-episode.js  # Your first episode in 2 minutes
```

---

## All 8 Briefing Styles

| Style | Best For | Voice | Default Time |
|-------|----------|-------|--------------|
| **The Briefing** | Daily overview — accomplishments, metrics, what's next | Luna | Morning or Evening |
| **Opportunities & Tactics** | Spotting growth moves hiding in your daily work | Michael | Evening |
| **10X Thinking** | Breaking through incremental thinking | Michael | Evening |
| **The Advisor** | Honest mentor feedback on patterns and decisions | Luna | Evening |
| **Focus & Priorities** | Cutting busywork, finding the ONE thing | Heart | Morning |
| **Growth & Scale** | Revenue, users, funnels — business metrics lens | Michael | Morning |
| **Week in Review** | Weekly synthesis, trends, goals for next week | Luna | Friday Evening |
| **The Futurist** | Connecting today's work to 3/6/12-month vision | Heart | Evening |

---

## Voices

| Voice | Character | Styles |
|-------|-----------|--------|
| **Luna** (`af_heart-80_af_sarah-15_af_nicole-5`) | Warm, balanced, professional | The Briefing, The Advisor, Week in Review |
| **Michael** (`am_michael-60_am_eric-40`) | Rich, authoritative, strategic | Opportunities & Tactics, 10X Thinking, Growth & Scale |
| **Heart** (`af_heart`) | Intimate, direct, personal | Focus & Priorities, The Futurist |

---

## Custom Styles

Create your own briefing style by dropping a JSON file in `podcast-styles/`:

```json
{
  "name": "Investor Lens",
  "description": "Frame every decision through how it affects the fundraising narrative",
  "voice": "am_michael-60_am_eric-40",
  "speed": 0.92,
  "targetMinutes": 6,
  "instructions": "Your detailed style instructions..."
}
```

Two examples are included: **Founder Debrief** (casual co-founder energy) and **Competitor Watch** (competitive intelligence lens).

---

## Scheduling

Set up automated daily briefings:

```bash
node scripts/setup-crons.js
# → Outputs openclaw cron add commands
# → Optionally runs them for you
```

Example cron for a morning briefing + evening advisor:
```
/cron create "0 8 * * 1-5" agent:run node scripts/generate-episode.js --style "The Briefing" --time-of-day morning
/cron create "0 19 * * 1-5" agent:run node scripts/generate-episode.js --style "The Advisor" --time-of-day evening
```

---

## Privacy

Your workspace files are **never sent to Superlore**. The script:

1. Reads your memory files locally
2. Extracts a structured work summary (~3,000 chars of accomplishments, metrics, blockers)
3. Strips all secrets — API keys, tokens, emails, IPs, database URLs, file paths
4. Sends only the sanitized briefing text to Superlore's API

All episodes are `private` by default. Run `--dry-run` to see exactly what would be sent before creating anything.

---

## Quick Commands

```bash
# Setup wizard (recommended)
node scripts/setup-crons.js

# Generate an episode
node scripts/generate-episode.js
node scripts/generate-episode.js --style "The Advisor"
node scripts/generate-episode.js --style "10X Thinking" --time-of-day morning

# Weekly review (best on Fridays)
node scripts/generate-episode.js --style "Week in Review"

# Preview without creating
node scripts/generate-episode.js --dry-run

# List all available styles
node scripts/generate-episode.js --list-styles

# Deliver episode link to a channel when ready
node scripts/generate-episode.js --channel telegram
```

---

## Requirements

- OpenClaw workspace with memory files (`memory/YYYY-MM-DD.md`)
- Superlore.ai API key — get one free at [superlore.ai](https://superlore.ai)
- **3 free hours of podcast generation included**

---

**Made with ❤️ for the OpenClaw community. Powered by [Superlore.ai](https://superlore.ai).**
