#!/usr/bin/env bash
set -euo pipefail

# Publish this skill to ClawHub.
#
# Prereq (once):
#   npx -y clawhub@latest login
#
# Then run:
#   ./scripts/publish_clawhub.sh 0.1.0 "Initial release: Obsidian task board (Kanban + Dataview) setup + workflows."

VERSION=${1:?"Usage: $0 <version> [changelog]"}
CHANGELOG=${2:-"Update"}

REPO_DIR=$(cd "$(dirname "${BASH_SOURCE[0]}")/.." && pwd)

SITE_URL=${CLAWHUB_SITE:-"https://clawhub.ai"}
REGISTRY_URL=${CLAWHUB_REGISTRY:-"https://auth.clawdhub.com"}

TAGS=${CLAWHUB_TAGS:-"latest,obsidian,kanban,dataview,tasks,productivity"}

npx -y clawhub@latest \
  --site "$SITE_URL" \
  --registry "$REGISTRY_URL" \
  publish "$REPO_DIR" \
    --slug openclaw-obsidian-tasks \
    --name "Obsidian Tasks" \
    --version "$VERSION" \
    --tags "$TAGS" \
    --changelog "$CHANGELOG"
