# openclaw-obsidian-tasks

An [OpenClaw](https://openclaw.ai) skill for managing tasks in [Obsidian](https://obsidian.md) vaults using Kanban boards and Dataview dashboards.

## What it does

- Sets up a Kanban board your AI agent can manage
- Creates Dataview dashboards for task overview
- Structured task notes with frontmatter (status, priority, category, dates)
- Agent instructions for creating, moving, and completing tasks
- Supports `[[wikilinks]]` to connect tasks to documents and research

## Requirements

- An Obsidian vault on disk
- [Kanban](https://github.com/mgmeyers/obsidian-kanban) community plugin (for board view)
- [Dataview](https://github.com/blacksmithgu/obsidian-dataview) community plugin (for dashboards)

## Install

### Via ClawHub

```bash
npx clawhub@latest install openclaw-obsidian-tasks
```

## Publish (maintainers)

Login once:

```bash
npx -y clawhub@latest login
```

Publish a new version:

```bash
./scripts/publish_clawhub.sh 0.1.0 "Initial release: Obsidian task board (Kanban + Dataview) setup + workflows."
```

### Manual

Copy the `SKILL.md` and `scripts/` folder to `~/.openclaw/skills/obsidian-tasks/` or your workspace `skills/` folder.

## Setup

Ask your agent to set up a task board, or run the setup script directly:

```bash
python3 scripts/setup.py /path/to/vault --folder Tasks
```

Options:
- `--folder` - subfolder name (default: `Tasks`)
- `--columns` - comma-separated columns (default: `Backlog,Todo,In Progress,Review,Done`)

Then install the Kanban and Dataview plugins in Obsidian (Settings > Community Plugins > Browse).

## Task format

Each task is a markdown file with YAML frontmatter:

```markdown
---
status: todo
priority: P1
category: revenue
created: 2026-02-03
due: 2026-02-07
---

# Apply to VNG Realisatie

Details, notes, and references here.

## References
- [[research-doc|Research Report]]
```

The Kanban board (`Board.md`) uses priority emoji for visual scanning:
- 🔴 P1 (urgent)
- 🟡 P2 (normal)
- 🟢 P3 (backlog)

## License

MIT
