---
name: openclaw-nextcloud
description: Manage Notes, Tasks, Calendar, Files, and Contacts in your Nextcloud instance via CalDAV, WebDAV, and Notes API. Use for creating notes, managing todos and calendar events, uploading/downloading files, and managing contacts.
license: MIT
compatibility: Requires Node.js 20+. Needs network access to Nextcloud instance.
allowed-tools: Bash Read
---

# OpenClaw Nextcloud Skill

This skill provides integration with a Nextcloud instance. It supports access to Notes, Tasks (Todos), Calendars, Files, and Contacts.

## Configuration

The skill requires the following environment variables:

- `NEXTCLOUD_URL`: The base URL of your Nextcloud instance (e.g., `https://cloud.example.com`).
- `NEXTCLOUD_USER`: Your Nextcloud username.
- `NEXTCLOUD_TOKEN`: An App Password (recommended) or your login password.

## Features

### 1. Notes (Read/Write)
- List, get, create, update, and delete notes.
- API: `index.php/apps/notes/api/v1/notes`

### 2. Tasks / Todos (Read/Write)
- List, create, update, delete, and complete tasks.
- API: CalDAV (VTODO).

### 3. Calendar (Read/Write)
- List, create, update, and delete events.
- API: CalDAV (VEVENT).

### 4. Files (Read/Write)
- List, search, upload, download, and delete files.
- API: WebDAV.

### 5. Contacts (Read/Write)
- List, get, create, update, delete, and search contacts.
- API: CardDAV.

## Usage

Run the skill via the bundled script.

```bash
node scripts/nextcloud.js <command> <subcommand> [options]
```

## Commands

### Notes
- `notes list`
- `notes get --id <id>`
- `notes create --title <t> --content <c> [--category <cat>]`
- `notes edit --id <id> [--title <t>] [--content <c>] [--category <cat>]`
- `notes delete --id <id>`

### Tasks
- `tasks list [--calendar <c>]`
- `tasks create --title <t> [--calendar <c>] [--due <d>] [--priority <p>] [--description <d>]`
- `tasks edit --uid <u> [--calendar <c>] [--title <t>] [--due <d>] [--priority <p>] [--description <d>]`
- `tasks delete --uid <u> [--calendar <c>]`
- `tasks complete --uid <u> [--calendar <c>]`

### Calendar Events
- `calendar list [--from <iso>] [--to <iso>]` (Defaults to next 7 days)
- `calendar create --summary <s> --start <iso> --end <iso> [--calendar <c>] [--description <d>]`
- `calendar edit --uid <u> [--calendar <c>] [--summary <s>] [--start <iso>] [--end <iso>] [--description <d>]`
- `calendar delete --uid <u> [--calendar <c>]`

### Calendars (list available calendars)
- `calendars list [--type <tasks|events>]`

### Files
- `files list [--path <path>]`
- `files search --query <q>`
- `files get --path <path>` (download file content)
- `files upload --path <path> --content <content>`
- `files delete --path <path>`

### Contacts
- `contacts list [--addressbook <ab>]`
- `contacts get --uid <u> [--addressbook <ab>]`
- `contacts search --query <q> [--addressbook <ab>]`
- `contacts create --name <n> [--addressbook <ab>] [--email <e>] [--phone <p>] [--organization <o>] [--title <t>] [--note <n>]`
- `contacts edit --uid <u> [--addressbook <ab>] [--name <n>] [--email <e>] [--phone <p>] [--organization <o>] [--title <t>] [--note <n>]`
- `contacts delete --uid <u> [--addressbook <ab>]`

### Address Books (list available address books)
- `addressbooks list`

## Output Format

All outputs are JSON formatted.

### Tasks List Output
```json
{
  "status": "success",
  "data": [
    {
      "uid": "unique-task-id",
      "calendar": "Calendar Name",
      "summary": "Task title",
      "status": "NEEDS-ACTION",
      "due": "20260201T153000Z",
      "priority": 0
    }
  ]
}
```
- `due`: CalDAV format date (YYYYMMDDTHHmmssZ) or null
- `priority`: 0-9 (0 = undefined, 1 = highest, 9 = lowest) or null

### Calendar Events List Output
```json
{
  "status": "success",
  "data": [
    {
      "uid": "unique-event-id",
      "calendar": "Calendar Name",
      "summary": "Event title",
      "start": "20260205T100000Z",
      "end": "20260205T110000Z"
    }
  ]
}
```

### Contacts List Output
```json
{
  "status": "success",
  "data": [
    {
      "uid": "unique-contact-id",
      "addressBook": "Address Book Name",
      "fullName": "John Doe",
      "name": "Doe;John;;;",
      "phones": ["+1234567890"],
      "emails": ["john@example.com"],
      "organization": "ACME Inc",
      "title": "Developer",
      "note": "Met at conference"
    }
  ]
}
```
- `phones`: Array of phone numbers or null
- `emails`: Array of email addresses or null
- `name`: Structured name in vCard format (Last;First;Middle;Prefix;Suffix)

### General Format
```json
{
  "status": "success",
  "data": [ ... ]
}
```

or

```json
{
  "status": "error",
  "message": "Error description"
}
```

## Agent Behavior: Default Calendar Selection

When creating tasks or calendar events, if the user does not specify a calendar:

1. **First time (no default set):**
   - Run `calendars list --type tasks` (for tasks) or `calendars list --type events` (for events)
   - Ask the user which calendar to use from the list
   - Ask if they want to set it as the default for future operations
   - Remember their choice in memory

2. **If user sets a default:**
   - Remember `default_task_calendar` and/or `default_event_calendar`
   - Use automatically for subsequent operations without asking

3. **If user declines to set a default:**
   - Ask again next time they create a task/event without specifying a calendar

4. **User can always override:**
   - Explicitly specifying `--calendar` always takes precedence over the default

### Memory Keys
- `default_task_calendar`: Default calendar name for tasks (VTODO)
- `default_event_calendar`: Default calendar name for events (VEVENT)

## Agent Behavior: Default Address Book Selection

When creating contacts, if the user does not specify an address book:

1. **First time (no default set):**
   - Run `addressbooks list`
   - Ask the user which address book to use from the list
   - Ask if they want to set it as the default for future operations
   - Remember their choice in memory

2. **If user sets a default:**
   - Remember `default_addressbook`
   - Use automatically for subsequent operations without asking

3. **If user declines to set a default:**
   - Ask again next time they create a contact without specifying an address book

4. **User can always override:**
   - Explicitly specifying `--addressbook` always takes precedence over the default

### Memory Keys
- `default_addressbook`: Default address book name for contacts

## Agent Behavior: Presenting Information

When displaying data to the user, format it in a readable way. Output may be sent to messaging platforms (Telegram, WhatsApp, etc.) where markdown does not render, so avoid markdown formatting.

### General Guidelines
- Use emojis to make output scannable and friendly
- Do NOT use markdown formatting (no **bold**, *italic*, `code`, tables, or lists with - or *)
- Use plain text with line breaks for structure
- Convert technical formats (like CalDAV dates) to human-readable formats
- Group related items logically

### Emoji Reference
Tasks: ✅ (completed), ⬜ (pending), 🔴 (high priority), 🟡 (medium), 🟢 (low)
Calendar: 📅 (event), ⏰ (time), 📍 (location)
Notes: 📝 (note), 📁 (category)
Files: 📄 (file), 📂 (folder), 💾 (size)
Contacts: 👤 (person), 📧 (email), 📱 (phone), 🏢 (organization)
Status: ✨ (created), ✏️ (updated), 🗑️ (deleted), ❌ (error)

### Example Presentations

Tasks:
```
📋 Your Tasks

⬜ 🔴 Buy groceries — Due: Tomorrow 3:30 PM
⬜ 🟡 Review PR #42 — Due: Feb 5
✅ Send email to client
```

Calendar Events:
```
📅 Upcoming Events

🗓️ Team Standup
   ⏰ Mon, Feb 3 • 10:00 AM - 10:30 AM
   📍 Zoom

🗓️ Project Review
   ⏰ Wed, Feb 5 • 2:00 PM - 3:00 PM
```

Contacts:
```
👤 John Doe
   📧 john@example.com
   📱 +1 234 567 890
   🏢 ACME Inc — Developer
```

Files:
```
📂 Documents/
   📄 report.pdf (2.3 MB)
   📄 notes.txt (4 KB)
   📂 Archive/
```

### Date/Time Formatting
Convert CalDAV format 20260205T100000Z to readable format like Wed, Feb 5 • 10:00 AM
Show relative dates when helpful: "Tomorrow", "Next Monday", "In 3 days"
Use the user's local timezone when possible
