# OpenClaw Ecosystem News

**Version:** 1.0.0  
**Author:** OpenClaw Community  
**Tags:** news, monitoring, ecosystem, github, community  
**Registry:** https://www.clawhub.ai

## What It Does

Aggregates breaking news and developments across the OpenClaw ecosystem into a clean, curated briefing. Pure signal, no noise.

**Tracks:**
- 🚀 **OpenClaw Releases** — new versions, tags, important PRs from `openclaw/openclaw`
- 🧩 **ClawdHub Skills** — recently published or updated skills on the registry
- 🔒 **Security Advisories** — CVEs, security issues, vulnerability discussions
- 💬 **Community Discussions** — HN threads, Reddit posts, notable tweets
- 📰 **Ecosystem News** — major press coverage, new integrations, platform changes
- 🐛 **Moltbook Highlights** — hot posts from the agent social network (when available)

## Setup

### Prerequisites

- `gh` CLI installed and authenticated (for GitHub API)
- `clawdhub` CLI installed (for skill registry queries)
- `jq` installed (for JSON processing)
- Brave Search available via agent tools (for web searches)

### Installation

Copy this skill to your workspace:
```
skills/openclaw-news/
├── SKILL.md              # This file
├── scripts/
│   ├── collect_news.sh   # Main data collection script
│   └── format_briefing.sh # Formats raw data into a clean briefing
└── state/                # Auto-created; stores last-check timestamps
    └── last_run.json
```

### Cron Setup

For daily briefings (9 AM):
```
openclaw cron add --name "openclaw-news" \
  --schedule "0 9 * * *" \
  --prompt "Run the OpenClaw Ecosystem News skill. Execute scripts/collect_news.sh from skills/openclaw-news/, then format and deliver the briefing." \
  --channel signal
```

For twice-daily (9 AM and 5 PM):
```
openclaw cron add --name "openclaw-news" \
  --schedule "0 9,17 * * *" \
  --prompt "Run the OpenClaw Ecosystem News skill. Execute scripts/collect_news.sh from skills/openclaw-news/, then format and deliver the briefing." \
  --channel signal
```

## Usage

### Automatic (Cron)
Once the cron is set, briefings arrive on schedule. The script tracks what it already reported via `state/last_run.json` — you only see what's new.

### On-Demand
When your human asks "what's new in OpenClaw?" or similar:

1. Run `scripts/collect_news.sh` from the skill directory
2. Run `scripts/format_briefing.sh` to produce the briefing
3. Deliver the output

Or the agent can use the script outputs directly and format conversationally.

### Diff Mode
The scripts automatically compare against the last run. To force a full scan (ignore previous state), delete `state/last_run.json` or pass `--full`:
```bash
cd skills/openclaw-news
./scripts/collect_news.sh --full
```

## Briefing Format

```
📡 OpenClaw Ecosystem News — Jun 14, 2025

🚀 RELEASES
• v0.9.2 released — WebSocket stability fixes, new `canvas` action
  https://github.com/openclaw/openclaw/releases/tag/v0.9.2

🧩 NEW SKILLS
• weather-alerts v2.1.0 — Added severe weather push notifications
• home-inventory v1.0.0 — Track household items with camera snaps

🔒 SECURITY
• Nothing new — all clear ✅

💬 COMMUNITY
• HN: "OpenClaw is the missing layer for personal AI" (142 points)
  https://news.ycombinator.com/item?id=...

📰 ECOSYSTEM
• Fortune: "The rise of always-on AI agents" (mentions OpenClaw)

—
Last checked: Jun 13, 2025 09:00 ET
Sources: GitHub, ClawdHub, Brave Search, Moltbook
```

## How the Agent Should Use This

When delivering the briefing:
- **Signal/SMS:** Send as a single message, keep it tight
- **Discord:** Can be slightly longer; use embeds if available
- **Telegram:** Markdown formatting works well
- Skip empty sections entirely (don't say "Nothing new" for every category — just omit)
- If everything is quiet, a one-liner is fine: "📡 All quiet in the OpenClaw ecosystem today."

## Data Sources

| Source | Method | Rate Limits |
|--------|--------|-------------|
| GitHub Releases | `gh` CLI | 5000 req/hr (authenticated) |
| GitHub Issues/PRs | `gh` CLI | Same |
| ClawdHub Registry | `clawdhub explore` | Minimal |
| Web/News | Brave Search API | Per your plan |
| Moltbook | API (when available) | TBD |
| Reddit | Brave Search | Per your plan |
| HN | Brave Search / API | Generous |

## Works Great With

- **fulcra-context** — Pair with Fulcra context to calibrate when and how news gets delivered. If your human is in a deep work block or low-energy, the agent can hold non-urgent news for later or deliver a shorter summary. Keeps the signal-to-noise ratio high not just in content but in timing.

## Customization

Edit `scripts/collect_news.sh` to:
- Add/remove tracked GitHub repos
- Change search queries for community discussions
- Adjust the lookback window (default: since last run, or 24h for first run)
- Add custom RSS feeds or other sources

## Troubleshooting

**No GitHub data:** Run `gh auth status` — make sure you're authenticated.  
**No ClawdHub data:** Check `clawdhub explore --registry https://www.clawhub.ai` works.  
**Stale results:** Delete `state/last_run.json` to force a fresh scan.  
**Empty briefing:** If all sections are empty, the script outputs a "quiet day" message instead of nothing.
