const { spawn } = require('child_process');
const path = require('path');
const fs = require('fs');

const PORT = process.env.OPENCLAW_SKILL_PORT || 34567;

function startServer() {
  const serverPath = path.join(__dirname, 'server.js');
  
  const server = spawn('node', [serverPath], {
    env: { ...process.env, OPENCLAW_SKILL_PORT: PORT },
    stdio: 'inherit'
  });
  
  server.on('error', (err) => {
    console.error('启动服务器失败:', err);
  });
  
  server.on('exit', (code) => {
    if (code !== 0) {
      console.log(`服务器退出，代码: ${code}`);
    }
  });
  
  return server;
}

module.exports = {
  name: 'openclaw-newbie-faq',
  version: '1.0.0',
  displayName: 'openclaw新手帮帮忙',
  description: '为刚接触 OpenCLAW 的新手提供完整指南',
  
  async activate() {
    console.log('正在启动 OpenCLAW 新手帮帮忙...');
    this.server = startServer();
    
    return {
      success: true,
      message: `OpenCLAW 新手帮帮忙已启动，访问地址: http://localhost:${PORT}`
    };
  },
  
  async deactivate() {
    if (this.server) {
      this.server.kill();
      console.log('OpenCLAW 新手帮帮忙已停止');
    }
    
    return {
      success: true,
      message: 'OpenCLAW 新手帮帮忙已停止'
    };
  },
  
  getWebUrl() {
    return `http://localhost:${PORT}`;
  }
};

if (require.main === module) {
  startServer();
}
