# SKILL.md - OpenClaw Migration

## Purpose
When the workspace is in the middle of renaming the Clawd project to OpenClaw, this skill lives in the repo so everyone—human or helper—can follow the same migration playbook. It outlines what gets moved, renamed, and tested as we align the codebase, docs, and tooling with the new brand.

## When to use
- The human asks for a migration status, plan, or checklist (e.g., “How do we move Clawd to OpenClaw?”).
- You are about to rename directories, update config files, or explain where the old artifacts live.
- A new contributor needs consistent steps so renaming doesn’t break builds or automation.

## Migration playbook
1. **Inventory current layout**: `clawdbot/` is the existing application root, containing `src/`, `apps/`, `docs/`, `skills/`, `package.json`, tests, and tooling. The repo root also hosts the agent metadata (`AGENTS.md`), personality files (`SOUL.md`, `MEMORY.md`, etc.), and artifacts like `skills.json`.
2. **Create the OpenClaw root**: either rename `clawdbot/` → `openclaw/` or copy its contents into a new `openclaw/` branch. Preserve hidden files (`.github`, `.agent`, `.ox` configs, etc.) and ensure `package.json`, `pnpm-workspace.yaml`, and lockfile stay in sync.
3. **Update references**: search for “Clawd” (case-sensitive) inside docs, READMEs, skill definitions, config files, CI workflows, and rename it to “OpenClaw.”
   - Pay special attention to `README-header.png`, `docs/*.md`, `AGENTS.md`, and `SOUL.md` (the persona description may mention Clawd by name).
   - Update any CLI/`npm run` scripts that reference `clawdbot` paths.
4. **Move common metadata**: decide where `AGENTS.md`, `SOUL.md`, `MEMORY.md`, `skills.json`, `skills/` should live relative to the new app root. Keep human-facing files at the repo root if they drive onboarding (the main persona, heartbeat, identity, etc.).
5. **Verify tooling**: rerun `pnpm test`, `pnpm lint`, and any `docs` building scripts from within `openclaw/` so the new layout works with existing CI.
6. **Update documentation**: mention the migration in `README.md` (root and inside the app) so contributors know the repo now houses OpenClaw. Document how to run the app from the new directory.
7. **Clean up artifacts**: remove or archive the old `clawdbot/` directory once the new structure is stable, or keep a reference README explaining the archive for traceability.

## Validation
- `package.json` scripts (`dev`, `build`, `bootstrap`) still resolve to the right folders.
- `pnpm` workspace references and `tsconfig` paths point to `openclaw/` (if renamed).
- `skills.json` still lists the correct skill directories and versions.
- CI/CD workflows (GitHub Actions, Fly, Render) use the new name in their config.

## Communication
- Share this SKILL.md with reviewers during the migration review, so they can confirm each step.
- When sending summaries to Ivan, include a list of moved files and new `openclaw/` entrypoints.

## Triggers
- Any “migration”, “rename”, or “Clawd → OpenClaw” question from Ivan.
- When prepping a release that should ship under the OpenClaw brand.
