# Real Working Example: kr-legal-search

This is a **real, working configuration** for connecting to the kr-legal-search MCP server.

## ⚠️ Important: No API Key Required

The current kr-legal-search service **does not require an API key**. The documentation mentioning `KR_LEGAL_API_KEY` was for a hypothetical future version.

## 🚀 Working Configuration

### OpenClaw Configuration

Edit `~/.openclaw/openclaw.json`:

```json
{
  "plugins": {
    "entries": {
      "mcp-integration": {
        "enabled": true,
        "config": {
          "enabled": true,
          "servers": {
            "kr-legal": {
              "enabled": true,
              "transport": "http",
              "url": "http://localhost:3000/mcp"
            }
          }
        }
      }
    }
  }
}
```

**That's it!** No API key needed.

## 🎯 Start the kr-legal Service

Assuming you have the kr-legal MCP server running:

```bash
# Start the kr-legal server (adjust path as needed)
cd /path/to/kr-legal-server
npm start

# Should output:
# kr-legal MCP server listening on http://localhost:3000
```

## ✅ Verify It Works

### Step 1: Restart OpenClaw

```bash
openclaw gateway restart
```

### Step 2: Check Logs

```bash
openclaw logs | grep MCP

# Expected output:
# [MCP] Plugin registered
# [MCP] Starting...
# [MCP] Connecting to kr-legal at http://localhost:3000/mcp
# [MCP] Connected to kr-legal: 5 tools available
# [MCP] Started
```

### Step 3: Test in OpenClaw

**In OpenClaw chat:**
```
User: List MCP tools

AI: Let me check available MCP tools.
[Uses: mcp with action=list]

Available MCP tools:
- kr-legal:search_statute
- kr-legal:search_case_law
- kr-legal:resolve_citation
- kr-legal:get_statute_full_text
- kr-legal:analyze_law
```

### Step 4: Try a Search

**In OpenClaw chat:**
```
User: Search for Korean civil law

AI: I'll search Korean statutes for civil law.
[Uses: mcp with action=call, server=kr-legal, tool=search_statute]

Found statutes related to civil law:
1. 민법 (Civil Code) - Statute #0001
...
```

## 📊 Full Example Interaction

### User Query
```
User: Find Korean labor law about overtime pay
```

### Tool Call 1: Search statutes
```json
{
  "tool": "mcp",
  "args": {
    "action": "call",
    "server": "kr-legal",
    "tool": "search_statute",
    "args": {
      "query": "연장근로 수당",
      "category": "노동법",
      "limit": 3
    }
  }
}
```

### Response
```json
{
  "content": [
    {
      "type": "text",
      "text": "{\"results\":[{\"title\":\"근로기준법 제56조\",\"statute_id\":\"0065\",\"article\":56,...}]}"
    }
  ]
}
```

### Tool Call 2: Get full text
```json
{
  "tool": "mcp",
  "args": {
    "action": "call",
    "server": "kr-legal",
    "tool": "get_statute_full_text",
    "args": {
      "statute_id": "0065",
      "article": 56
    }
  }
}
```

## 🔧 Troubleshooting

### Issue: "Failed to connect to kr-legal"

**Check if server is running:**
```bash
curl http://localhost:3000/mcp
# Should return something, even if it's an error about missing params
```

**If not running:**
```bash
# Start the kr-legal server
cd /path/to/kr-legal-server
npm start
```

### Issue: "Tool not found: kr-legal:search_statute"

**Restart OpenClaw:**
```bash
openclaw gateway restart
```

**Check logs:**
```bash
openclaw logs | grep "Connected to kr-legal"
# Should show: [MCP] Connected to kr-legal: 5 tools available
```

### Issue: Port 3000 already in use

**Change the port in both places:**

1. **kr-legal server** (adjust to use different port, e.g., 3001)
2. **OpenClaw config:**
```json
{
  "servers": {
    "kr-legal": {
      "url": "http://localhost:3001/mcp"
    }
  }
}
```

## 📝 Minimal Test Configuration

Here's the **absolute minimum** to test:

**`~/.openclaw/openclaw.json`:**
```json
{
  "plugins": {
    "entries": {
      "mcp-integration": {
        "enabled": true,
        "config": {
          "servers": {
            "kr-legal": {
              "url": "http://localhost:3000/mcp"
            }
          }
        }
      }
    }
  }
}
```

**Start server → Restart OpenClaw → Test in chat**

## 🎉 Success Criteria

You know it's working when:

1. ✅ OpenClaw logs show "Connected to kr-legal: X tools available"
2. ✅ `List MCP tools` command shows kr-legal tools
3. ✅ Calling a tool returns results (not errors)
4. ✅ Agent can successfully use kr-legal tools in conversation

## 📋 Complete Setup Checklist

- [ ] kr-legal MCP server is installed
- [ ] kr-legal server is running on port 3000
- [ ] mcp-integration plugin is installed in OpenClaw
- [ ] Configuration added to openclaw.json (no API key needed!)
- [ ] OpenClaw gateway restarted
- [ ] Logs show successful connection
- [ ] Tools are listed correctly
- [ ] Test query works

## 🔗 Related Files

- Main documentation: [README.md](../README.md)
- Configuration guide: [CONFIGURATION.md](CONFIGURATION.md)
- More examples: [EXAMPLES.md](EXAMPLES.md)
- Troubleshooting: [TROUBLESHOOTING.md](TROUBLESHOOTING.md)

---

**Key Point:** The current kr-legal service is **ready to use without any API key**. Just make sure the server is running and configure the URL in OpenClaw!

**Last Updated:** 2026-02-01  
**Tested With:** OpenClaw 2026.1.x, kr-legal-search MCP server
