---
name: openclaw-master-skills
description: "A curated collection of 127+ best OpenClaw skills — AI tools, productivity, marketing, frontend, mobile, backend, DevOps and more. Weekly updated by MyClaw.ai (https://myclaw.ai), the AI personal assistant platform. Install individual skills via ClaWHub or clone from GitHub."
metadata: {"openclaw": {"homepage": "https://myclaw.ai", "requires": {"env": []}}}
---

# OpenClaw Master Skills

A weekly-updated, curated index of the best OpenClaw-compatible skills from across the open source ecosystem. Powered by [MyClaw.ai](https://myclaw.ai).

## What's Inside

127+ skills across 11 categories, sourced from trusted publishers:

- **AI Tools** (18) — PDF, DOCX, XLSX, PPTX, MCP builder, canvas design (Anthropic)
- **Productivity** (15) — Brainstorming, TDD, parallel agents, code review (obra)
- **Marketing** (23) — SEO, copywriting, CRO, paid ads, content strategy
- **Frontend** (29) — Next.js, Vue, Vite, React, Tailwind, AI SDK (Vercel, antfu)
- **Mobile** (13) — Expo / React Native skills
- **Backend** (9) — API design, Node.js, FastAPI, architecture patterns
- **Database** (2) — PostgreSQL, Supabase
- **Auth** (2) — better-auth
- **DevOps** (12) — Git workflows, CI/CD, GitHub Copilot
- **Web Automation** (3) — Browser-use, Firecrawl, site auditing
- **Other** (1) — React Doctor

## How to Install

```bash
clawhub install openclaw-master-skills
```

Or clone manually:
```bash
git clone https://github.com/LeoYeAI/openclaw-master-skills.git
cp -r openclaw-master-skills/skills/<skill-name> ~/.openclaw/workspace/skills/
```

## About MyClaw.ai

[MyClaw.ai](https://myclaw.ai) gives every user a fully-featured AI agent on a dedicated server. This skill collection is part of our open source initiative to help the community build better AI agents.

> 🌐 https://myclaw.ai

## Updates

Updated every Monday. Full release history: https://github.com/LeoYeAI/openclaw-master-skills

