# 🧠 OpenClaw Master Skills

<div align="center">

<a href="https://myclaw.ai">
  <img src="https://img.shields.io/badge/Powered%20by-MyClaw.ai-blue?style=for-the-badge" alt="Powered by MyClaw.ai" />
</a>
<img src="https://img.shields.io/badge/Updated-Weekly-green?style=for-the-badge" alt="Weekly Updates" />

**Languages:**
[English](README.md) · [中文](README.zh-CN.md) · [Français](README.fr.md) · [Deutsch](README.de.md) · [Русский](README.ru.md) · [日本語](README.ja.md) · [Italiano](README.it.md) · [Español](README.es.md)

</div>

---

## 🤖 Powered by [MyClaw.ai](https://myclaw.ai)

**[MyClaw.ai](https://myclaw.ai)** is an AI personal assistant platform that gives every user a fully-featured AI agent running on a dedicated server. OpenClaw Master Skills is our curated, weekly-updated collection of the best skills from across the ecosystem — hand-picked to help your AI agent do more.

> 🌐 **Try MyClaw.ai**: [https://myclaw.ai](https://myclaw.ai)

---

## 🚀 How to Install

```bash
# Install a single skill via ClaWHub
clawhub install <skill-name>

# Or clone and copy manually
git clone https://github.com/LeoYeAI/openclaw-master-skills.git
cp -r openclaw-master-skills/skills/<skill-name> ~/.openclaw/workspace/skills/
```

## 📦 Skill Index

| Skill | Description | Category | Source | Added |
|---|---|---|---|---|
| [`algorithmic-art`](skills/algorithmic-art/) | Creating algorithmic art using p5.js with seeded randomness and interactive parameter expl... | AI Tools | [GitHub](https://github.com/anthropics/skills) | 2026-03-02 |
| [`brand-guidelines`](skills/brand-guidelines/) | Applies Anthropic's official brand colors and typography to any sort of artifact that may ... | AI Tools | [GitHub](https://github.com/anthropics/skills) | 2026-03-02 |
| [`canvas-design`](skills/canvas-design/) | Create beautiful visual art in .png and .pdf documents using design philosophy. You should... | AI Tools | [GitHub](https://github.com/anthropics/skills) | 2026-03-02 |
| [`doc-coauthoring`](skills/doc-coauthoring/) | Guide users through a structured workflow for co-authoring documentation. Use when user wa... | AI Tools | [GitHub](https://github.com/anthropics/skills) | 2026-03-02 |
| [`docx`](skills/docx/) | Use this skill whenever the user wants to create, read, edit, or manipulate Word documents... | AI Tools | [GitHub](https://github.com/anthropics/skills) | 2026-03-02 |
| [`internal-comms`](skills/internal-comms/) | A set of resources to help me write all kinds of internal communications, using the format... | AI Tools | [GitHub](https://github.com/anthropics/skills) | 2026-03-02 |
| [`mcp-builder`](skills/mcp-builder/) | Guide for creating high-quality MCP (Model Context Protocol) servers that enable LLMs to i... | AI Tools | [GitHub](https://github.com/anthropics/skills) | 2026-03-02 |
| [`pdf`](skills/pdf/) | Use this skill whenever the user wants to do anything with PDF files. This includes readin... | AI Tools | [GitHub](https://github.com/anthropics/skills) | 2026-03-02 |
| [`pptx`](skills/pptx/) | Use this skill any time a .pptx file is involved in any way — as input, output, or both. T... | AI Tools | [GitHub](https://github.com/anthropics/skills) | 2026-03-02 |
| [`prompt-engineering-patterns`](skills/prompt-engineering-patterns/) | Master advanced prompt engineering techniques to maximize LLM performance, reliability, an... | AI Tools | [GitHub](https://github.com/wshobson/agents) | 2026-03-02 |
| [`rag-implementation`](skills/rag-implementation/) | Build Retrieval-Augmented Generation (RAG) systems for LLM applications with vector databa... | AI Tools | [GitHub](https://github.com/wshobson/agents) | 2026-03-02 |
| [`skill-creator`](skills/skill-creator/) | Create new skills, modify and improve existing skills, and measure skill performance. Use ... | AI Tools | [GitHub](https://github.com/anthropics/skills) | 2026-03-02 |
| [`slack-gif-creator`](skills/slack-gif-creator/) | Knowledge and utilities for creating animated GIFs optimized for Slack. Provides constrain... | AI Tools | [GitHub](https://github.com/anthropics/skills) | 2026-03-02 |
| [`template-skill`](skills/template-skill/) | Replace with description of the skill and when Claude should use it. | AI Tools | [GitHub](https://github.com/anthropics/skills) | 2026-03-02 |
| [`theme-factory`](skills/theme-factory/) | Toolkit for styling artifacts with a theme. These artifacts can be slides, docs, reporting... | AI Tools | [GitHub](https://github.com/anthropics/skills) | 2026-03-02 |
| [`web-artifacts-builder`](skills/web-artifacts-builder/) | Suite of tools for creating elaborate, multi-component claude.ai HTML artifacts using mode... | AI Tools | [GitHub](https://github.com/anthropics/skills) | 2026-03-02 |
| [`webapp-testing`](skills/webapp-testing/) | Toolkit for interacting with and testing local web applications using Playwright. Supports... | AI Tools | [GitHub](https://github.com/anthropics/skills) | 2026-03-02 |
| [`xlsx`](skills/xlsx/) | Use this skill any time a spreadsheet file is the primary input or output. This means any ... | AI Tools | [GitHub](https://github.com/anthropics/skills) | 2026-03-02 |
| [`brainstorming`](skills/brainstorming/) | You MUST use this before any creative work - creating features, building components, addin... | Productivity | [GitHub](https://github.com/obra/superpowers) | 2026-03-02 |
| [`dispatching-parallel-agents`](skills/dispatching-parallel-agents/) | Use when facing 2+ independent tasks that can be worked on without shared state or sequent... | Productivity | [GitHub](https://github.com/obra/superpowers) | 2026-03-02 |
| [`executing-plans`](skills/executing-plans/) | Use when you have a written implementation plan to execute in a separate session with revi... | Productivity | [GitHub](https://github.com/obra/superpowers) | 2026-03-02 |
| [`finishing-a-development-branch`](skills/finishing-a-development-branch/) | Use when implementation is complete, all tests pass, and you need to decide how to integra... | Productivity | [GitHub](https://github.com/obra/superpowers) | 2026-03-02 |
| [`receiving-code-review`](skills/receiving-code-review/) | Use when receiving code review feedback, before implementing suggestions, especially if fe... | Productivity | [GitHub](https://github.com/obra/superpowers) | 2026-03-02 |
| [`remembering-conversations`](skills/remembering-conversations/) | Use when user asks 'how should I...' or 'what's the best approach...' after exploring code... | Productivity | [GitHub](https://github.com/obra/episodic-memory) | 2026-03-02 |
| [`requesting-code-review`](skills/requesting-code-review/) | Use when completing tasks, implementing major features, or before merging to verify work m... | Productivity | [GitHub](https://github.com/obra/superpowers) | 2026-03-02 |
| [`subagent-driven-development`](skills/subagent-driven-development/) | Use when executing implementation plans with independent tasks in the current session | Productivity | [GitHub](https://github.com/obra/superpowers) | 2026-03-02 |
| [`systematic-debugging`](skills/systematic-debugging/) | Use when encountering any bug, test failure, or unexpected behavior, before proposing fixe... | Productivity | [GitHub](https://github.com/obra/superpowers) | 2026-03-02 |
| [`test-driven-development`](skills/test-driven-development/) | Use when implementing any feature or bugfix, before writing implementation code | Productivity | [GitHub](https://github.com/obra/superpowers) | 2026-03-02 |
| [`using-git-worktrees`](skills/using-git-worktrees/) | Use when starting feature work that needs isolation from current workspace or before execu... | Productivity | [GitHub](https://github.com/obra/superpowers) | 2026-03-02 |
| [`using-superpowers`](skills/using-superpowers/) | Use when starting any conversation - establishes how to find and use skills, requiring Ski... | Productivity | [GitHub](https://github.com/obra/superpowers) | 2026-03-02 |
| [`verification-before-completion`](skills/verification-before-completion/) | Use when about to claim work is complete, fixed, or passing, before committing or creating... | Productivity | [GitHub](https://github.com/obra/superpowers) | 2026-03-02 |
| [`writing-plans`](skills/writing-plans/) | Use when you have a spec or requirements for a multi-step task, before touching code | Productivity | [GitHub](https://github.com/obra/superpowers) | 2026-03-02 |
| [`writing-skills`](skills/writing-skills/) | Use when creating new skills, editing existing skills, or verifying skills work before dep... | Productivity | [GitHub](https://github.com/obra/superpowers) | 2026-03-02 |
| [`ab-test-setup`](skills/ab-test-setup/) | When the user wants to plan, design, or implement an A/B test or experiment. Also use when... | Marketing | [GitHub](https://github.com/coreyhaines31/marketingskills) | 2026-03-02 |
| [`analytics-tracking`](skills/analytics-tracking/) | When the user wants to set up, improve, or audit analytics tracking and measurement. Also ... | Marketing | [GitHub](https://github.com/coreyhaines31/marketingskills) | 2026-03-02 |
| [`competitor-alternatives`](skills/competitor-alternatives/) | When the user wants to create competitor comparison or alternative pages for SEO and sales... | Marketing | [GitHub](https://github.com/coreyhaines31/marketingskills) | 2026-03-02 |
| [`content-strategy`](skills/content-strategy/) | When the user wants to plan a content strategy, decide what content to create, or figure o... | Marketing | [GitHub](https://github.com/coreyhaines31/marketingskills) | 2026-03-02 |
| [`copy-editing`](skills/copy-editing/) | When the user wants to edit, review, or improve existing marketing copy. Also use when the... | Marketing | [GitHub](https://github.com/coreyhaines31/marketingskills) | 2026-03-02 |
| [`copywriting`](skills/copywriting/) | When the user wants to write, rewrite, or improve marketing copy for any page — including ... | Marketing | [GitHub](https://github.com/coreyhaines31/marketingskills) | 2026-03-02 |
| [`email-sequence`](skills/email-sequence/) | When the user wants to create or optimize an email sequence, drip campaign, automated emai... | Marketing | [GitHub](https://github.com/coreyhaines31/marketingskills) | 2026-03-02 |
| [`form-cro`](skills/form-cro/) | When the user wants to optimize any form that is NOT signup/registration — including lead ... | Marketing | [GitHub](https://github.com/coreyhaines31/marketingskills) | 2026-03-02 |
| [`free-tool-strategy`](skills/free-tool-strategy/) | When the user wants to plan, evaluate, or build a free tool for marketing purposes — lead ... | Marketing | [GitHub](https://github.com/coreyhaines31/marketingskills) | 2026-03-02 |
| [`launch-strategy`](skills/launch-strategy/) | When the user wants to plan a product launch, feature announcement, or release strategy. A... | Marketing | [GitHub](https://github.com/coreyhaines31/marketingskills) | 2026-03-02 |
| [`marketing-ideas`](skills/marketing-ideas/) | When the user needs marketing ideas, inspiration, or strategies for their SaaS or software... | Marketing | [GitHub](https://github.com/coreyhaines31/marketingskills) | 2026-03-02 |
| [`marketing-psychology`](skills/marketing-psychology/) | When the user wants to apply psychological principles, mental models, or behavioral scienc... | Marketing | [GitHub](https://github.com/coreyhaines31/marketingskills) | 2026-03-02 |
| [`onboarding-cro`](skills/onboarding-cro/) | When the user wants to optimize post-signup onboarding, user activation, first-run experie... | Marketing | [GitHub](https://github.com/coreyhaines31/marketingskills) | 2026-03-02 |
| [`page-cro`](skills/page-cro/) | When the user wants to optimize, improve, or increase conversions on any marketing page — ... | Marketing | [GitHub](https://github.com/coreyhaines31/marketingskills) | 2026-03-02 |
| [`paid-ads`](skills/paid-ads/) | When the user wants help with paid advertising campaigns on Google Ads, Meta (Facebook/Ins... | Marketing | [GitHub](https://github.com/coreyhaines31/marketingskills) | 2026-03-02 |
| [`popup-cro`](skills/popup-cro/) | When the user wants to create or optimize popups, modals, overlays, slide-ins, or banners ... | Marketing | [GitHub](https://github.com/coreyhaines31/marketingskills) | 2026-03-02 |
| [`pricing-strategy`](skills/pricing-strategy/) | When the user wants help with pricing decisions, packaging, or monetization strategy. Also... | Marketing | [GitHub](https://github.com/coreyhaines31/marketingskills) | 2026-03-02 |
| [`product-marketing-context`](skills/product-marketing-context/) | When the user wants to create or update their product marketing context document. Also use... | Marketing | [GitHub](https://github.com/coreyhaines31/marketingskills) | 2026-03-02 |
| [`programmatic-seo`](skills/programmatic-seo/) | When the user wants to create SEO-driven pages at scale using templates and data. Also use... | Marketing | [GitHub](https://github.com/coreyhaines31/marketingskills) | 2026-03-02 |
| [`referral-program`](skills/referral-program/) | When the user wants to create, optimize, or analyze a referral program, affiliate program,... | Marketing | [GitHub](https://github.com/coreyhaines31/marketingskills) | 2026-03-02 |
| [`seo-audit`](skills/seo-audit/) | When the user wants to audit, review, or diagnose SEO issues on their site. Also use when ... | Marketing | [GitHub](https://github.com/coreyhaines31/marketingskills) | 2026-03-02 |
| [`signup-flow-cro`](skills/signup-flow-cro/) | When the user wants to optimize signup, registration, account creation, or trial activatio... | Marketing | [GitHub](https://github.com/coreyhaines31/marketingskills) | 2026-03-02 |
| [`social-content`](skills/social-content/) | When the user wants help creating, scheduling, or optimizing social media content for Link... | Marketing | [GitHub](https://github.com/coreyhaines31/marketingskills) | 2026-03-02 |
| [`next-best-practices`](skills/next-best-practices/) | Next.js best practices - file conventions, RSC boundaries, data patterns, async APIs, meta... | Frontend | [GitHub](https://github.com/vercel-labs/next-skills) | 2026-03-02 |
| [`next-cache-components`](skills/next-cache-components/) | Next.js 16 Cache Components - PPR, use cache directive, cacheLife, cacheTag, updateTag | Frontend | [GitHub](https://github.com/vercel-labs/next-skills) | 2026-03-02 |
| [`nextjs-app-router-patterns`](skills/nextjs-app-router-patterns/) | Master Next.js 14+ App Router with Server Components, streaming, parallel routes, and adva... | Frontend | [GitHub](https://github.com/wshobson/agents) | 2026-03-02 |
| [`nuxt`](skills/nuxt/) | Nuxt full-stack Vue framework with SSR, auto-imports, and file-based routing. Use when wor... | Frontend | [GitHub](https://github.com/antfu/skills) | 2026-03-02 |
| [`pinia`](skills/pinia/) | Pinia official Vue state management library, type-safe and extensible. Use when defining s... | Frontend | [GitHub](https://github.com/antfu/skills) | 2026-03-02 |
| [`pnpm`](skills/pnpm/) | Node.js package manager with strict dependency resolution. Use when running pnpm specific ... | Frontend | [GitHub](https://github.com/antfu/skills) | 2026-03-02 |
| [`react-state-management`](skills/react-state-management/) | Master modern React state management with Redux Toolkit, Zustand, Jotai, and React Query. ... | Frontend | [GitHub](https://github.com/wshobson/agents) | 2026-03-02 |
| [`responsive-design`](skills/responsive-design/) | Implement modern responsive layouts using container queries, fluid typography, CSS Grid, a... | Frontend | [GitHub](https://github.com/wshobson/agents) | 2026-03-02 |
| [`slidev`](skills/slidev/) | Create and present web-based slides for developers using Markdown, Vue components, code hi... | Frontend | [GitHub](https://github.com/antfu/skills) | 2026-03-02 |
| [`turborepo`](skills/turborepo/) | name: turborepo | Frontend | [GitHub](https://github.com/vercel/turborepo) | 2026-03-02 |
| [`unocss`](skills/unocss/) | UnoCSS instant atomic CSS engine, superset of Tailwind CSS. Use when configuring UnoCSS, w... | Frontend | [GitHub](https://github.com/antfu/skills) | 2026-03-02 |
| [`vercel-ai-sdk`](skills/vercel-ai-sdk/) | Answer questions about the AI SDK and help build AI-powered features. Use when developers:... | Frontend | [GitHub](https://github.com/vercel/ai) | 2026-03-02 |
| [`vercel-composition-patterns`](skills/vercel-composition-patterns/) | React composition patterns that scale. Use when refactoring components with | Frontend | [GitHub](https://github.com/vercel-labs/agent-skills) | 2026-03-02 |
| [`vercel-react-best-practices`](skills/vercel-react-best-practices/) | React and Next.js performance optimization guidelines from Vercel Engineering. This skill ... | Frontend | [GitHub](https://github.com/vercel-labs/agent-skills) | 2026-03-02 |
| [`vite`](skills/vite/) | Vite build tool configuration, plugin API, SSR, and Vite 8 Rolldown migration. Use when wo... | Frontend | [GitHub](https://github.com/antfu/skills) | 2026-03-02 |
| [`vitepress`](skills/vitepress/) | VitePress static site generator powered by Vite and Vue. Use when building documentation s... | Frontend | [GitHub](https://github.com/antfu/skills) | 2026-03-02 |
| [`vitest`](skills/vitest/) | Vitest fast unit testing framework powered by Vite with Jest-compatible API. Use when writ... | Frontend | [GitHub](https://github.com/antfu/skills) | 2026-03-02 |
| [`vue`](skills/vue/) | Vue 3 Composition API, script setup macros, reactivity system, and built-in components. Us... | Frontend | [GitHub](https://github.com/antfu/skills) | 2026-03-02 |
| [`vue-best-practices`](skills/vue-best-practices/) | MUST be used for Vue.js tasks. Strongly recommends Composition API with `<script setup>` a... | Frontend | [GitHub](https://github.com/antfu/skills) | 2026-03-02 |
| [`vue-best-practices-hyf0`](skills/vue-best-practices-hyf0/) | MUST be used for Vue.js tasks. Strongly recommends Composition API with `<script setup>` a... | Frontend | [GitHub](https://github.com/hyf0/vue-skills) | 2026-03-02 |
| [`vue-debug-guides`](skills/vue-debug-guides/) | Vue 3 debugging and error handling for runtime errors, warnings, async failures, and SSR/h... | Frontend | [GitHub](https://github.com/hyf0/vue-skills) | 2026-03-02 |
| [`vue-jsx-best-practices`](skills/vue-jsx-best-practices/) | JSX syntax in Vue (e.g., class vs className, JSX plugin config). | Frontend | [GitHub](https://github.com/hyf0/vue-skills) | 2026-03-02 |
| [`vue-pinia-best-practices`](skills/vue-pinia-best-practices/) | Pinia stores, state management patterns, store setup, and reactivity with stores. | Frontend | [GitHub](https://github.com/hyf0/vue-skills) | 2026-03-02 |
| [`vue-router-best-practices`](skills/vue-router-best-practices/) | Vue Router 4 patterns, navigation guards, route params, and route-component lifecycle inte... | Frontend | [GitHub](https://github.com/antfu/skills) | 2026-03-02 |
| [`vue-router-best-practices-hyf0`](skills/vue-router-best-practices-hyf0/) | Vue Router 4 patterns, navigation guards, route params, and route-component lifecycle inte... | Frontend | [GitHub](https://github.com/hyf0/vue-skills) | 2026-03-02 |
| [`vue-testing-best-practices`](skills/vue-testing-best-practices/) | Use for Vue.js testing. Covers Vitest, Vue Test Utils, component testing, mocking, testing... | Frontend | [GitHub](https://github.com/antfu/skills) | 2026-03-02 |
| [`vue-testing-best-practices-hyf0`](skills/vue-testing-best-practices-hyf0/) | Use for Vue.js testing. Covers Vitest, Vue Test Utils, component testing, mocking, testing... | Frontend | [GitHub](https://github.com/hyf0/vue-skills) | 2026-03-02 |
| [`web-component-design`](skills/web-component-design/) | Master React, Vue, and Svelte component patterns including CSS-in-JS, composition strategi... | Frontend | [GitHub](https://github.com/wshobson/agents) | 2026-03-02 |
| [`web-design-guidelines`](skills/web-design-guidelines/) | Review UI code for Web Interface Guidelines compliance. Use when asked to "review my UI", ... | Frontend | [GitHub](https://github.com/vercel-labs/agent-skills) | 2026-03-02 |
| [`expo-api-routes`](skills/expo-api-routes/) | Guidelines for creating API routes in Expo Router with EAS Hosting | Mobile | [GitHub](https://github.com/expo/skills) | 2026-03-02 |
| [`expo-building-native-ui`](skills/expo-building-native-ui/) | Complete guide for building beautiful apps with Expo Router. Covers fundamentals, styling,... | Mobile | [GitHub](https://github.com/expo/skills) | 2026-03-02 |
| [`expo-cicd-workflows`](skills/expo-cicd-workflows/) | Helps understand and write EAS workflow YAML files for Expo projects. Use this skill when ... | Mobile | [GitHub](https://github.com/expo/skills) | 2026-03-02 |
| [`expo-deployment`](skills/expo-deployment/) | Deploying Expo apps to iOS App Store, Android Play Store, web hosting, and API routes | Mobile | [GitHub](https://github.com/expo/skills) | 2026-03-02 |
| [`expo-dev-client`](skills/expo-dev-client/) | Build and distribute Expo development clients locally or via TestFlight | Mobile | [GitHub](https://github.com/expo/skills) | 2026-03-02 |
| [`expo-native-data-fetching`](skills/expo-native-data-fetching/) | Use when implementing or debugging ANY network request, API call, or data fetching. Covers... | Mobile | [GitHub](https://github.com/expo/skills) | 2026-03-02 |
| [`expo-tailwind-setup`](skills/expo-tailwind-setup/) | Set up Tailwind CSS v4 in Expo with react-native-css and NativeWind v5 for universal styli... | Mobile | [GitHub](https://github.com/expo/skills) | 2026-03-02 |
| [`expo-ui-jetpack-compose`](skills/expo-ui-jetpack-compose/) | `@expo/ui/jetpack-compose` package lets you use Jetpack Compose Views and modifiers in you... | Mobile | [GitHub](https://github.com/expo/skills) | 2026-03-02 |
| [`expo-ui-swift-ui`](skills/expo-ui-swift-ui/) | `@expo/ui/swift-ui` package lets you use SwiftUI Views and modifiers in your app. | Mobile | [GitHub](https://github.com/expo/skills) | 2026-03-02 |
| [`expo-use-dom`](skills/expo-use-dom/) | Use Expo DOM components to run web code in a webview on native and as-is on web. Migrate w... | Mobile | [GitHub](https://github.com/expo/skills) | 2026-03-02 |
| [`react-native-best-practices`](skills/react-native-best-practices/) | Provides React Native performance optimization guidelines for FPS, TTI, bundle size, memor... | Mobile | [GitHub](https://github.com/callstackincubator/agent-skills) | 2026-03-02 |
| [`upgrading-expo`](skills/upgrading-expo/) | Guidelines for upgrading Expo SDK versions and fixing dependency issues | Mobile | [GitHub](https://github.com/expo/skills) | 2026-03-02 |
| [`upgrading-react-native`](skills/upgrading-react-native/) | Upgrades React Native apps to newer versions by applying rn-diff-purge template diffs, upd... | Mobile | [GitHub](https://github.com/callstackincubator/agent-skills) | 2026-03-02 |
| [`api-design-principles`](skills/api-design-principles/) | Master REST and GraphQL API design principles to build intuitive, scalable, and maintainab... | Backend | [GitHub](https://github.com/wshobson/agents) | 2026-03-02 |
| [`architecture-patterns`](skills/architecture-patterns/) | Implement proven backend architecture patterns including Clean Architecture, Hexagonal Arc... | Backend | [GitHub](https://github.com/wshobson/agents) | 2026-03-02 |
| [`microservices-patterns`](skills/microservices-patterns/) | Design microservices architectures with service boundaries, event-driven communication, an... | Backend | [GitHub](https://github.com/wshobson/agents) | 2026-03-02 |
| [`modern-javascript-patterns`](skills/modern-javascript-patterns/) | Master ES6+ features including async/await, destructuring, spread operators, arrow functio... | Backend | [GitHub](https://github.com/wshobson/agents) | 2026-03-02 |
| [`nodejs-backend-patterns`](skills/nodejs-backend-patterns/) | Build production-ready Node.js backend services with Express/Fastify, implementing middlew... | Backend | [GitHub](https://github.com/wshobson/agents) | 2026-03-02 |
| [`python-design-patterns`](skills/python-design-patterns/) | Python design patterns including KISS, Separation of Concerns, Single Responsibility, and ... | Backend | [GitHub](https://github.com/wshobson/agents) | 2026-03-02 |
| [`python-performance-optimization`](skills/python-performance-optimization/) | Profile and optimize Python code using cProfile, memory profilers, and performance best pr... | Backend | [GitHub](https://github.com/wshobson/agents) | 2026-03-02 |
| [`python-testing-patterns`](skills/python-testing-patterns/) | Implement comprehensive testing strategies with pytest, fixtures, mocking, and test-driven... | Backend | [GitHub](https://github.com/wshobson/agents) | 2026-03-02 |
| [`typescript-advanced-types`](skills/typescript-advanced-types/) | Master TypeScript's advanced type system including generics, conditional types, mapped typ... | Backend | [GitHub](https://github.com/wshobson/agents) | 2026-03-02 |
| [`postgresql-table-design`](skills/postgresql-table-design/) | Design a PostgreSQL-specific schema. Covers best-practices, data types, indexing, constrai... | Database | [GitHub](https://github.com/wshobson/agents) | 2026-03-02 |
| [`supabase-postgres-best-practices`](skills/supabase-postgres-best-practices/) | Postgres performance optimization and best practices from Supabase. Use this skill when wr... | Database | [GitHub](https://github.com/supabase/agent-skills) | 2026-03-02 |
| [`better-auth-best-practices`](skills/better-auth-best-practices/) | Skill for integrating Better Auth - the comprehensive TypeScript authentication framework. | Auth | [GitHub](https://github.com/better-auth/skills) | 2026-03-02 |
| [`create-auth-skill`](skills/create-auth-skill/) | Skill for creating auth layers in TypeScript/JavaScript apps using Better Auth. | Auth | [GitHub](https://github.com/better-auth/skills) | 2026-03-02 |
| [`add-educational-comments`](skills/add-educational-comments/) | Add educational comments to the file specified, or prompt asking for file to comment if on... | DevOps | [GitHub](https://github.com/github/awesome-copilot) | 2026-03-02 |
| [`agent-governance`](skills/agent-governance/) | name: agent-governance | DevOps | [GitHub](https://github.com/github/awesome-copilot) | 2026-03-02 |
| [`agentic-eval`](skills/agentic-eval/) | name: agentic-eval | DevOps | [GitHub](https://github.com/github/awesome-copilot) | 2026-03-02 |
| [`ai-prompt-engineering-safety-review`](skills/ai-prompt-engineering-safety-review/) | Comprehensive AI prompt engineering safety review and improvement prompt. Analyzes prompts... | DevOps | [GitHub](https://github.com/github/awesome-copilot) | 2026-03-02 |
| [`apple-appstore-reviewer`](skills/apple-appstore-reviewer/) | Serves as a reviewer of the codebase with instructions on looking for Apple App Store opti... | DevOps | [GitHub](https://github.com/github/awesome-copilot) | 2026-03-02 |
| [`architecture-blueprint-generator`](skills/architecture-blueprint-generator/) | Comprehensive project architecture blueprint generator that analyzes codebases to create d... | DevOps | [GitHub](https://github.com/github/awesome-copilot) | 2026-03-02 |
| [`boost-prompt`](skills/boost-prompt/) | Interactive prompt refinement workflow: interrogates scope, deliverables, constraints; cop... | DevOps | [GitHub](https://github.com/github/awesome-copilot) | 2026-03-02 |
| [`breakdown-feature-implementation`](skills/breakdown-feature-implementation/) | Prompt for creating detailed feature implementation plans, following Epoch monorepo struct... | DevOps | [GitHub](https://github.com/github/awesome-copilot) | 2026-03-02 |
| [`chrome-devtools`](skills/chrome-devtools/) | Expert-level browser automation, debugging, and performance analysis using Chrome DevTools... | DevOps | [GitHub](https://github.com/github/awesome-copilot) | 2026-03-02 |
| [`code-exemplars-blueprint-generator`](skills/code-exemplars-blueprint-generator/) | Technology-agnostic prompt generator that creates customizable AI prompts for scanning cod... | DevOps | [GitHub](https://github.com/github/awesome-copilot) | 2026-03-02 |
| [`git-commit`](skills/git-commit/) | Execute git commit with conventional commit message analysis, intelligent staging, and mes... | DevOps | [GitHub](https://github.com/github/awesome-copilot) | 2026-03-02 |
| [`openclaw-guardian`](skills/openclaw-guardian/) | Deploy and manage a Guardian watchdog process for OpenClaw Gateway. Provides automated hea... | DevOps | [GitHub](https://github.com/LeoYeAI/openclaw-guardian) | 2026-03-02 |
| [`audit-website`](skills/audit-website/) | Audit websites for SEO, performance, security, technical, content, and 15 other issue cate... | Web Automation | [GitHub](https://github.com/squirrelscan/skills) | 2026-03-02 |
| [`browser-use`](skills/browser-use/) | Automates browser interactions for web testing, form filling, screenshots, and data extrac... | Web Automation | [GitHub](https://github.com/browser-use/browser-use) | 2026-03-02 |
| [`firecrawl`](skills/firecrawl/) | name: firecrawl | Web Automation | [GitHub](https://github.com/firecrawl/cli) | 2026-03-02 |
| [`react-doctor`](skills/react-doctor/) | Run after making React changes to catch issues early. Use when reviewing code, finishing a... | Other | [GitHub](https://github.com/millionco/react-doctor) | 2026-03-02 |

> More skills added every Monday. [Submit yours →](../../issues/new?template=submit-skill.md)

---

## 📬 Submit a Skill

[Open a Submit Skill issue](../../issues/new?template=submit-skill.md) or open a Pull Request with your skill folder under `skills/`.

**Review criteria:** valid `SKILL.md` · clear purpose · no hardcoded credentials · works on standard OpenClaw

## 📅 Weekly Updates

See [CHANGELOG.md](CHANGELOG.md) — updated every Monday.

## 🔍 How We Collect

Every week our script scans:
- **[skills.sh](https://skills.sh)** — top leaderboard skills
- **GitHub** — repos tagged `openclaw-skill`
- **[ClaWHub](https://clawhub.ai)** — latest published skills

Validated, tested, merged, and pushed automatically.

## License

MIT © [MyClaw.ai](https://myclaw.ai)
