# Exercise Patterns

Use these patterns to generate practice items from imported knowledge chunks.

## 1) Free Recall

- Prompt pattern: "Without looking at notes, explain <concept> and why it matters."
- Pass criteria: includes core definition, mechanism, and one concrete example.

## 2) Q&A

- Prompt pattern: "What is <term>? How is it different from <related-term>?"
- Pass criteria: direct answer + one key distinction.

## 3) Application

- Prompt pattern: "Given <scenario>, how would you apply <concept> and what tradeoff appears?"
- Pass criteria: selects concept correctly and states at least one tradeoff.

## Difficulty Heuristic

- easy: direct definition or recall from one chunk.
- medium: synthesis across 2 chunks.
- hard: transfer to a new scenario or compare competing approaches.

## Quality Checks

- Avoid yes/no-only prompts.
- Avoid questions with multiple plausible answer keys unless rubric is explicit.
- Keep each question scoped to one learning objective.
