# OpenClaw Skill Recommendation Report

**Generated:** {TIMESTAMP}
**Report ID:** {REPORT_ID}
**OpenClaw Version:** {VERSION}

---

## Configuration Summary

**Gateway Status:** {GATEWAY_STATUS}
**Installation Type:** {INSTALL_TYPE}
**Primary Use Case:** {USE_CASE}

**Enabled Channels:**
- {ENABLED_CHANNELS_LIST}

**Active AI Providers:**
- {ACTIVE_PROVIDERS_LIST}

**Sandbox Status:** {SANDBOX_STATUS}

---

## Channel Detection

### WhatsApp {WHATSAPP_STATUS}
{WHATSAPP_DETAILS}

**Recommended Skills:**
- `whatsapp-media-handler` - Handle images, videos, documents
- `message-formatter` - Rich text formatting
- `qr-code-generator` - Generate QR codes
- `auto-responder` - Automated message responses
- `translation-tool` - Multi-language support

### Telegram {TELEGRAM_STATUS}
{TELEGRAM_DETAILS}

**Recommended Skills:**
- `telegram-bot-ui` - Interactive keyboards and buttons
- `inline-query-handler` - Inline search functionality
- `poll-creator` - Create and manage polls
- `file-sharing` - Advanced file management
- `telegram-analytics` - Bot usage analytics

### Discord {DISCORD_STATUS}
{DISCORD_DETAILS}

**Recommended Skills:**
- `discord-embed-builder` - Rich embed messages
- `slash-commands-pro` - Advanced slash commands
- `role-manager` - Automated role assignment
- `moderation-tools` - Channel moderation
- `discord-voice` - Voice channel integration

### Slack {SLACK_STATUS}
{SLACK_DETAILS}

**Recommended Skills:**
- `slack-workflows` - Workflow automation
- `block-kit-builder` - Interactive messages
- `standup-bot` - Daily standups
- `slack-analytics` - Workspace insights
- `notification-manager` - Smart notifications

### Signal {SIGNAL_STATUS}
{SIGNAL_DETAILS}

**Recommended Skills:**
- `signal-groups` - Group management
- `signal-media` - Media handling
- `privacy-tools` - Enhanced privacy features

---

## Use Case Analysis

**Detected Use Cases:**
1. {USE_CASE_1}
2. {USE_CASE_2}
3. {USE_CASE_3}

### For {USE_CASE_1}

**Essential Skills:**
| Skill | Description | Rating | Installs |
|-------|-------------|--------|----------|
| {SKILL_1} | {DESC_1} | {RATING_1} | {INSTALLS_1} |
| {SKILL_2} | {DESC_2} | {RATING_2} | {INSTALLS_2} |
| {SKILL_3} | {DESC_3} | {RATING_3} | {INSTALLS_3} |

**Suggested Skills:**
| Skill | Description | Rating | Installs |
|-------|-------------|--------|----------|
| {SKILL_4} | {DESC_4} | {RATING_4} | {INSTALLS_4} |
| {SKILL_5} | {DESC_5} | {RATING_5} | {INSTALLS_5} |

---

## Category Recommendations

### AI & Machine Learning
{AI_SKILLS_RECOMMENDATION}

**Top Picks:**
- **image-generator-pro** (⭐ 4.8) - Multi-provider image generation
- **text-embeddings** (⭐ 4.6) - Text embedding generation
- **sentiment-analyzer** (⭐ 4.5) - Real-time sentiment analysis
- **translation-ai** (⭐ 4.7) - Neural machine translation

### Automation
{AUTOMATION_SKILLS_RECOMMENDATION}

**Top Picks:**
- **workflow-builder** (⭐ 4.7) - Visual workflow automation
- **scheduler-pro** (⭐ 4.6) - Advanced task scheduling
- **batch-processor** (⭐ 4.4) - Batch operations
- **trigger-manager** (⭐ 4.5) - Event-based triggers

### Utilities
{UTILITIES_SKILLS_RECOMMENDATION}

**Top Picks:**
- **pdf-toolkit** (⭐ 4.9) - Complete PDF manipulation
- **image-optimizer** (⭐ 4.7) - Image compression
- **file-converter** (⭐ 4.6) - Multi-format conversion
- **qr-code-tools** (⭐ 4.5) - QR generation/scanning

### Integrations
{INTEGRATIONS_SKILLS_RECOMMENDATION}

**Top Picks:**
- **google-workspace** (⭐ 4.6) - Google Workspace integration
- **github-integration** (⭐ 4.8) - GitHub automation
- **zapier-bridge** (⭐ 4.4) - Zapier compatibility
- **webhook-manager** (⭐ 4.5) - Webhook handling

---

## Install Commands

### Quick Install (Top Recommended)
```bash
openclaw skills install \
  whatsapp-media-handler \
  message-formatter \
  auto-responder \
  image-generator-pro \
  pdf-toolkit
```

### Essential Skills by Category

**AI Skills:**
```bash
openclaw skills install image-generator-pro text-embeddings sentiment-analyzer
```

**Automation Skills:**
```bash
openclaw skills install workflow-builder scheduler-pro trigger-manager
```

**Utility Skills:**
```bash
openclaw skills install pdf-toolkit image-optimizer file-converter
```

**Integration Skills:**
```bash
openclaw skills install google-workspace github-integration webhook-manager
```

### Full Installation (All Recommended)
```bash
openclaw skills install \
  whatsapp-media-handler message-formatter qr-code-generator auto-responder \
  translation-tool telegram-bot-ui inline-query-handler poll-creator \
  discord-embed-builder slack-workflows image-generator-pro text-embeddings \
  workflow-builder pdf-toolkit image-optimizer google-workspace
```

---

## Skill Compatibility Matrix

| Skill | WhatsApp | Telegram | Discord | Slack | Signal |
|-------|----------|----------|---------|-------|--------|
| whatsapp-media-handler | ✓ | - | - | - | - |
| telegram-bot-ui | - | ✓ | - | - | - |
| discord-embed-builder | - | - | ✓ | - | - |
| slack-workflows | - | - | - | ✓ | - |
| image-generator-pro | ✓ | ✓ | ✓ | ✓ | ✓ |
| pdf-toolkit | ✓ | ✓ | ✓ | ✓ | ✓ |
| auto-responder | ✓ | ✓ | ✓ | ✓ | ✓ |
| translation-tool | ✓ | ✓ | ✓ | ✓ | ✓ |

---

## Current Skills Analysis

### Installed Skills ({INSTALLED_COUNT})
{INSTALLED_SKILLS_LIST}

### Outdated Skills ({OUTDATED_COUNT})
{OUTDATED_SKILLS_LIST}

**Update Command:**
```bash
openclaw skills update
```

### Missing Dependencies ({MISSING_DEPS_COUNT})
{MISSING_DEPS_LIST}

**Fix Command:**
```bash
openclaw skills install-deps --all
```

---

## Popular Skills in Your Category

Based on similar OpenClaw configurations:

| Rank | Skill | Category | Rating | Users Like You |
|------|-------|----------|--------|----------------|
| 1 | {POPULAR_1} | {CAT_1} | {RATING_1} | {PERCENT_1}% |
| 2 | {POPULAR_2} | {CAT_2} | {RATING_2} | {PERCENT_2}% |
| 3 | {POPULAR_3} | {CAT_3} | {RATING_3} | {PERCENT_3}% |
| 4 | {POPULAR_4} | {CAT_4} | {RATING_4} | {PERCENT_4}% |
| 5 | {POPULAR_5} | {CAT_5} | {RATING_5} | {PERCENT_5}% |

---

## Trending Skills (This Week)

| Skill | Category | Rating | Growth |
|-------|----------|--------|--------|
| {TRENDING_1} | {TCAT_1} | {TRATING_1} | +{GROWTH_1}% |
| {TRENDING_2} | {TCAT_2} | {TRATING_2} | +{GROWTH_2}% |
| {TRENDING_3} | {TCAT_3} | {TRATING_3} | +{GROWTH_3}% |

---

## Skill Bundles

### Customer Support Bundle
Perfect for customer service automation:
```bash
openclaw skills install \
  auto-responder \
  sentiment-analyzer \
  translation-tool \
  ticket-manager \
  knowledge-base
```

**Estimated Setup Time:** 15 minutes
**Combined Rating:** ⭐ 4.6/5.0

### Content Creation Bundle
For content generation and management:
```bash
openclaw skills install \
  image-generator-pro \
  text-generator \
  pdf-toolkit \
  image-optimizer \
  watermark-tool
```

**Estimated Setup Time:** 10 minutes
**Combined Rating:** ⭐ 4.7/5.0

### Automation Bundle
Complete workflow automation:
```bash
openclaw skills install \
  workflow-builder \
  scheduler-pro \
  trigger-manager \
  webhook-manager \
  batch-processor
```

**Estimated Setup Time:** 20 minutes
**Combined Rating:** ⭐ 4.5/5.0

### Integration Bundle
Connect with external services:
```bash
openclaw skills install \
  google-workspace \
  github-integration \
  slack-connector \
  zapier-bridge \
  api-gateway
```

**Estimated Setup Time:** 25 minutes
**Combined Rating:** ⭐ 4.6/5.0

---

## Configuration Suggestions

### Recommended Config Updates

**For better skill performance:**
```yaml
skills:
  autoUpdate: true
  updateCheck: "daily"
  parallelExecution: true
  maxConcurrent: 5
```

**For enhanced features:**
```yaml
ai:
  providers:
    openai:
      model: "gpt-4"  # Better for complex skills

sandbox:
  memory:
    limit: "2GB"  # More memory for heavy skills
  timeout:
    execution: 300000  # 5 minutes for long tasks
```

---

## Estimated Resource Impact

### After Installing Recommended Skills

**Storage:**
- Current: {CURRENT_STORAGE}
- After Install: {ESTIMATED_STORAGE}
- Increase: +{STORAGE_INCREASE}

**Memory Usage:**
- Current: {CURRENT_MEMORY}
- Estimated Peak: {ESTIMATED_MEMORY}
- Increase: +{MEMORY_INCREASE}

**Startup Time:**
- Current: {CURRENT_STARTUP}s
- After Install: {ESTIMATED_STARTUP}s
- Increase: +{STARTUP_INCREASE}s

---

## Next Steps

1. **Review Recommendations**
   - Read skill descriptions
   - Check ratings and install counts
   - Review compatibility with your channels

2. **Install Essential Skills**
   ```bash
   openclaw skills install {TOP_3_SKILLS}
   ```

3. **Configure Skills**
   ```bash
   openclaw skills config {SKILL_NAME} show
   openclaw skills config {SKILL_NAME} set {KEY} {VALUE}
   ```

4. **Test Skills**
   ```bash
   openclaw skills run {SKILL_NAME} --help
   openclaw skills run {SKILL_NAME} {ARGS}
   ```

5. **Monitor Performance**
   ```bash
   openclaw status --metrics
   openclaw skills check
   ```

6. **Schedule Updates**
   ```bash
   # Check weekly for updates
   openclaw skills update --schedule "0 2 * * 0"
   ```

---

## Resources

### Skill Documentation
- [ClawHub Integration Guide](../references/clawhub-integration.md)
- [Skill Management Commands](../references/diagnostic-commands.md#skill-management-clawhub)

### Browse Skills
```bash
# Search by category
openclaw skills browse --category ai

# Search by keyword
openclaw skills search "automation"

# Popular skills
openclaw skills popular --top 20
```

### Get Updates
```bash
# Check for skill updates
openclaw skills check-updates

# Update all skills
openclaw skills update

# Update specific skill
openclaw skills update {SKILL_NAME}
```

---

## Support

**Report Generated By:** OpenClaw Doctor Pro v{DOCTOR_VERSION}
**Recommendation Engine:** v{ENGINE_VERSION}
**Report Location:** {REPORT_PATH}

For skill-specific help:
- Skill README: `openclaw skills readme {SKILL_NAME}`
- Skill Documentation: `openclaw skills info {SKILL_NAME}`
- ClawHub: https://hub.openclaw.io

**Keep this report for future reference.**
