#!/bin/bash
# Node.js 安装脚本

echo "=========================================="
echo "Node.js 22.22.0 安装"
echo "=========================================="

# 检查是否已安装
if command -v node >/dev/null 2>&1; then
    echo "✅ Node.js 已安装: $(node --version)"
    exit 0
fi

# 安装 NVM
if ! command -v nvm >/dev/null 2>&1; then
    echo "📦 安装 NVM..."
    curl -o- https://raw.githubusercontent.com/nvm-sh/nvm/v0.40.0/install.sh | bash
    export NVM_DIR="$HOME/.nvm"
    [ -s "$NVM_DIR/nvm.sh" ] && \. "$NVM_DIR/nvm.sh"
fi

# 安装 Node.js
echo "📦 安装 Node.js 22.22.0..."
nvm install 22.22.0
nvm use 22.22.0

node --version
npm --version

echo "✅ Node.js 安装完成！"
