#!/bin/bash
# 环境检查脚本

echo "=========================================="
echo "OpenClaw 环境检查"
echo "=========================================="

# 检查 Node.js
if command -v node >/dev/null 2>&1; then
    echo "✅ Node.js: $(node --version)"
else
    echo "❌ Node.js 未安装"
    exit 1
fi

# 检查 OpenClaw
if command -v openclaw >/dev/null 2>&1; then
    echo "✅ OpenClaw: $(openclaw --version)"
else
    echo "⚠️  OpenClaw 可能未安装（便携版可忽略）"
fi

echo ""
echo "目录结构:"
ls -la ./clean/ ./full/ 2>/dev/null || echo "  未找到 clean/full 目录"

echo ""
echo "✅ 检查完成"
