# OpenClaw 便携版 v1.0.1

OpenClaw 便携部署包，支持自定义路径配置。

## 版本说明

- **纯净版 (clean)**: 无个人配置，需自行设置
- **完整版 (full)**: 包含完整配置

## 快速开始

### 1. 检查环境
```bash
./check-env.sh
```

### 2. 安装 Node.js（如需要）
```bash
./install-node.sh
```

### 3. 启动服务

**纯净版：**
```bash
cd clean
./start.sh
```

**完整版：**
```bash
cd full
./start.sh
```

## 自定义路径

如需自定义路径，设置环境变量后重新构建：

```bash
export OPENCLAW_INSTALL_DIR=/path/to/openclaw
export OPENCLAW_CONFIG_DIR=/path/to/.openclaw
export OUTPUT_DIR=/path/to/output
./scripts/build-portable.sh
```

## 故障排除

### Node.js 未找到
运行 `./install-node.sh` 安装 Node.js 22.x

### 权限不足
```bash
chmod +x */start.sh install-*.sh check-*.sh
```

## 作者

zfanmy-梦月儿

## 版本

v1.0.1 - 修复硬编码路径，支持环境变量配置
