#!/bin/bash
# Stop OpenClaw Docker Container
# Usage: ./stop.sh [clean|full|all]

set -e

VERSION="${1:-all}"

stop_container() {
    local name="$1"
    if docker ps -a --format '{{.Names}}' | grep -q "^$name$"; then
        echo "🛑 Stopping: $name"
        docker stop "$name" 2>/dev/null || true
        docker rm "$name" 2>/dev/null || true
        echo "✅ $name stopped"
    else
        echo "ℹ️  $name not running"
    fi
}

echo "=========================================="
echo "Stopping OpenClaw Containers"
echo "=========================================="

case "$VERSION" in
    clean)
        stop_container "openclaw-clean"
        ;;
    full)
        stop_container "openclaw-full"
        ;;
    all)
        stop_container "openclaw-clean"
        stop_container "openclaw-full"
        ;;
    *)
        echo "Usage: $0 [clean|full|all]"
        exit 1
        ;;
esac

echo "=========================================="
