#!/bin/bash
# Import OpenClaw Docker Images
# Usage: ./import.sh

set -e

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"

echo "=========================================="
echo "Importing OpenClaw Docker Images"
echo "=========================================="

if [ -f "$SCRIPT_DIR/openclaw-clean.tar.gz" ]; then
    echo ""
    echo "📦 Importing openclaw:clean..."
    gunzip -c "$SCRIPT_DIR/openclaw-clean.tar.gz" | docker load
    echo "✅ Imported: openclaw:clean"
fi

if [ -f "$SCRIPT_DIR/openclaw-full.tar.gz" ]; then
    echo ""
    echo "📦 Importing openclaw:full..."
    gunzip -c "$SCRIPT_DIR/openclaw-full.tar.gz" | docker load
    echo "✅ Imported: openclaw:full"
fi

echo ""
echo "=========================================="
echo "Import completed!"
echo ""
echo "Run './start.sh clean' or './start.sh full' to start"
echo "=========================================="
