# SKILL.md 元数据格式示例

---
name: openclaw-deploy
description: Build and deploy OpenClaw as Docker images or portable packages
author: zfanmy-梦月儿
version: 1.0.1
homepage: 
license: MIT
keywords:
  - openclaw
  - deploy
  - docker
  - portable
  - backup
  - migration
requires:
  bins:
    - node
    - npm
    - tar
---

# OpenClaw Deploy

Build and deploy OpenClaw as Docker images or portable packages.

## Features

- 🐳 Build Docker images (clean/full versions)
- 📦 Create portable packages for deployment
- 🚀 Deploy to remote servers with one command
- 💾 Backup and restore configurations

## Quick Start

### Build Portable Packages

```bash
# Build both clean and full versions
./scripts/build-portable.sh

# Export for deployment
./scripts/export-portable.sh
```

### Deploy to Remote Server

```bash
# Deploy clean version
./export/deploy.sh user@remote-server clean /opt/openclaw

# Deploy full version
./export/deploy.sh user@remote-server full /opt/openclaw
```

## Directory Structure

```
openclaw-deploy/
├── portable/clean/          # Clean version (no personal data)
├── portable/full/           # Full version (with config)
├── export/                  # Deployment packages
│   ├── openclaw-clean-portable.tar.gz
│   ├── openclaw-full-portable.tar.gz
│   └── deploy.sh
└── scripts/
    ├── build-portable.sh
    ├── export-portable.sh
    └── deploy.sh
```

## Usage on Target Server

```bash
# Install Node.js
./install-node.sh

# Start OpenClaw
cd clean && ./start.sh   # or cd full && ./start.sh

# Access WebUI
open http://localhost:18789
```

## Requirements

- Node.js 22.x
- Docker (optional, for Docker builds)
- curl, rsync (for deployment)

## Configuration

### Environment Variables

You can customize paths using environment variables:

```bash
# OpenClaw installation directory (default: auto-detect)
export OPENCLAW_INSTALL_DIR=/path/to/openclaw

# OpenClaw config directory (default: ~/.openclaw)
export OPENCLAW_CONFIG_DIR=/path/to/.openclaw

# Output directory (default: ./openclaw-portable-output)
export OUTPUT_DIR=/path/to/output
```

### Example with Custom Paths

```bash
export OPENCLAW_INSTALL_DIR=/opt/openclaw
export OPENCLAW_CONFIG_DIR=/opt/config/.openclaw
export OUTPUT_DIR=/tmp/openclaw-packages

./scripts/build-portable.sh
```

## Changelog

### v1.0.1
- Fixed hardcoded paths
- Added environment variable support
- Improved error handling and dependency checks
- Added path validation

### v1.0.0
- Initial release

## Author

zfanmy-梦月儿
