# OpenClaw Docker 部署方案

包含两个版本的 OpenClaw Docker 镜像：

## 📁 目录结构

```
/home/zfanmy/openclaw_docker/
├── base/                  # 基础镜像 Dockerfile
│   └── Dockerfile
├── clean/                 # 纯净版（无个人数据）
│   ├── Dockerfile
│   └── config/
│       └── openclaw.json  # 最小化配置
├── full/                  # 完整版（含 DreamMoon 配置）
│   └── Dockerfile
├── scripts/               # 构建和运行脚本
│   ├── build.sh          # 构建镜像
│   ├── start.sh          # 启动容器
│   ├── stop.sh           # 停止容器
│   ├── export.sh         # 导出镜像
│   └── import.sh         # 导入镜像
├── docker-compose.yml    # Docker Compose 配置
└── export/               # 导出的部署包（构建后生成）
```

## 🚀 快速开始

### 1. 构建镜像

```bash
cd /home/zfanmy/openclaw_docker/scripts

# 构建所有镜像
./build.sh all

# 或单独构建
./build.sh clean   # 仅纯净版
./build.sh full    # 仅完整版
```

### 2. 启动服务

**使用脚本启动：**
```bash
# 启动纯净版（端口 18789）
./start.sh clean

# 启动完整版（端口 18789）
./start.sh full

# 指定端口
./start.sh clean 8080
```

**使用 Docker Compose：**
```bash
cd /home/zfanmy/openclaw_docker

# 启动纯净版
docker-compose up -d openclaw-clean

# 启动完整版（端口 18790）
docker-compose up -d openclaw-full

# 启动全部
docker-compose up -d
```

### 3. 停止服务

```bash
./stop.sh all      # 停止所有
./stop.sh clean    # 仅停止纯净版
./stop.sh full     # 仅停止完整版
```

## 📦 部署到其他服务器

### 导出镜像
```bash
./export.sh
```

导出的文件在 `/home/zfanmy/openclaw_docker/export/`

### 传输到目标服务器
```bash
scp -r /home/zfanmy/openclaw_docker/export/* user@remote-server:/opt/openclaw/
```

### 在目标服务器上导入并运行
```bash
ssh user@remote-server
cd /opt/openclaw
./import.sh
./start.sh clean   # 或 full
```

## 🔧 版本说明

| 版本 | 说明 | 使用场景 |
|------|------|----------|
| **clean** | 纯净版，无个人配置和历史对话 | 新环境部署、共享使用 |
| **full** | 完整版，含 DreamMoon 配置和对话记录 | 迁移现有服务、备份恢复 |

## 📝 配置说明

- **clean 版本**：使用 `clean/config/openclaw.json` 中的最小化配置，需自行配置 API Key 和渠道
- **full 版本**：包含当前所有配置（飞书、网关 token 等），可直接使用

## 🔗 访问地址

启动后访问：
- 本地: http://localhost:18789
- 局域网: http://<服务器IP>:18789
