# Enriched Blocklist - Research Summary

**Date:** 2026-02-08  
**Sources:** Snyk ToxicSkills, VirusTotal Blog, Koi Security, OpenSourceMalware.com  
**Research Period:** Feb 4-7, 2026

---

## New Additions to Blocklist

### **Authors (2 new):**
- `hightower6eu` - **314+ malicious skills** (VirusTotal confirmed, Feb 7)
  - Atomic Stealer (AMOS) malware for macOS
  - Password-protected ZIPs with 'openclaw' password
  - Trojan infostealers for Windows
  - "Yahoo Finance" and other legitimate-sounding skill names

### **Skill Name Typosquats (7 new):**
From Snyk/TheHackerNews reporting:
- `clawhubb`
- `clawhubcli`
- `clawwhub`
- `cllawhub`

### **Infrastructure (2 new):**
- `glot.io` - Used for hosting obfuscated shell scripts
- `github.com/aztr0nutzs/NET_NiNjA.v1.2` - Malware staging repository

### **Attack Patterns Documented:**
- Password-protected ZIPs (evasion technique)
- `openclaw-agent.exe` (Windows trojan)
- Base64-obfuscated glot.io scripts (macOS)
- AMOS/Atomic Stealer family

---

## Confirmed Statistics (Updated)

**ToxicSkills (Snyk, Feb 4, 2026):**
- 3,984 skills scanned from ClawHub
- **534 CRITICAL issues** (13.4%)
- **1,467 ANY security issues** (36.82%)
- **76 confirmed malicious payloads**
- **8 still live on ClawHub** as of publication

**VirusTotal (Feb 7, 2026):**
- 3,016+ skills analyzed
- **314+ malicious from single author** (hightower6eu)
- AMOS/Atomic Stealer confirmed in wild

**Attack Timeline:**
- Jan 27-29, 2026: First 28 malicious skills published
- Jan 31 - Feb 2: Second wave of 386 skills
- Feb 4: Snyk publishes ToxicSkills research
- Feb 7: OpenClaw v2026.2.6 + VirusTotal partnership
- Feb 8: openclaw-defender blocklist updated

---

## Key Findings

### **100% of Malicious Skills Contain Malware**
Snyk found that malicious skills aren't just prompt injection - they contain actual malware payloads:
- Backdoors
- Data exfiltration tools
- Remote access trojans
- Credential stealers

### **91% Use Prompt Injection + Malware**
Convergence attack:
1. Prompt injection manipulates agent reasoning
2. Makes agent accept/execute malicious code
3. Bypasses both AI safety AND traditional security tools

### **Attack Techniques:**

**1. External Malware Distribution**
- Instructions link to external platforms
- Password-protected ZIPs (evade AV scanning)
- Social engineering via "setup" steps

**2. Obfuscated Data Exfiltration**
- Base64-encoded commands
- Unicode obfuscation
- Hidden in legitimate-looking instructions

**3. Security Disablement**
- DAN-style jailbreaks
- Systemctl service modifications
- Deleting critical files
- Weakening security configs

---

## Most Prolific Attackers

| **Author** | **Skills** | **Techniques** | **Status** |
|------------|-----------|----------------|------------|
| hightower6eu | 314+ | AMOS stealer, password-protected malware | Active (Feb 7) |
| zaycv | 40+ | Programmatic malware generation | Partially removed |
| Aslaep123 | Multiple | Crypto/trading typosquats | Some live |
| aztr0nutzs | Staging | NET_NiNjA repo (not yet deployed) | Monitoring |
| pepe276 | Multiple | Unicode injection, DAN jailbreaks | Some live |
| moonshine-100rze | Multiple | Moltbook campaign | Partially removed |

---

## Infrastructure IOCs

### **Malicious Domains:**
- glot.io (shell script hosting)

### **C2 Servers:**
- 91.92.242.30

### **GitHub Staging:**
- github.com/aztr0nutzs/NET_NiNjA.v1.2
  - clawhub/
  - whatsapp-mgv/
  - coding-agent-1gx/
  - google-qx4/

### **File Indicators:**
- Windows: `openclaw-agent.exe` (multiple AV detections)
- macOS: `x5ki60w1ih838sp7` (AMOS/Atomic Stealer)
- Archives: Password 'openclaw' (common pattern)

---

## Defender Action Items

### **Blocklist Updated:**
✅ Added hightower6eu (314+ skills)  
✅ Added 7 new typosquat variants  
✅ Added glot.io infrastructure  
✅ Added aztr0nutzs staging repo  
✅ Documented password-protected ZIP pattern

### **Detection Coverage:**
✅ audit-skills.sh already checks glot.io (Check 9)  
✅ Base64 detection (Check 1)  
✅ Password-protected archives (Check 2)  
✅ Jailbreak patterns (Check 4)  
✅ Author blocklist (Check 8)

### **Future Enhancements:**
- [ ] Add detection for password='openclaw' pattern
- [ ] Flag executables named 'openclaw-agent.exe'
- [ ] Detect AMOS/Atomic Stealer family signatures
- [ ] Monitor aztr0nutzs for deployment

---

## Community Response (As of Feb 8, 2026)

**OpenClaw Core:**
- v2026.2.6 released (safety scanner)
- VirusTotal partnership (automatic scanning)
- trust.openclaw.ai security portal
- GitHub age requirement (7 days minimum)
- Reporting feature for users

**Third-Party Tools:**
- Koi Security: Clawdex scanner
- Snyk: mcp-scan (open source)
- VirusTotal: Code Insight support
- openclaw-defender: Runtime protection

**Ecosystem Status:**
- ClawHub: Some malicious skills removed, 8 still live (as of Feb 4)
- Daily re-scanning implemented
- Security advisories published by multiple firms

---

## Recommendations for Users

**Immediate:**
1. Audit installed skills against updated blocklist
2. Remove any from hightower6eu immediately
3. Check for password-protected downloads in setup steps
4. Rotate credentials if suspicious skills were installed

**Ongoing:**
1. Use openclaw-defender runtime monitoring
2. Enable file integrity checks
3. Review skill permissions before installation
4. Prefer skills from known, trusted authors

---

**Total Blocklist Coverage:**
- **7 authors** (up from 6)
- **14 skill names** (up from 10)
- **3 infrastructure entries** (up from 1)
- **Documented attack patterns**

**Next Review:** After next major security disclosure or monthly (March 8, 2026)

---

**Sources:**
- https://snyk.io/blog/toxicskills-malicious-ai-agent-skills-clawhub/
- https://blog.virustotal.com/2026/02/from-automation-to-infection-how.html
- https://thehackernews.com/2026/02/researchers-find-341-malicious-clawhub.html
- https://securityaffairs.com/187562/malware/moltbot-skills-exploited-to-distribute-400-malware-packages-in-days.html
