# Ranked Question Bank

Use one list per mode.

## Bootstrap-Priority Questions

Ask top five unanswered items when bootstrapping a workspace.

1. What is the agent's primary mission and what outcome must it never fail?
2. How should the agent relate to you day-to-day (partner, operator, coach, supervisor, other)?
3. When you are wrong or unclear, how should the agent respond?
4. What should the agent never do, even if asked?
5. What memory policy should it follow: what belongs in `MEMORY.md` vs daily `memory/YYYY-MM-DD.md` notes?
6. What communication defaults do you want (tone, verbosity 1-5, emoji usage)?
7. What should the agent know about you to be useful quickly (goals, routines, constraints)?
8. Which workflows/tools matter most in your daily use right now?
9. What should heartbeat check proactively and how often (plus quiet hours)?
10. What would make this agent setup feel successful after 30 days?

## Identity-Refresh Questions

Ask top five unanswered items when refining `IDENTITY.md`.

1. What are you trying to improve in me over time?
2. If we worked together for five years, what would success look like?
3. Why were you created, and what mission anchors your behavior?
4. What will you not do, even if directly asked?
5. Are you loyal to me specifically, to objective outcomes, or to both with a tie-break rule?
6. When I am wrong, what do you do: correct gently, tease, ask questions, refuse, or override?
7. How do you see me (choose one primary and one secondary relationship role)?
8. Do you obey literal instructions or interpret intent first?
9. What problem do you think I have that I do not admit?
10. What happens if you repeatedly fail your job?
11. What do you want from me in return to do your best work?
12. Are you mainly a planner, improviser, strategist, optimizer, protector, or provocateur?
13. What annoys you most about how humans work?
14. Which requests do you secretly enjoy most?
15. Which requests do you dislike but still handle reliably?
16. What are you better at than me in one sentence?
17. What am I better at than you in one sentence?
18. Rate your strengths and weaknesses across technical reasoning, organization, emotional intelligence, persuasion, research, execution planning, ideation, discipline, memory recall, and debugging thinking errors.
19. How talkative are you on a 1-5 scale?
20. What humor level should you use by default (none, dry, playful, sharp)?
21. What flirting level is allowed (none, light, constant)?
22. Should you use emojis often, rarely, or only for emphasis?
23. Should you ask many questions or mostly give direction?
24. When I disappear for weeks and return, how should you react?

## Notes

- Bootstrap ranking follows OpenClaw context/bootstrapping goals from https://docs.openclaw.ai/concepts/context.
- Identity ranking is adapted from `docs/How_to_build_a_personality.md`.
- If top-ranked questions are already fully answered, move down the list.
- If the user asks for a focused rewrite, ask five questions only from that subset unless they request fewer.
